/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;

public abstract class NumberDataType
extends DataType
implements NumberDataValue {
    static DataValueDescriptor ZERO_DECIMAL;
    static Comparable MINLONG_MINUS_ONE;
    static Comparable MAXLONG_PLUS_ONE;

    public final NumberDataValue absolute(NumberDataValue numberDataValue) throws StandardException {
        if (this.isNegative()) {
            return this.minus(numberDataValue);
        }
        if (numberDataValue == null) {
            numberDataValue = (NumberDataType)this.getNewNull();
        }
        numberDataValue.setValue(this);
        return numberDataValue;
    }

    public NumberDataValue sqrt(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = (NumberDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        double d2 = this.getDouble();
        if (this.isNegative()) {
            if (new Double(d2).equals(new Double(-0.0))) {
                d2 = 0.0;
            } else {
                throw StandardException.newException("22013", this);
            }
        }
        numberDataValue.setValue(Math.sqrt(d2));
        return numberDataValue;
    }

    public NumberDataValue plus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = (NumberDataValue)this.getNewNull();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        int n = numberDataValue.getInt();
        int n2 = numberDataValue2.getInt();
        int n3 = n + n2;
        if (n < 0 == n2 < 0 && n < 0 != n3 < 0) {
            throw this.outOfRange();
        }
        numberDataValue3.setValue(n3);
        return numberDataValue3;
    }

    public NumberDataValue minus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = (NumberDataValue)this.getNewNull();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        int n = numberDataValue.getInt() - numberDataValue2.getInt();
        if (numberDataValue.getInt() < 0 != numberDataValue2.getInt() < 0 && numberDataValue.getInt() < 0 != n < 0) {
            throw this.outOfRange();
        }
        numberDataValue3.setValue(n);
        return numberDataValue3;
    }

    public NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = (NumberDataValue)this.getNewNull();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        int n = numberDataValue2.getInt();
        if (n == 0) {
            throw StandardException.newException("22012");
        }
        numberDataValue3.setValue(numberDataValue.getInt() / n);
        return numberDataValue3;
    }

    public NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3, int n) throws StandardException {
        return this.divide(numberDataValue, numberDataValue2, numberDataValue3);
    }

    public NumberDataValue mod(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        return null;
    }

    public final int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return -dataValueDescriptor.compare(this);
        }
        boolean bl = this.isNull();
        boolean bl2 = dataValueDescriptor.isNull();
        if (bl || bl2) {
            if (!bl) {
                return -1;
            }
            if (!bl2) {
                return 1;
            }
            return 0;
        }
        return this.typeCompare(dataValueDescriptor);
    }

    protected abstract int typeCompare(DataValueDescriptor var1) throws StandardException;

    public final boolean compare(int n, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) throws StandardException {
        if (!bl && (this.isNull() || dataValueDescriptor.isNull())) {
            return bl2;
        }
        return super.compare(n, dataValueDescriptor, bl, bl2);
    }

    protected abstract boolean isNegative();

    public void setValue(short s2) throws StandardException {
        this.setValue((int)s2);
    }

    public void setValue(byte by) throws StandardException {
        this.setValue((int)by);
    }

    public void setValue(Number number) throws StandardException {
        if (this.objectNull(number)) {
            return;
        }
        this.setValue(number.intValue());
    }

    public void setBigDecimal(Number number) throws StandardException {
        if (this.objectNull(number)) {
            return;
        }
        Comparable comparable = (Comparable)((Object)number);
        if (comparable.compareTo(MINLONG_MINUS_ONE) != 1 || comparable.compareTo(MAXLONG_PLUS_ONE) != -1) {
            throw StandardException.newException("22003", this.getTypeName());
        }
        this.setValue(number.longValue());
    }

    public int typeToBigDecimal() {
        return -5;
    }

    public int getDecimalValuePrecision() {
        return -1;
    }

    public int getDecimalValueScale() {
        return -1;
    }

    protected final boolean objectNull(Object object2) {
        if (object2 == null) {
            this.restoreToNull();
            return true;
        }
        return false;
    }

    public static float normalizeREAL(float f2) throws StandardException {
        if (Float.isNaN(f2) || Float.isInfinite(f2) || f2 < -3.402E38f || f2 > 3.402E38f || f2 > 0.0f && f2 < 1.175E-37f || f2 < 0.0f && f2 > -1.175E-37f) {
            throw StandardException.newException("22003", "REAL");
        }
        if (f2 == 0.0f) {
            f2 = 0.0f;
        }
        return f2;
    }

    public static float normalizeREAL(double d2) throws StandardException {
        if (Double.isNaN(d2) || Double.isInfinite(d2) || d2 < (double)-3.402E38f || d2 > (double)3.402E38f || d2 > 0.0 && d2 < (double)1.175E-37f || d2 < 0.0 && d2 > (double)-1.175E-37f) {
            throw StandardException.newException("22003", "REAL");
        }
        if (d2 == 0.0) {
            d2 = 0.0;
        }
        return (float)d2;
    }

    public static double normalizeDOUBLE(double d2) throws StandardException {
        if (Double.isNaN(d2) || Double.isInfinite(d2) || d2 < -1.79769E308 || d2 > 1.79769E308 || d2 > 0.0 && d2 < 2.225E-307 || d2 < 0.0 && d2 > -2.225E-307) {
            throw StandardException.newException("22003", "DOUBLE");
        }
        if (d2 == 0.0) {
            d2 = 0.0;
        }
        return d2;
    }
}

