/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.raw;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.store.raw.ContainerLock;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.util.Matchable;

public final class ContainerKey
implements Matchable,
Lockable {
    private final long segmentId;
    private final long containerId;

    public ContainerKey(long l, long l2) {
        this.segmentId = l;
        this.containerId = l2;
    }

    public long getContainerId() {
        return this.containerId;
    }

    public long getSegmentId() {
        return this.segmentId;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        CompressedNumber.writeLong(objectOutput, this.segmentId);
        CompressedNumber.writeLong(objectOutput, this.containerId);
    }

    public static ContainerKey read(ObjectInput objectInput) throws IOException {
        long l = CompressedNumber.readLong(objectInput);
        long l2 = CompressedNumber.readLong(objectInput);
        return new ContainerKey(l, l2);
    }

    public boolean equals(Object object2) {
        if (object2 == this) {
            return true;
        }
        if (object2 instanceof ContainerKey) {
            ContainerKey containerKey = (ContainerKey)object2;
            return this.containerId == containerKey.containerId && this.segmentId == containerKey.segmentId;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.segmentId ^ this.containerId);
    }

    public String toString() {
        return "Container(" + this.segmentId + ", " + this.containerId + ")";
    }

    public boolean match(Object object2) {
        if (this.equals(object2)) {
            return true;
        }
        if (object2 instanceof PageKey) {
            return this.equals(((PageKey)object2).getContainerId());
        }
        if (object2 instanceof RecordHandle) {
            return this.equals(((RecordHandle)object2).getContainerId());
        }
        return false;
    }

    public void lockEvent(Latch latch) {
    }

    public boolean requestCompatible(Object object2, Object object3) {
        ContainerLock containerLock = (ContainerLock)object2;
        ContainerLock containerLock2 = (ContainerLock)object3;
        return containerLock.isCompatible(containerLock2);
    }

    public boolean lockerAlwaysCompatible() {
        return true;
    }

    public void unlockEvent(Latch latch) {
    }

    public boolean lockAttributes(int n, Hashtable hashtable) {
        if ((n & 2) == 0) {
            return false;
        }
        hashtable.put("CONTAINERID", new Long(this.getContainerId()));
        hashtable.put("LOCKNAME", "Tablelock");
        hashtable.put("TYPE", "TABLE");
        return true;
    }
}

