/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.access;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.InstanceGetter;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;

public class RowUtil {
    public static final DataValueDescriptor[] EMPTY_ROW = new DataValueDescriptor[0];
    public static final FormatableBitSet EMPTY_ROW_BITSET = new FormatableBitSet(0);
    public static final FetchDescriptor EMPTY_ROW_FETCH_DESCRIPTOR = new FetchDescriptor(0);
    public static final FetchDescriptor[] ROWUTIL_FETCH_DESCRIPTOR_CONSTANTS = new FetchDescriptor[]{EMPTY_ROW_FETCH_DESCRIPTOR, new FetchDescriptor(1, 1), new FetchDescriptor(2, 2), new FetchDescriptor(3, 3), new FetchDescriptor(4, 4), new FetchDescriptor(5, 5), new FetchDescriptor(6, 6), new FetchDescriptor(7, 7)};

    private RowUtil() {
    }

    public static DataValueDescriptor getColumn(DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet, int n) {
        if (formatableBitSet == null) {
            return n < dataValueDescriptorArray.length ? dataValueDescriptorArray[n] : null;
        }
        if (formatableBitSet.getLength() <= n || !formatableBitSet.isSet(n)) {
            return null;
        }
        return n < dataValueDescriptorArray.length ? dataValueDescriptorArray[n] : null;
    }

    public static Object getColumn(Object[] objectArray, FormatableBitSet formatableBitSet, int n) {
        if (formatableBitSet == null) {
            return n < objectArray.length ? objectArray[n] : null;
        }
        if (formatableBitSet.getLength() <= n || !formatableBitSet.isSet(n)) {
            return null;
        }
        return n < objectArray.length ? objectArray[n] : null;
    }

    public static FormatableBitSet getQualifierBitSet(Qualifier[][] qualifierArray) {
        FormatableBitSet formatableBitSet = new FormatableBitSet();
        if (qualifierArray != null) {
            for (int j = 0; j < qualifierArray.length; ++j) {
                for (int k = 0; k < qualifierArray[j].length; ++k) {
                    int n = qualifierArray[j][k].getColumnId();
                    formatableBitSet.grow(n + 1);
                    formatableBitSet.set(n);
                }
            }
        }
        return formatableBitSet;
    }

    public static int getNumberOfColumns(int n, FormatableBitSet formatableBitSet) {
        int n2 = formatableBitSet.getLength();
        if (n > 0 && n < n2) {
            n2 = n;
        }
        int n3 = 0;
        for (int j = 0; j < n2; ++j) {
            if (!formatableBitSet.isSet(j)) continue;
            ++n3;
        }
        return n3;
    }

    public static boolean isRowEmpty(DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet) {
        if (dataValueDescriptorArray == null) {
            return true;
        }
        if (dataValueDescriptorArray.length == 0) {
            return true;
        }
        if (formatableBitSet == null) {
            return false;
        }
        int n = formatableBitSet.getLength();
        for (int j = 0; j < n; --j) {
            if (!formatableBitSet.isSet(j)) continue;
            return true;
        }
        return false;
    }

    public static int columnOutOfRange(DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet, int n) {
        if (formatableBitSet == null) {
            if (dataValueDescriptorArray.length > n) {
                return n;
            }
            return -1;
        }
        int n2 = formatableBitSet.getLength();
        for (int j = n; j < n2; ++j) {
            if (!formatableBitSet.isSet(j)) continue;
            return j;
        }
        return -1;
    }

    public static int nextColumn(Object[] objectArray, FormatableBitSet formatableBitSet, int n) {
        if (formatableBitSet != null) {
            int n2 = formatableBitSet.getLength();
            while (n < n2) {
                if (formatableBitSet.isSet(n)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
        if (objectArray == null) {
            return -1;
        }
        return n < objectArray.length ? n : -1;
    }

    public static final FetchDescriptor getFetchDescriptorConstant(int n) {
        if (n < ROWUTIL_FETCH_DESCRIPTOR_CONSTANTS.length) {
            return ROWUTIL_FETCH_DESCRIPTOR_CONSTANTS[n];
        }
        return new FetchDescriptor(n, n);
    }

    public static InstanceGetter[] newClassInfoTemplate(FormatableBitSet formatableBitSet, int[] nArray) throws StandardException {
        int n = nArray.length;
        InstanceGetter[] instanceGetterArray = new InstanceGetter[n];
        int n2 = formatableBitSet == null ? 0 : formatableBitSet.getLength();
        for (int j = 0; j < n; ++j) {
            if (formatableBitSet != null && (n2 <= j || !formatableBitSet.isSet(j))) continue;
            instanceGetterArray[j] = Monitor.classFromIdentifier(nArray[j]);
        }
        return instanceGetterArray;
    }

    private static void newRowFromClassInfoTemplateError() {
    }

    public static DataValueDescriptor[] newRowFromClassInfoTemplate(InstanceGetter[] instanceGetterArray) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[instanceGetterArray.length];
        try {
            int n = instanceGetterArray.length;
            while (n-- > 0) {
                if (instanceGetterArray[n] == null) continue;
                dataValueDescriptorArray[n] = (DataValueDescriptor)instanceGetterArray[n].getNewInstance();
            }
        }
        catch (InstantiationException instantiationException) {
            RowUtil.newRowFromClassInfoTemplateError();
        }
        catch (IllegalAccessException illegalAccessException) {
            RowUtil.newRowFromClassInfoTemplateError();
        }
        catch (InvocationTargetException invocationTargetException) {
            RowUtil.newRowFromClassInfoTemplateError();
        }
        return dataValueDescriptorArray;
    }

    public static String toString(Object[] objectArray) {
        return null;
    }

    public static String toString(Hashtable hashtable) {
        return null;
    }

    public static final boolean qualifyRow(Object[] objectArray, Qualifier[][] qualifierArray) throws StandardException {
        Object object2;
        int n;
        boolean bl = true;
        for (n = 0; n < qualifierArray[0].length; ++n) {
            bl = false;
            Qualifier qualifier = qualifierArray[0][n];
            object2 = (DataValueDescriptor)objectArray[qualifier.getColumnId()];
            bl = object2.compare(qualifier.getOperator(), qualifier.getOrderable(), qualifier.getOrderedNulls(), qualifier.getUnknownRV());
            if (qualifier.negateCompareResult()) {
                boolean bl2 = bl = !bl;
            }
            if (bl) continue;
            return false;
        }
        for (n = 1; n < qualifierArray.length; ++n) {
            bl = false;
            for (int j = 0; j < qualifierArray[n].length; ++j) {
                object2 = qualifierArray[n][j];
                int n2 = object2.getColumnId();
                DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)objectArray[object2.getColumnId()];
                bl = dataValueDescriptor.compare(object2.getOperator(), object2.getOrderable(), object2.getOrderedNulls(), object2.getUnknownRV());
                if (object2.negateCompareResult()) {
                    boolean bl3 = bl = !bl;
                }
                if (bl) break;
            }
            if (!bl) break;
        }
        return bl;
    }
}

