/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.access;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.KeyHasher;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLInteger;

public class DiskHashtable {
    private final long rowConglomerateId;
    private ConglomerateController rowConglomerate;
    private final long btreeConglomerateId;
    private ConglomerateController btreeConglomerate;
    private final DataValueDescriptor[] btreeRow;
    private final int[] key_column_numbers;
    private final boolean remove_duplicates;
    private final TransactionController tc;
    private final DataValueDescriptor[] row;
    private final DataValueDescriptor[] scanKey = new DataValueDescriptor[]{new SQLInteger()};
    private int size;
    private boolean keepStatistics;

    public DiskHashtable(TransactionController transactionController, DataValueDescriptor[] dataValueDescriptorArray, int[] nArray, boolean bl, boolean bl2) throws StandardException {
        int n;
        this.tc = transactionController;
        this.key_column_numbers = nArray;
        this.remove_duplicates = bl;
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)ContextService.getContextOrNull("LanguageConnectionContext");
        this.keepStatistics = languageConnectionContext != null && languageConnectionContext.getRunTimeStatisticsMode();
        this.row = new DataValueDescriptor[dataValueDescriptorArray.length];
        for (n = 0; n < this.row.length; ++n) {
            this.row[n] = dataValueDescriptorArray[n].getNewNull();
        }
        n = bl2 ? 3 : 1;
        this.rowConglomerateId = transactionController.createConglomerate("heap", dataValueDescriptorArray, null, null, n);
        this.rowConglomerate = transactionController.openConglomerate(this.rowConglomerateId, bl2, 4, 7, 0);
        this.btreeRow = new DataValueDescriptor[]{new SQLInteger(), this.rowConglomerate.newRowLocationTemplate()};
        Properties properties = new Properties();
        properties.put("baseConglomerateId", String.valueOf(this.rowConglomerateId));
        properties.put("rowLocationColumn", "1");
        properties.put("allowDuplicates", "false");
        properties.put("nKeyFields", "2");
        properties.put("nUniqueColumns", "2");
        properties.put("maintainParentLinks", "false");
        this.btreeConglomerateId = transactionController.createConglomerate("BTREE", this.btreeRow, null, properties, n);
        this.btreeConglomerate = transactionController.openConglomerate(this.btreeConglomerateId, bl2, 4, 7, 0);
    }

    public void close() throws StandardException {
        this.btreeConglomerate.close();
        this.rowConglomerate.close();
        this.tc.dropConglomerate(this.btreeConglomerateId);
        this.tc.dropConglomerate(this.rowConglomerateId);
    }

    public boolean put(Object object2, Object[] objectArray) throws StandardException {
        boolean bl = false;
        if (this.remove_duplicates || this.keepStatistics) {
            boolean bl2 = bl = this.getRemove(object2, false, true) != null;
            if (this.remove_duplicates && bl) {
                return false;
            }
        }
        this.rowConglomerate.insertAndFetchLocation((DataValueDescriptor[])objectArray, (RowLocation)this.btreeRow[1]);
        this.btreeRow[0].setValue(object2.hashCode());
        this.btreeConglomerate.insert(this.btreeRow);
        if (this.keepStatistics && !bl) {
            ++this.size;
        }
        return true;
    }

    public Object get(Object object2) throws StandardException {
        return this.getRemove(object2, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getRemove(Object object2, boolean bl, boolean bl2) throws StandardException {
        int n = object2.hashCode();
        int n2 = 0;
        Object[] objectArray = null;
        this.scanKey[0].setValue(n);
        ScanController scanController = this.tc.openScan(this.btreeConglomerateId, false, bl ? 4 : 0, 7, 1, null, this.scanKey, 1, null, this.scanKey, -1);
        try {
            while (scanController.fetchNext(this.btreeRow)) {
                Object[] objectArray2;
                if (!this.rowConglomerate.fetch((RowLocation)this.btreeRow[1], this.row, null) || !this.rowMatches(this.row, object2)) continue;
                if (bl2) {
                    objectArray2 = this;
                    return objectArray2;
                }
                if (++n2 == 1) {
                    objectArray = BackingStoreHashtable.cloneRow(this.row);
                } else {
                    if (n2 == 2) {
                        objectArray2 = new Vector(2);
                        objectArray2.add(objectArray);
                        objectArray = objectArray2;
                    } else {
                        objectArray2 = (Vector)objectArray;
                    }
                    objectArray2.add(BackingStoreHashtable.cloneRow(this.row));
                }
                if (bl) {
                    this.rowConglomerate.delete((RowLocation)this.btreeRow[1]);
                    scanController.delete();
                    --this.size;
                }
                if (!this.remove_duplicates) continue;
                objectArray2 = objectArray;
                return objectArray2;
            }
        }
        finally {
            scanController.close();
        }
        return objectArray;
    }

    private boolean rowMatches(DataValueDescriptor[] dataValueDescriptorArray, Object object2) {
        if (this.key_column_numbers.length == 1) {
            return dataValueDescriptorArray[this.key_column_numbers[0]].equals(object2);
        }
        KeyHasher keyHasher = (KeyHasher)object2;
        for (int j = 0; j < this.key_column_numbers.length; ++j) {
            if (dataValueDescriptorArray[this.key_column_numbers[j]].equals(keyHasher.getObject(j))) continue;
            return false;
        }
        return true;
    }

    public Object remove(Object object2) throws StandardException {
        return this.getRemove(object2, true, false);
    }

    public int size() {
        return this.size;
    }

    public Enumeration elements() throws StandardException {
        return new ElementEnum();
    }

    private class ElementEnum
    implements Enumeration {
        private ScanController scan;
        private boolean hasMore;

        ElementEnum() {
            block5: {
                try {
                    this.scan = DiskHashtable.this.tc.openScan(DiskHashtable.this.rowConglomerateId, false, 0, 7, 0, null, null, 0, null, null, 0);
                    this.hasMore = this.scan.next();
                    if (!this.hasMore) {
                        this.scan.close();
                        this.scan = null;
                    }
                }
                catch (StandardException standardException) {
                    this.hasMore = false;
                    if (this.scan == null) break block5;
                    try {
                        this.scan.close();
                    }
                    catch (StandardException standardException2) {
                        // empty catch block
                    }
                    this.scan = null;
                }
            }
        }

        public boolean hasMoreElements() {
            return this.hasMore;
        }

        public Object nextElement() {
            if (!this.hasMore) {
                throw new NoSuchElementException();
            }
            try {
                this.scan.fetch(DiskHashtable.this.row);
                Object[] objectArray = BackingStoreHashtable.cloneRow(DiskHashtable.this.row);
                this.hasMore = this.scan.next();
                if (!this.hasMore) {
                    this.scan.close();
                    this.scan = null;
                }
                return objectArray;
            }
            catch (StandardException standardException) {
                if (this.scan != null) {
                    try {
                        this.scan.close();
                    }
                    catch (StandardException standardException2) {
                        // empty catch block
                    }
                    this.scan = null;
                }
                throw new NoSuchElementException();
            }
        }
    }
}

