/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.access;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.store.access.DiskHashtable;
import org.apache.derby.iapi.store.access.KeyHasher;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.PropertyUtil;

public class BackingStoreHashtable {
    private TransactionController tc;
    private Hashtable hash_table;
    private int[] key_column_numbers;
    private boolean remove_duplicates;
    private boolean skipNullKeyColumns;
    private Properties auxillary_runtimestats;
    private RowSource row_source;
    private long max_inmemory_rowcnt;
    private long inmemory_rowcnt;
    private long max_inmemory_size;
    private boolean keepAfterCommit;
    private static final int vectorSize = ClassSize.estimateBaseFromCatalog(class$java$util$Vector == null ? (class$java$util$Vector = BackingStoreHashtable.class$("java.util.Vector")) : class$java$util$Vector);
    private DiskHashtable diskHashtable;
    static /* synthetic */ Class class$java$util$Vector;

    private BackingStoreHashtable() {
    }

    public BackingStoreHashtable(TransactionController transactionController, RowSource rowSource, int[] nArray, boolean bl, long l, long l2, int n, float f2, boolean bl2, boolean bl3) throws StandardException {
        this.key_column_numbers = nArray;
        this.remove_duplicates = bl;
        this.row_source = rowSource;
        this.skipNullKeyColumns = bl2;
        this.max_inmemory_rowcnt = l2;
        this.max_inmemory_size = l2 > 0L ? Long.MAX_VALUE : Runtime.getRuntime().totalMemory() / 100L;
        this.tc = transactionController;
        this.keepAfterCommit = bl3;
        if (n != -1) {
            this.hash_table = f2 == -1.0f ? new Hashtable(n) : new Hashtable(n, f2);
        } else {
            Hashtable hashtable = l <= 0L || rowSource == null ? new Hashtable() : (this.hash_table = l < this.max_inmemory_size ? new Hashtable((int)l) : null);
        }
        if (rowSource != null) {
            Object[] objectArray;
            boolean bl4 = rowSource.needsToClone();
            while ((objectArray = this.getNextRowFromRowSource()) != null) {
                if (this.hash_table == null) {
                    double d2 = this.getEstimatedMemUsage(objectArray);
                    this.hash_table = new Hashtable((int)((double)this.max_inmemory_size / d2));
                }
                if (bl4) {
                    objectArray = BackingStoreHashtable.cloneRow(objectArray);
                }
                Object object2 = KeyHasher.buildHashKey(objectArray, nArray);
                this.add_row_to_hash_table(this.hash_table, object2, objectArray);
            }
        }
        if (this.hash_table == null) {
            this.hash_table = new Hashtable();
        }
    }

    private Object[] getNextRowFromRowSource() throws StandardException {
        Object[] objectArray = this.row_source.getNextRowFromRowSource();
        if (this.skipNullKeyColumns) {
            while (objectArray != null) {
                Storable storable;
                int n;
                for (n = 0; n < this.key_column_numbers.length && !(storable = (Storable)objectArray[this.key_column_numbers[n]]).isNull(); ++n) {
                }
                if (n == this.key_column_numbers.length) {
                    return objectArray;
                }
                objectArray = this.row_source.getNextRowFromRowSource();
            }
        }
        return objectArray;
    }

    static Object[] cloneRow(Object[] objectArray) throws StandardException {
        Object[] objectArray2 = new DataValueDescriptor[objectArray.length];
        for (int j = 0; j < objectArray.length; ++j) {
            if (objectArray[j] == null) continue;
            objectArray2[j] = ((DataValueDescriptor)objectArray[j]).getClone();
        }
        return objectArray2;
    }

    private void add_row_to_hash_table(Hashtable hashtable, Object object2, Object[] objectArray) throws StandardException {
        if (this.spillToDisk(hashtable, object2, objectArray)) {
            return;
        }
        Object[] objectArray2 = null;
        objectArray2 = hashtable.put(object2, objectArray);
        if (objectArray2 == null) {
            this.doSpaceAccounting(objectArray, false);
        } else if (!this.remove_duplicates) {
            Vector vector;
            if (objectArray2 instanceof Vector) {
                this.doSpaceAccounting(objectArray, false);
                vector = (Vector)objectArray2;
            } else {
                vector = new Vector(2);
                vector.addElement(objectArray2);
                this.doSpaceAccounting(objectArray, true);
            }
            vector.addElement(objectArray);
            hashtable.put(object2, vector);
        }
        objectArray = null;
    }

    private void doSpaceAccounting(Object[] objectArray, boolean bl) {
        ++this.inmemory_rowcnt;
        if (this.max_inmemory_rowcnt <= 0L) {
            this.max_inmemory_size -= this.getEstimatedMemUsage(objectArray);
            if (bl) {
                this.max_inmemory_size -= (long)vectorSize;
            }
        }
    }

    private boolean spillToDisk(Hashtable hashtable, Object object2, Object[] objectArray) throws StandardException {
        Object v;
        if (this.diskHashtable == null) {
            if (this.max_inmemory_rowcnt > 0L ? this.inmemory_rowcnt < this.max_inmemory_rowcnt : this.max_inmemory_size > 0L) {
                return false;
            }
            if (!(objectArray instanceof DataValueDescriptor[])) {
                return false;
            }
            this.diskHashtable = new DiskHashtable(this.tc, (DataValueDescriptor[])objectArray, this.key_column_numbers, this.remove_duplicates, this.keepAfterCommit);
        }
        if ((v = hashtable.get(object2)) != null) {
            if (this.remove_duplicates) {
                return true;
            }
            if (v instanceof Vector) {
                Vector vector = (Vector)v;
                for (int j = vector.size() - 1; j >= 0; --j) {
                    Object[] objectArray2 = (Object[])vector.elementAt(j);
                    this.diskHashtable.put(object2, objectArray2);
                }
            } else {
                this.diskHashtable.put(object2, (Object[])v);
            }
            hashtable.remove(object2);
        }
        this.diskHashtable.put(object2, objectArray);
        return true;
    }

    private long getEstimatedMemUsage(Object[] objectArray) {
        long l = 0L;
        for (int j = 0; j < objectArray.length; ++j) {
            if (objectArray[j] instanceof DataValueDescriptor) {
                l += (long)((DataValueDescriptor)objectArray[j]).estimateMemoryUsage();
            }
            l += (long)ClassSize.refSize;
        }
        return l += (long)ClassSize.refSize;
    }

    public void close() throws StandardException {
        this.hash_table = null;
        if (this.diskHashtable != null) {
            this.diskHashtable.close();
            this.diskHashtable = null;
        }
    }

    public Enumeration elements() throws StandardException {
        if (this.diskHashtable == null) {
            return this.hash_table.elements();
        }
        return new BackingStoreHashtableEnumeration();
    }

    public Object get(Object object2) throws StandardException {
        Object v = this.hash_table.get(object2);
        if (this.diskHashtable == null || v != null) {
            return v;
        }
        return this.diskHashtable.get(object2);
    }

    public void getAllRuntimeStats(Properties properties) throws StandardException {
        if (this.auxillary_runtimestats != null) {
            PropertyUtil.copyProperties(this.auxillary_runtimestats, properties);
        }
    }

    public Object remove(Object object2) throws StandardException {
        Object v = this.hash_table.remove(object2);
        if (v != null || this.diskHashtable == null) {
            return v;
        }
        return this.diskHashtable.remove(object2);
    }

    public void setAuxillaryRuntimeStats(Properties properties) throws StandardException {
        this.auxillary_runtimestats = properties;
    }

    public boolean put(boolean bl, Object[] objectArray) throws StandardException {
        if (this.skipNullKeyColumns) {
            for (int j = 0; j < this.key_column_numbers.length; ++j) {
                Storable storable = (Storable)objectArray[this.key_column_numbers[j]];
                if (!storable.isNull()) continue;
                return false;
            }
        }
        if (bl) {
            objectArray = BackingStoreHashtable.cloneRow(objectArray);
        }
        Object object2 = KeyHasher.buildHashKey(objectArray, this.key_column_numbers);
        if (this.remove_duplicates && this.get(object2) != null) {
            return false;
        }
        this.add_row_to_hash_table(this.hash_table, object2, objectArray);
        return true;
    }

    public int size() throws StandardException {
        if (this.diskHashtable == null) {
            return this.hash_table.size();
        }
        return this.hash_table.size() + this.diskHashtable.size();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BackingStoreHashtableEnumeration
    implements Enumeration {
        private Enumeration memoryEnumeration;
        private Enumeration diskEnumeration;

        BackingStoreHashtableEnumeration() {
            this.memoryEnumeration = BackingStoreHashtable.this.hash_table.elements();
            if (BackingStoreHashtable.this.diskHashtable != null) {
                try {
                    this.diskEnumeration = BackingStoreHashtable.this.diskHashtable.elements();
                }
                catch (StandardException standardException) {
                    this.diskEnumeration = null;
                }
            }
        }

        public boolean hasMoreElements() {
            if (this.memoryEnumeration != null) {
                if (this.memoryEnumeration.hasMoreElements()) {
                    return true;
                }
                this.memoryEnumeration = null;
            }
            if (this.diskEnumeration == null) {
                return false;
            }
            return this.diskEnumeration.hasMoreElements();
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.memoryEnumeration != null) {
                if (this.memoryEnumeration.hasMoreElements()) {
                    return this.memoryEnumeration.nextElement();
                }
                this.memoryEnumeration = null;
            }
            return this.diskEnumeration.nextElement();
        }
    }
}

