/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.StorablePreparedStatement;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueSQLObjectDescriptor;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.catalog.DataDictionaryImpl;

public class SPSDescriptor
extends TupleDescriptor
implements UniqueSQLObjectDescriptor,
Dependent,
Provider {
    public static final char SPS_TYPE_TRIGGER = 'T';
    public static final char SPS_TYPE_REGULAR = 'S';
    public static final char SPS_TYPE_EXPLAIN = 'X';
    private static final int RECOMPILE = 1;
    private static final int INVALIDATE = 0;
    private SchemaDescriptor sd;
    private String name;
    private UUID uuid;
    private UUID compSchemaId;
    private char type;
    private boolean valid;
    private String text;
    private String usingText;
    private ExecPreparedStatement preparedStatement;
    private DataTypeDescriptor[] params;
    private Timestamp compileTime;
    private Object[] paramDefaults;
    private boolean initiallyCompilable;
    private boolean lookedUpParams;
    private UUIDFactory uuidFactory;

    public SPSDescriptor(DataDictionary dataDictionary, String string, UUID uUID, UUID uUID2, UUID uUID3, char c2, boolean bl, String string2, String string3, Object[] objectArray, boolean bl2) throws StandardException {
        this(dataDictionary, string, uUID, uUID2, uUID3, c2, bl, string2, string3, null, null, bl2);
        this.paramDefaults = objectArray;
    }

    public SPSDescriptor(DataDictionary dataDictionary, String string, UUID uUID, UUID uUID2, UUID uUID3, char c2, boolean bl, String string2, String string3, Timestamp timestamp, ExecPreparedStatement execPreparedStatement, boolean bl2) throws StandardException {
        super(dataDictionary);
        this.name = string;
        this.uuid = uUID;
        this.type = c2;
        this.text = string2;
        this.usingText = string3;
        this.valid = bl;
        this.compileTime = timestamp;
        this.sd = dataDictionary.getSchemaDescriptor(uUID2, null);
        this.preparedStatement = execPreparedStatement;
        this.compSchemaId = uUID3;
        this.initiallyCompilable = bl2;
    }

    public final synchronized void prepareAndRelease(LanguageConnectionContext languageConnectionContext, TableDescriptor tableDescriptor) throws StandardException {
        this.compileStatement(languageConnectionContext, tableDescriptor);
        this.preparedStatement.makeInvalid(11, languageConnectionContext);
    }

    public final synchronized void prepareAndRelease(LanguageConnectionContext languageConnectionContext) throws StandardException {
        this.prepareAndRelease(languageConnectionContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileStatement(LanguageConnectionContext languageConnectionContext, TableDescriptor tableDescriptor) throws StandardException {
        Object object2;
        ContextManager contextManager = languageConnectionContext.getContextManager();
        LanguageConnectionFactory languageConnectionFactory = languageConnectionContext.getLanguageConnectionFactory();
        DataDictionary dataDictionary = this.getDataDictionary();
        if (this.type == 'T' && tableDescriptor == null) {
            object2 = this.name.substring(49);
            tableDescriptor = dataDictionary.getTableDescriptor(this.recreateUUID((String)object2));
        }
        if (tableDescriptor != null) {
            languageConnectionContext.pushTriggerTable(tableDescriptor);
        }
        object2 = languageConnectionFactory.getStatement(dataDictionary.getSchemaDescriptor(this.compSchemaId, null), this.text);
        try {
            this.preparedStatement = (ExecPreparedStatement)object2.prepareStorable(languageConnectionContext, this.preparedStatement, this.getParameterDefaults(), this.getSchemaDescriptor(), this.type == 'T');
        }
        finally {
            if (tableDescriptor != null) {
                languageConnectionContext.popTriggerTable(tableDescriptor);
            }
        }
        if (this.preparedStatement.referencesSessionSchema()) {
            throw StandardException.newException("XCL51.S");
        }
        this.setCompileTime();
        this.setParams(this.preparedStatement.getParameterTypes());
        if (!((DataDictionaryImpl)dataDictionary).readOnlyUpgrade) {
            dataDictionary.startWriting(languageConnectionContext);
            DependencyManager dependencyManager = dataDictionary.getDependencyManager();
            dependencyManager.clearDependencies(languageConnectionContext, this);
            dependencyManager.copyDependencies(this.preparedStatement, this, false, contextManager);
        }
        this.valid = true;
    }

    public final String getName() {
        return this.name;
    }

    public final String getQualifiedName() {
        return this.sd.getSchemaName() + "." + this.name;
    }

    public final SchemaDescriptor getSchemaDescriptor() {
        return this.sd;
    }

    public final char getType() {
        return this.type;
    }

    public final String getTypeAsString() {
        char[] cArray = new char[]{this.type};
        return new String(cArray);
    }

    public boolean initiallyCompilable() {
        return this.initiallyCompilable;
    }

    public static final boolean validType(char c2) {
        return c2 == 'S' || c2 == 'T';
    }

    public final synchronized Timestamp getCompileTime() {
        return this.compileTime;
    }

    public final synchronized void setCompileTime() {
        this.compileTime = new Timestamp(System.currentTimeMillis());
    }

    public final String getText() {
        return this.text;
    }

    public final synchronized String getUsingText() {
        return this.usingText;
    }

    public final synchronized void setUsingText(String string) {
        this.usingText = string;
    }

    public final synchronized void setUUID(UUID uUID) {
        this.uuid = uUID;
    }

    public final UUID getUUID() {
        return this.uuid;
    }

    public final synchronized DataTypeDescriptor[] getParams() throws StandardException {
        if (this.params == null && !this.lookedUpParams) {
            Vector vector = new Vector();
            this.params = this.getDataDictionary().getSPSParams(this, vector);
            this.paramDefaults = new Object[vector.size()];
            Enumeration enumeration = vector.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                this.paramDefaults[n] = enumeration.nextElement();
                ++n;
            }
            this.lookedUpParams = true;
        }
        return this.params;
    }

    public final synchronized void setParams(DataTypeDescriptor[] dataTypeDescriptorArray) {
        this.params = dataTypeDescriptorArray;
    }

    public final synchronized Object[] getParameterDefaults() throws StandardException {
        if (this.paramDefaults == null) {
            this.getParams();
        }
        return this.paramDefaults;
    }

    public final synchronized void setParameterDefaults(Object[] objectArray) {
        this.paramDefaults = objectArray;
    }

    public final ExecPreparedStatement getPreparedStatement() throws StandardException {
        return this.getPreparedStatement(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized ExecPreparedStatement getPreparedStatement(boolean bl) throws StandardException {
        TransactionController transactionController;
        if (!bl) return this.preparedStatement;
        if (this.valid) {
            if (this.preparedStatement != null) return this.preparedStatement;
        }
        ContextManager contextManager = ContextService.getFactory().getCurrentContextManager();
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)contextManager.getContext("LanguageConnectionContext");
        this.prepareAndRelease(languageConnectionContext);
        if (((DataDictionaryImpl)languageConnectionContext.getDataDictionary()).readOnlyUpgrade) return this.preparedStatement;
        try {
            transactionController = languageConnectionContext.getTransactionCompile().startNestedUserTransaction(false);
        }
        catch (StandardException standardException) {
            transactionController = null;
        }
        try {
            try {
                this.updateSYSSTATEMENTS(languageConnectionContext, 1, transactionController);
            }
            catch (StandardException standardException) {
                if (!standardException.getMessageId().equals("40XL1")) throw standardException;
                if (transactionController != null) {
                    transactionController.commit();
                    transactionController.destroy();
                    transactionController = null;
                }
                this.updateSYSSTATEMENTS(languageConnectionContext, 1, null);
                Object var7_8 = null;
                if (transactionController == null) return this.preparedStatement;
                transactionController.commit();
                transactionController.destroy();
                return this.preparedStatement;
            }
            Object var7_7 = null;
            if (transactionController == null) return this.preparedStatement;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (transactionController == null) throw throwable;
            transactionController.commit();
            transactionController.destroy();
            throw throwable;
        }
        transactionController.commit();
        transactionController.destroy();
        return this.preparedStatement;
    }

    public final UUID getCompSchemaId() {
        return this.compSchemaId;
    }

    public final String toString() {
        return "";
    }

    public final DependableFinder getDependableFinder() {
        return this.getDependableFinder(226);
    }

    public final String getObjectName() {
        return this.name;
    }

    public final UUID getObjectID() {
        return this.uuid;
    }

    public final String getClassType() {
        return "StoredPreparedStatement";
    }

    public final synchronized boolean isValid() {
        return this.valid;
    }

    public final synchronized void prepareToInvalidate(Provider provider, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                break;
            }
            default: {
                DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
                throw StandardException.newException("X0Y24.S", dependencyManager.getActionString(n), (Object)provider.getObjectName(), (Object)this.name);
            }
        }
    }

    public final synchronized void makeInvalid(int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
        switch (n) {
            case 10: 
            case 11: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                if (this.valid) {
                    this.valid = false;
                    this.updateSYSSTATEMENTS(languageConnectionContext, 0, null);
                }
                dependencyManager.invalidateFor(this, 14, languageConnectionContext);
                break;
            }
            case 13: {
                dependencyManager.clearDependencies(languageConnectionContext, this);
                break;
            }
        }
    }

    public final synchronized void makeValid(LanguageConnectionContext languageConnectionContext) throws StandardException {
        if (this.valid) {
            return;
        }
        this.prepareAndRelease(languageConnectionContext);
        this.updateSYSSTATEMENTS(languageConnectionContext, 1, null);
    }

    public final synchronized void revalidate(LanguageConnectionContext languageConnectionContext) throws StandardException {
        this.valid = false;
        this.makeInvalid(14, languageConnectionContext);
        this.prepareAndRelease(languageConnectionContext);
        this.updateSYSSTATEMENTS(languageConnectionContext, 1, null);
    }

    public void loadGeneratedClass() throws StandardException {
        if (this.preparedStatement != null) {
            ((StorablePreparedStatement)this.preparedStatement).loadGeneratedClass();
        }
    }

    private void updateSYSSTATEMENTS(LanguageConnectionContext languageConnectionContext, int n, TransactionController transactionController) throws StandardException {
        boolean bl;
        boolean bl2;
        boolean bl3 = false;
        boolean bl4 = false;
        if (n == 1) {
            bl2 = true;
            bl = true;
            if (!this.initiallyCompilable) {
                bl4 = true;
                this.initiallyCompilable = true;
            }
        } else {
            bl2 = false;
            bl = false;
        }
        DataDictionary dataDictionary = this.getDataDictionary();
        if (((DataDictionaryImpl)dataDictionary).readOnlyUpgrade) {
            return;
        }
        dataDictionary.startWriting(languageConnectionContext);
        if (transactionController == null) {
            transactionController = languageConnectionContext.getTransactionExecute();
            bl3 = true;
        }
        dataDictionary.updateSPS(this, transactionController, bl2, bl, bl3, bl4);
    }

    private UUID recreateUUID(String string) {
        if (this.uuidFactory == null) {
            this.uuidFactory = Monitor.getMonitor().getUUIDFactory();
        }
        return this.uuidFactory.recreateUUID(string);
    }

    public String getDescriptorType() {
        return "Statement";
    }

    public String getDescriptorName() {
        return this.name;
    }
}

