/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.util.StringUtil;

public abstract class CatalogRowFactory {
    protected String[] indexNames;
    protected int[][] indexColumnPositions;
    protected String[][] indexColumnNames;
    protected boolean[] indexUniqueness;
    protected UUID tableUUID;
    protected UUID heapUUID;
    protected UUID[] indexUUID;
    protected DataValueFactory dvf;
    private final ExecutionFactory ef;
    private UUIDFactory uuidf;
    private boolean convertIdToLower;
    private int indexCount;
    private int columnCount;
    private String catalogName;

    public CatalogRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory, boolean bl) {
        this.uuidf = uUIDFactory;
        this.dvf = dataValueFactory;
        this.ef = executionFactory;
        this.convertIdToLower = bl;
    }

    public ExecutionFactory getExecutionFactory() {
        return this.ef;
    }

    public UUIDFactory getUUIDFactory() {
        return this.uuidf;
    }

    public UUID getCanonicalTableUUID() {
        return this.tableUUID;
    }

    public UUID getCanonicalHeapUUID() {
        return this.heapUUID;
    }

    public UUID getCanonicalIndexUUID(int n) {
        return this.indexUUID[n];
    }

    public int getIndexColumnCount(int n) {
        return this.indexColumnPositions[n].length;
    }

    public String getCanonicalHeapName() {
        return this.catalogName + this.convertIdCase("_HEAP");
    }

    public String getIndexName(int n) {
        return this.indexNames[n];
    }

    public boolean isIndexUnique(int n) {
        return this.indexUniqueness != null ? this.indexUniqueness[n] : true;
    }

    public DataValueFactory getDataValueFactory() {
        return this.dvf;
    }

    public String generateIndexName(int n) {
        return this.catalogName + this.convertIdCase("_INDEX") + ++n;
    }

    public int getNumIndexes() {
        return this.indexCount;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void initInfo(int n, String string, int[][] nArray, String[][] stringArray, boolean[] blArray, String[] stringArray2) {
        this.indexCount = nArray != null ? nArray.length : 0;
        this.catalogName = this.convertIdCase(string);
        this.columnCount = n;
        UUIDFactory uUIDFactory = this.getUUIDFactory();
        this.tableUUID = uUIDFactory.recreateUUID(stringArray2[0]);
        this.heapUUID = uUIDFactory.recreateUUID(stringArray2[1]);
        if (this.indexCount > 0) {
            this.indexNames = new String[this.indexCount];
            this.indexUUID = new UUID[this.indexCount];
            for (int j = 0; j < this.indexCount; ++j) {
                this.indexNames[j] = this.generateIndexName(j);
                this.indexUUID[j] = uUIDFactory.recreateUUID(stringArray2[j + 2]);
            }
            this.indexColumnPositions = nArray;
            this.indexColumnNames = stringArray;
            this.indexUniqueness = blArray;
        }
    }

    public Properties getCreateHeapProperties() {
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", "1024");
        properties.put("derby.storage.pageReservedSpace", "0");
        properties.put("derby.storage.minimumRecordSize", "1");
        return properties;
    }

    public Properties getCreateIndexProperties(int n) {
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", "1024");
        return properties;
    }

    public int getPrimaryKeyIndexNumber() {
        return 0;
    }

    public final int getHeapColumnCount() {
        return this.columnCount;
    }

    protected String convertIdCase(String string) {
        if (this.convertIdToLower) {
            return StringUtil.SQLToLowerCase(string);
        }
        return string;
    }

    public ExecRow makeEmptyRow() throws StandardException {
        return this.makeRow(null, null);
    }

    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        return null;
    }

    public abstract TupleDescriptor buildDescriptor(ExecRow var1, TupleDescriptor var2, DataDictionary var3) throws StandardException;

    public abstract SystemColumn[] buildColumnList();

    public abstract ExecIndexRow buildEmptyIndexRow(int var1, RowLocation var2) throws StandardException;

    public int[] getIndexColumnPositions(int n) {
        return this.indexColumnPositions[n];
    }

    public String[] getIndexColumnNames(int n) {
        if (!this.convertIdToLower) {
            return this.indexColumnNames[n];
        }
        String[] stringArray = new String[this.indexColumnNames[n].length];
        for (int j = 0; j < stringArray.length; ++j) {
            stringArray[j] = StringUtil.SQLToLowerCase(this.indexColumnNames[n][j]);
        }
        return stringArray;
    }

    protected void checkIndexNumber(int n) {
    }
}

