/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.monitor;

import java.io.PrintStream;
import java.util.Locale;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.loader.InstanceGetter;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.impl.services.monitor.FileMonitor;

public class Monitor {
    public static final String SERVICE_TYPE_DIRECTORY = "serviceDirectory";
    public static final Object syncMe = new Object();
    public static final String NEW_INSTANCE_FROM_ID_TRACE_DEBUG_FLAG = null;
    public static final String DEBUG_TRUE = null;
    public static final String DEBUG_FALSE = null;
    private static ModuleFactory monitor;
    private static boolean active;

    public static void startMonitor(Properties properties, PrintStream printStream) {
        new FileMonitor(properties, printStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setMonitor(ModuleFactory moduleFactory) {
        Object object2 = syncMe;
        synchronized (object2) {
            if (active) {
                return false;
            }
            monitor = moduleFactory;
            active = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearMonitor() {
        Object object2 = syncMe;
        synchronized (object2) {
            active = false;
        }
    }

    public static ModuleFactory getMonitor() {
        return monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleFactory getMonitorLite() {
        Object object2 = syncMe;
        synchronized (object2) {
            if (active && monitor != null) {
                return monitor;
            }
        }
        return new FileMonitor();
    }

    public static HeaderPrintWriter getStream() {
        return monitor.getSystemStreams().stream();
    }

    public static String getServiceName(Object object2) {
        return monitor.getServiceName(object2);
    }

    public static Object startSystemModule(String string) throws StandardException {
        Object object2 = monitor.startModule(false, null, string, null, null);
        return object2;
    }

    public static Object findSystemModule(String string) throws StandardException {
        Object object2 = Monitor.getMonitor().findModule(null, string, null);
        if (object2 == null) {
            throw Monitor.missingImplementation(string);
        }
        return object2;
    }

    public static Object getSystemModule(String string) {
        Object object2 = Monitor.getMonitor().findModule(null, string, null);
        return object2;
    }

    public static Object bootServiceModule(boolean bl, Object object2, String string, Properties properties) throws StandardException {
        Object object3 = monitor.startModule(bl, object2, string, null, properties);
        return object3;
    }

    public static Object bootServiceModule(boolean bl, Object object2, String string, String string2, Properties properties) throws StandardException {
        Object object3 = monitor.startModule(bl, object2, string, string2, properties);
        return object3;
    }

    public static Object findServiceModule(Object object2, String string) throws StandardException {
        Object object3 = Monitor.getMonitor().findModule(object2, string, null);
        if (object3 == null) {
            throw Monitor.missingImplementation(string);
        }
        return object3;
    }

    public static Object getServiceModule(Object object2, String string) {
        Object object3 = Monitor.getMonitor().findModule(object2, string, null);
        return object3;
    }

    public static Object findService(String string, String string2) {
        return monitor.findService(string, string2);
    }

    public static boolean startPersistentService(String string, Properties properties) throws StandardException {
        return monitor.startPersistentService(string, properties);
    }

    public static Object startNonPersistentService(String string, String string2, Properties properties) throws StandardException {
        return monitor.startNonPersistentService(string, string2, properties);
    }

    public static Object createPersistentService(String string, String string2, Properties properties) throws StandardException {
        return monitor.createPersistentService(string, string2, properties);
    }

    public static void removePersistentService(String string) throws StandardException {
        monitor.removePersistentService(string);
    }

    public static InstanceGetter classFromIdentifier(int n) throws StandardException {
        return monitor.classFromIdentifier(n);
    }

    public static Object newInstanceFromIdentifier(int n) throws StandardException {
        return monitor.newInstanceFromIdentifier(n);
    }

    public static StandardException missingProductVersion(String string) {
        return StandardException.newException("XBM05.D", string);
    }

    public static StandardException missingImplementation(String string) {
        return StandardException.newException("XBM02.D", string);
    }

    public static StandardException exceptionStartingModule(Throwable throwable) {
        return StandardException.newException("XBM01.D", throwable);
    }

    public static void logMessage(String string) {
        Monitor.getStream().println(string);
    }

    public static void logTextMessage(String string) {
        Monitor.getStream().println(MessageService.getTextMessage(string));
    }

    public static void logTextMessage(String string, Object object2) {
        Monitor.getStream().println(MessageService.getTextMessage(string, object2));
    }

    public static void logTextMessage(String string, Object object2, Object object3) {
        Monitor.getStream().println(MessageService.getTextMessage(string, object2, object3));
    }

    public static void logTextMessage(String string, Object object2, Object object3, Object object4) {
        Monitor.getStream().println(MessageService.getTextMessage(string, object2, object3, object4));
    }

    public static void logTextMessage(String string, Object object2, Object object3, Object object4, Object object5) {
        Monitor.getStream().println(MessageService.getTextMessage(string, object2, object3, object4, object5));
    }

    public static Locale getLocaleFromString(String string) throws StandardException {
        return monitor.getLocaleFromString(string);
    }

    public static boolean isFullUpgrade(Properties properties, String string) throws StandardException {
        boolean bl = Boolean.valueOf(properties.getProperty("upgrade"));
        ProductVersionHolder productVersionHolder = Monitor.getMonitor().getEngineVersion();
        if ((productVersionHolder.isBeta() || productVersionHolder.isAlpha()) && !PropertyUtil.getSystemBoolean("derby.database.allowPreReleaseUpgrade")) {
            throw StandardException.newException("XCW00.D", string, (Object)productVersionHolder.getSimpleVersionString());
        }
        return bl;
    }

    public static boolean isDesiredType(Properties properties, int n) {
        boolean bl = false;
        int n2 = 2;
        if (properties != null) {
            n2 = Monitor.getEngineType(properties);
        }
        return (n2 & n) != 0;
    }

    public static boolean isDesiredType(int n, int n2) {
        return (n & n2) != 0;
    }

    public static int getEngineType(Properties properties) {
        if (properties != null) {
            String string = properties.getProperty("derby.engineType");
            int n = string == null ? 2 : Integer.parseInt(string.trim());
            return n;
        }
        return 2;
    }

    public static boolean isDesiredCreateType(Properties properties, int n) {
        boolean bl = Boolean.valueOf(properties.getProperty("create"));
        if (bl) {
            return (n & 2) != 0;
        }
        return Monitor.isDesiredType(properties, n);
    }
}

