/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableIntHolder;
import org.apache.derby.iapi.services.io.FormatableLongHolder;

public class FormatableHashtable
extends Hashtable
implements Formatable {
    public Object put(Object object2, Object object3) {
        if (object3 == null) {
            return this.remove(object2);
        }
        return super.put(object2, object3);
    }

    public void putInt(Object object2, int n) {
        super.put(object2, new FormatableIntHolder(n));
    }

    public int getInt(Object object2) {
        return ((FormatableIntHolder)this.get(object2)).getInt();
    }

    public void putLong(Object object2, long l) {
        super.put(object2, new FormatableLongHolder(l));
    }

    public long getLong(Object object2) {
        return ((FormatableLongHolder)this.get(object2)).getLong();
    }

    public void putBoolean(Object object2, boolean bl) {
        this.putInt(object2, bl ? 1 : 0);
    }

    public boolean getBoolean(Object object2) {
        return this.getInt(object2) != 0;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.size());
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            objectOutput.writeObject(k);
            objectOutput.writeObject(this.get(k));
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        for (int j = objectInput.readInt(); j > 0; --j) {
            super.put(objectInput.readObject(), objectInput.readObject());
        }
    }

    public void readExternal(ArrayInputStream arrayInputStream) throws IOException, ClassNotFoundException {
        for (int j = arrayInputStream.readInt(); j > 0; --j) {
            super.put(arrayInputStream.readObject(), arrayInputStream.readObject());
        }
    }

    public int getTypeFormatId() {
        return 313;
    }
}

