/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.ArrayOutputStream;
import org.apache.derby.iapi.services.io.InputStreamUtil;

public abstract class CompressedNumber {
    public static final int MAX_INT_STORED_SIZE = 4;
    public static final int MAX_LONG_STORED_SIZE = 8;
    public static final int MAX_COMPRESSED_INT_ONE_BYTE = 63;
    public static final int MAX_COMPRESSED_INT_TWO_BYTES = 16383;
    private static byte[] holder = new byte[8];
    private static ArrayOutputStream aos = new ArrayOutputStream(holder);
    private static DataOutput out = new DataOutputStream(aos);
    private static ArrayInputStream ais = new ArrayInputStream(holder);
    private static DataInput in = new DataInputStream(ais);
    private static InputStream in_stream = ais;

    public static final int writeInt(DataOutput dataOutput, int n) throws IOException {
        if (n < 0) {
            throw new IOException();
        }
        if (n <= 63) {
            dataOutput.writeByte(n);
            return 1;
        }
        if (n <= 16383) {
            dataOutput.writeByte(0x40 | n >>> 8);
            dataOutput.writeByte(n & 0xFF);
            return 2;
        }
        dataOutput.writeByte((n >>> 24 | 0x80) & 0xFF);
        dataOutput.writeByte(n >>> 16 & 0xFF);
        dataOutput.writeByte(n >>> 8 & 0xFF);
        dataOutput.writeByte(n & 0xFF);
        return 4;
    }

    public static final int writeInt(OutputStream outputStream, int n) throws IOException {
        if (n < 0) {
            throw new IOException();
        }
        if (n <= 63) {
            outputStream.write(n);
            return 1;
        }
        if (n <= 16383) {
            outputStream.write(0x40 | n >>> 8);
            outputStream.write(n & 0xFF);
            return 2;
        }
        outputStream.write((n >>> 24 | 0x80) & 0xFF);
        outputStream.write(n >>> 16 & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n & 0xFF);
        return 4;
    }

    public static final int readInt(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        if ((n & 0xFFFFFFC0) == 0) {
            return n;
        }
        if ((n & 0x80) == 0) {
            return (n & 0x3F) << 8 | dataInput.readUnsignedByte();
        }
        return (n & 0x7F) << 24 | dataInput.readUnsignedByte() << 16 | dataInput.readUnsignedByte() << 8 | dataInput.readUnsignedByte();
    }

    public static final int readInt(InputStream inputStream) throws IOException {
        int n = InputStreamUtil.readUnsignedByte(inputStream);
        if ((n & 0xFFFFFFC0) == 0) {
            return n;
        }
        if ((n & 0x80) == 0) {
            return (n & 0x3F) << 8 | InputStreamUtil.readUnsignedByte(inputStream);
        }
        return (n & 0x7F) << 24 | InputStreamUtil.readUnsignedByte(inputStream) << 16 | InputStreamUtil.readUnsignedByte(inputStream) << 8 | InputStreamUtil.readUnsignedByte(inputStream);
    }

    public static final int readInt(byte[] byArray, int n) {
        byte by;
        if (((by = byArray[n++]) & 0xFFFFFFC0) == 0) {
            return by;
        }
        if ((by & 0x80) == 0) {
            return (by & 0x3F) << 8 | byArray[n] & 0xFF;
        }
        return (by & 0x7F) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    public static final int readIntAndReturnIntPlusOverhead(byte[] byArray, int n) {
        byte by = byArray[n];
        if ((by & 0xFFFFFFC0) == 0) {
            return by + 2;
        }
        if ((by & 0x80) == 0) {
            return ((by & 0x3F) << 8 | byArray[n + 1] & 0xFF) + 3;
        }
        return ((by & 0x7F) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF) + 5;
    }

    public static final int skipInt(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        if ((n & 0x80) == 128) {
            dataInput.skipBytes(3);
            return 4;
        }
        if ((n & 0x40) == 64) {
            dataInput.skipBytes(1);
            return 2;
        }
        return 1;
    }

    public static final int skipInt(InputStream inputStream) throws IOException {
        int n = InputStreamUtil.readUnsignedByte(inputStream);
        int n2 = 0;
        if ((n & 0x80) == 128) {
            n2 = 3;
        } else if ((n & 0x40) == 64) {
            n2 = 1;
        }
        if (n2 != 0 && inputStream.skip(n2) != (long)n2) {
            throw new EOFException();
        }
        return n2 + 1;
    }

    public static final int sizeInt(int n) {
        if (n <= 63) {
            return 1;
        }
        if (n <= 16383) {
            return 2;
        }
        return 4;
    }

    public static final int writeLong(DataOutput dataOutput, long l) throws IOException {
        if (l < 0L) {
            throw new IOException();
        }
        if (l <= 16383L) {
            dataOutput.writeByte((int)(l >>> 8 & 0xFFL));
            dataOutput.writeByte((int)(l & 0xFFL));
            return 2;
        }
        if (l <= 0x3FFFFFFFL) {
            dataOutput.writeByte((int)((l >>> 24 | 0x40L) & 0xFFL));
            dataOutput.writeByte((int)(l >>> 16 & 0xFFL));
            dataOutput.writeByte((int)(l >>> 8 & 0xFFL));
            dataOutput.writeByte((int)(l & 0xFFL));
            return 4;
        }
        dataOutput.writeByte((int)((l >>> 56 | 0x80L) & 0xFFL));
        dataOutput.writeByte((int)(l >>> 48 & 0xFFL));
        dataOutput.writeByte((int)(l >>> 40 & 0xFFL));
        dataOutput.writeByte((int)(l >>> 32 & 0xFFL));
        dataOutput.writeByte((int)(l >>> 24 & 0xFFL));
        dataOutput.writeByte((int)(l >>> 16 & 0xFFL));
        dataOutput.writeByte((int)(l >>> 8 & 0xFFL));
        dataOutput.writeByte((int)(l & 0xFFL));
        return 8;
    }

    public static final int writeLong(OutputStream outputStream, long l) throws IOException {
        if (l < 0L) {
            throw new IOException();
        }
        if (l <= 16383L) {
            outputStream.write((int)(l >>> 8 & 0xFFL));
            outputStream.write((int)(l & 0xFFL));
            return 2;
        }
        if (l <= 0x3FFFFFFFL) {
            outputStream.write((int)((l >>> 24 | 0x40L) & 0xFFL));
            outputStream.write((int)(l >>> 16 & 0xFFL));
            outputStream.write((int)(l >>> 8 & 0xFFL));
            outputStream.write((int)(l & 0xFFL));
            return 4;
        }
        outputStream.write((int)((l >>> 56 | 0x80L) & 0xFFL));
        outputStream.write((int)(l >>> 48 & 0xFFL));
        outputStream.write((int)(l >>> 40 & 0xFFL));
        outputStream.write((int)(l >>> 32 & 0xFFL));
        outputStream.write((int)(l >>> 24 & 0xFFL));
        outputStream.write((int)(l >>> 16 & 0xFFL));
        outputStream.write((int)(l >>> 8 & 0xFFL));
        outputStream.write((int)(l & 0xFFL));
        return 8;
    }

    public static final long readLong(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        if ((n & 0xFFFFFFC0) == 0) {
            return n << 8 | dataInput.readUnsignedByte();
        }
        if ((n & 0x80) == 0) {
            return (n & 0x3F) << 24 | dataInput.readUnsignedByte() << 16 | dataInput.readUnsignedByte() << 8 | dataInput.readUnsignedByte();
        }
        return (long)(n & 0x7F) << 56 | (long)dataInput.readUnsignedByte() << 48 | (long)dataInput.readUnsignedByte() << 40 | (long)dataInput.readUnsignedByte() << 32 | (long)dataInput.readUnsignedByte() << 24 | (long)dataInput.readUnsignedByte() << 16 | (long)dataInput.readUnsignedByte() << 8 | (long)dataInput.readUnsignedByte();
    }

    public static final long readLong(InputStream inputStream) throws IOException {
        int n = InputStreamUtil.readUnsignedByte(inputStream);
        if ((n & 0xFFFFFFC0) == 0) {
            return n << 8 | InputStreamUtil.readUnsignedByte(inputStream);
        }
        if ((n & 0x80) == 0) {
            return (n & 0x3F) << 24 | InputStreamUtil.readUnsignedByte(inputStream) << 16 | InputStreamUtil.readUnsignedByte(inputStream) << 8 | InputStreamUtil.readUnsignedByte(inputStream);
        }
        long l = n;
        return (l & 0x7FL) << 56 | (long)InputStreamUtil.readUnsignedByte(inputStream) << 48 | (long)InputStreamUtil.readUnsignedByte(inputStream) << 40 | (long)InputStreamUtil.readUnsignedByte(inputStream) << 32 | (long)InputStreamUtil.readUnsignedByte(inputStream) << 24 | (long)InputStreamUtil.readUnsignedByte(inputStream) << 16 | (long)InputStreamUtil.readUnsignedByte(inputStream) << 8 | (long)InputStreamUtil.readUnsignedByte(inputStream);
    }

    public static final long readLong(byte[] byArray, int n) {
        byte by;
        if (((by = byArray[n++]) & 0xFFFFFFC0) == 0) {
            return by << 8 | byArray[n] & 0xFF;
        }
        if ((by & 0x80) == 0) {
            return (by & 0x3F) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
        }
        return (long)(by & 0x7F) << 56 | (long)(byArray[n++] & 0xFF) << 48 | (long)(byArray[n++] & 0xFF) << 40 | (long)(byArray[n++] & 0xFF) << 32 | (long)(byArray[n++] & 0xFF) << 24 | (long)(byArray[n++] & 0xFF) << 16 | (long)(byArray[n++] & 0xFF) << 8 | (long)(byArray[n] & 0xFF);
    }

    public static final int skipLong(DataInput dataInput) throws IOException {
        long l = dataInput.readUnsignedByte();
        if ((l & 0x80L) == 128L) {
            dataInput.skipBytes(7);
            return 8;
        }
        if ((l & 0x40L) == 64L) {
            dataInput.skipBytes(3);
            return 4;
        }
        dataInput.skipBytes(1);
        return 2;
    }

    public static final int skipLong(InputStream inputStream) throws IOException {
        int n = InputStreamUtil.readUnsignedByte(inputStream);
        int n2 = (n & 0x80) == 128 ? 7 : ((n & 0x40) == 64 ? 3 : 1);
        if (inputStream.skip(n2) != (long)n2) {
            throw new EOFException();
        }
        return n2 + 1;
    }

    public static final int sizeLong(long l) {
        if (l <= 16383L) {
            return 2;
        }
        if (l <= 0x3FFFFFFFL) {
            return 4;
        }
        return 8;
    }

    private static short checkInt(int n, short s2) throws IOException {
        int n2;
        int n3;
        int n4;
        aos.setPosition(0);
        int n5 = CompressedNumber.writeInt(out, n);
        if (n5 != s2) {
            System.out.println("changing length to " + n5 + " at value " + n + " 0x" + Integer.toHexString(n));
            s2 = (short)n5;
        }
        if ((n4 = aos.getPosition()) != n5) {
            System.out.println("MISMATCH written bytes  expected " + n5 + " got " + n4);
            System.exit(1);
        }
        if (n5 != CompressedNumber.sizeInt(n)) {
            System.out.println("MISMATCH sizeInt() bytes  expected " + n5 + " got " + CompressedNumber.sizeInt(n));
            System.exit(1);
        }
        ais.setPosition(0);
        int n6 = CompressedNumber.readInt(in);
        if (n6 != n) {
            System.out.println("MISMATCH value readInt(DataInput) expected " + n + " got " + n6);
            System.exit(1);
        }
        ais.setPosition(0);
        n6 = ais.readCompressedInt();
        if (n6 != n) {
            System.out.println("MISMATCH value readInt(DataInput) expected " + n + " got " + n6);
            System.exit(1);
        }
        ais.setPosition(0);
        n6 = CompressedNumber.readInt(in_stream);
        if (n6 != n) {
            System.out.println("MISMATCH value in readInt(InputStream) expected " + n + " got " + n6);
            System.exit(1);
        }
        if ((n6 = CompressedNumber.readInt(holder, 0)) != n) {
            System.out.println("MISMATCH frome readInt(byte[], offset) value expected " + n + " got " + n6);
            System.exit(1);
        }
        ais.setPosition(0);
        int n7 = CompressedNumber.skipInt(in);
        if (n7 != n5) {
            System.out.println("MISMATCH skip length expected " + n5 + " got " + n7);
            System.exit(1);
        }
        if ((n3 = CompressedNumber.readIntAndReturnIntPlusOverhead(holder, 0)) != n5 + n + 1) {
            System.out.println("MISMATCH readIntAndReturnIntPlusOverhead() return expected " + (n5 + n) + " got " + n3);
            System.exit(1);
        }
        if ((n2 = ais.getPosition()) != n5) {
            System.out.println("MISMATCH skip position expected " + n5 + " got " + n2);
            System.exit(1);
        }
        return s2;
    }

    private static short checkLong(long l, short s2) throws IOException {
        int n;
        int n2;
        long l2;
        int n3;
        aos.setPosition(0);
        int n4 = CompressedNumber.writeLong(out, l);
        if (n4 != s2) {
            System.out.println("changing length to " + n4 + " at value " + l + " 0x" + Long.toHexString(l));
            s2 = (short)n4;
        }
        if ((n3 = aos.getPosition()) != n4) {
            System.out.println("MISMATCH written bytes  expected " + n4 + " got " + n3);
            System.exit(1);
        }
        if (n4 != CompressedNumber.sizeLong(l)) {
            System.out.println("MISMATCH sizeLong() bytes  expected " + n4 + " got " + CompressedNumber.sizeLong(l));
            System.exit(1);
        }
        if ((l2 = CompressedNumber.readLong(holder, 0)) != l) {
            for (n2 = 0; n2 < 8; ++n2) {
                System.out.println(Integer.toHexString(holder[n2]));
            }
            System.out.println("MISMATCH in readLong(byte[], offset) value expected " + Long.toHexString(l) + " got " + l2);
            System.exit(1);
        }
        ais.setPosition(0);
        l2 = CompressedNumber.readLong(in_stream);
        if (l2 != l) {
            for (n2 = 0; n2 < 8; ++n2) {
                System.out.println(Integer.toHexString(holder[n2]));
            }
            System.out.println("MISMATCH value in readLong(InputStream) expected " + Long.toHexString(l) + " got " + l2);
            System.exit(1);
        }
        ais.setPosition(0);
        l2 = ais.readCompressedLong();
        if (l2 != l) {
            for (n2 = 0; n2 < 8; ++n2) {
                System.out.println(Integer.toHexString(holder[n2]));
            }
            System.out.println("MISMATCH value in readLong(InputStream) expected " + Long.toHexString(l) + " got " + l2);
            System.exit(1);
        }
        ais.setPosition(0);
        l2 = CompressedNumber.readLong(in);
        if (l2 != l) {
            for (n2 = 0; n2 < 8; ++n2) {
                System.out.println(Integer.toHexString(holder[n2]));
            }
            System.out.println("MISMATCH value in readLong(DataInput) expected " + Long.toHexString(l) + " got " + l2);
            System.exit(1);
        }
        ais.setPosition(0);
        n2 = CompressedNumber.skipLong(in);
        if (n2 != n4) {
            System.out.println("MISMATCH skip length expected " + n4 + " got " + n2);
            System.exit(1);
        }
        if ((n = ais.getPosition()) != n4) {
            System.out.println("MISMATCH skip position expected " + n4 + " got " + n);
            System.exit(1);
        }
        return s2;
    }

    public static void main(String[] stringArray) throws IOException {
        int n;
        short s2 = -1;
        System.out.println("** Testing Int");
        s2 = CompressedNumber.checkInt(0, s2);
        s2 = CompressedNumber.checkInt(1, s2);
        s2 = CompressedNumber.checkInt(2, s2);
        s2 = CompressedNumber.checkInt(59, s2);
        s2 = CompressedNumber.checkInt(60, s2);
        s2 = CompressedNumber.checkInt(61, s2);
        s2 = CompressedNumber.checkInt(62, s2);
        s2 = CompressedNumber.checkInt(63, s2);
        s2 = CompressedNumber.checkInt(64, s2);
        s2 = CompressedNumber.checkInt(65, s2);
        s2 = CompressedNumber.checkInt(66, s2);
        s2 = CompressedNumber.checkInt(67, s2);
        s2 = CompressedNumber.checkInt(16252, s2);
        s2 = CompressedNumber.checkInt(16253, s2);
        s2 = CompressedNumber.checkInt(16254, s2);
        s2 = CompressedNumber.checkInt(16255, s2);
        s2 = CompressedNumber.checkInt(16256, s2);
        s2 = CompressedNumber.checkInt(16257, s2);
        s2 = CompressedNumber.checkInt(16258, s2);
        s2 = CompressedNumber.checkInt(16259, s2);
        s2 = CompressedNumber.checkInt(16260, s2);
        s2 = CompressedNumber.checkInt(16379, s2);
        s2 = CompressedNumber.checkInt(16380, s2);
        s2 = CompressedNumber.checkInt(16381, s2);
        s2 = CompressedNumber.checkInt(16382, s2);
        s2 = CompressedNumber.checkInt(16383, s2);
        s2 = CompressedNumber.checkInt(16384, s2);
        s2 = CompressedNumber.checkInt(16385, s2);
        s2 = CompressedNumber.checkInt(16386, s2);
        s2 = CompressedNumber.checkInt(16387, s2);
        s2 = CompressedNumber.checkInt(0x7FFFFFFB, s2);
        s2 = CompressedNumber.checkInt(0x7FFFFFFC, s2);
        s2 = CompressedNumber.checkInt(0x7FFFFFFD, s2);
        s2 = CompressedNumber.checkInt(0x7FFFFFFE, s2);
        s2 = CompressedNumber.checkInt(Integer.MAX_VALUE, s2);
        s2 = -1;
        for (n = 0; n < 983040; ++n) {
            s2 = CompressedNumber.checkInt(n, s2);
        }
        System.out.println("** Testing Long");
        s2 = -1;
        for (n = 0; n < 983040; ++n) {
            s2 = CompressedNumber.checkLong(n, s2);
        }
        s2 = -1;
        s2 = CompressedNumber.checkLong(0L, s2);
        s2 = CompressedNumber.checkLong(1L, s2);
        s2 = CompressedNumber.checkLong(2L, s2);
        s2 = CompressedNumber.checkLong(16381L, s2);
        s2 = CompressedNumber.checkLong(16382L, s2);
        s2 = CompressedNumber.checkLong(16383L, s2);
        s2 = CompressedNumber.checkLong(16384L, s2);
        s2 = CompressedNumber.checkLong(16385L, s2);
        s2 = CompressedNumber.checkLong(0x3FFFFFFBL, s2);
        s2 = CompressedNumber.checkLong(0x3FFFFFFCL, s2);
        s2 = CompressedNumber.checkLong(0x3FFFFFFDL, s2);
        s2 = CompressedNumber.checkLong(0x3FFFFFFEL, s2);
        s2 = CompressedNumber.checkLong(0x3FFFFFFFL, s2);
        s2 = CompressedNumber.checkLong(0x40000000L, s2);
        s2 = CompressedNumber.checkLong(0x40000001L, s2);
        s2 = CompressedNumber.checkLong(0x40000002L, s2);
        s2 = CompressedNumber.checkLong(0x40000003L, s2);
        s2 = CompressedNumber.checkLong(0x6FFFFFFEL, s2);
        s2 = CompressedNumber.checkLong(0x6FFFFFFFL, s2);
        s2 = CompressedNumber.checkLong(0x70000000L, s2);
        s2 = CompressedNumber.checkLong(0x70000001L, s2);
        s2 = CompressedNumber.checkLong(0x70000002L, s2);
        s2 = CompressedNumber.checkLong(0x7FFFFFFFFFFFFFFDL, s2);
        s2 = CompressedNumber.checkLong(0x7FFFFFFFFFFFFFFEL, s2);
        s2 = CompressedNumber.checkLong(Long.MAX_VALUE, s2);
    }
}

