/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class ArrayUtil {
    public static void writeArrayLength(ObjectOutput objectOutput, Object[] objectArray) throws IOException {
        objectOutput.writeInt(objectArray.length);
    }

    public static void writeArrayItems(ObjectOutput objectOutput, Object[] objectArray) throws IOException {
        if (objectArray == null) {
            return;
        }
        for (int j = 0; j < objectArray.length; ++j) {
            objectOutput.writeObject(objectArray[j]);
        }
    }

    public static void writeArray(ObjectOutput objectOutput, Object[] objectArray) throws IOException {
        if (objectArray == null) {
            objectOutput.writeInt(0);
            return;
        }
        objectOutput.writeInt(objectArray.length);
        for (int j = 0; j < objectArray.length; ++j) {
            objectOutput.writeObject(objectArray[j]);
        }
    }

    public static void readArrayItems(ObjectInput objectInput, Object[] objectArray) throws IOException, ClassNotFoundException {
        for (int j = 0; j < objectArray.length; ++j) {
            objectArray[j] = objectInput.readObject();
        }
    }

    public static int readArrayLength(ObjectInput objectInput) throws IOException {
        return objectInput.readInt();
    }

    public static Object[] readObjectArray(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (n == 0) {
            return null;
        }
        Object[] objectArray = new Object[n];
        ArrayUtil.readArrayItems(objectInput, objectArray);
        return objectArray;
    }

    public static void writeIntArray(ObjectOutput objectOutput, int[] nArray) throws IOException {
        if (nArray == null) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(nArray.length);
            for (int j = 0; j < nArray.length; ++j) {
                objectOutput.writeInt(nArray[j]);
            }
        }
    }

    public static int[] readIntArray(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        for (int j = 0; j < n; ++j) {
            nArray[j] = objectInput.readInt();
        }
        return nArray;
    }

    public static void writeInts(ObjectOutput objectOutput, int[][] nArray) throws IOException {
        if (nArray == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            int n = nArray.length;
            objectOutput.writeInt(n);
            for (int j = 0; j < n; ++j) {
                ArrayUtil.writeIntArray(objectOutput, nArray[j]);
            }
        }
    }

    public static int[][] readInts(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object2 = null;
        if (objectInput.readBoolean()) {
            int n = objectInput.readInt();
            object2 = new int[n][];
            for (int j = 0; j < n; ++j) {
                object2[j] = ArrayUtil.readIntArray(objectInput);
            }
        }
        return object2;
    }

    public static void writeLongArray(ObjectOutput objectOutput, long[] lArray) throws IOException {
        if (lArray == null) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(lArray.length);
            for (int j = 0; j < lArray.length; ++j) {
                objectOutput.writeLong(lArray[j]);
            }
        }
    }

    public static long[] readLongArray(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        long[] lArray = new long[n];
        for (int j = 0; j < n; ++j) {
            lArray[j] = objectInput.readLong();
        }
        return lArray;
    }

    public static String[] readStringArray(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object[] objectArray = ArrayUtil.readObjectArray(objectInput);
        int n = 0;
        if (objectArray == null) {
            return null;
        }
        n = objectArray.length;
        String[] stringArray = new String[n];
        for (int j = 0; j < n; ++j) {
            stringArray[j] = (String)objectArray[j];
        }
        return stringArray;
    }

    public static void writeBooleanArray(ObjectOutput objectOutput, boolean[] blArray) throws IOException {
        if (blArray == null) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(blArray.length);
            for (int j = 0; j < blArray.length; ++j) {
                objectOutput.writeBoolean(blArray[j]);
            }
        }
    }

    public static boolean[] readBooleanArray(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        boolean[] blArray = new boolean[n];
        for (int j = 0; j < n; ++j) {
            blArray[j] = objectInput.readBoolean();
        }
        return blArray;
    }
}

