/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.db;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.conn.Authorizer;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;

public final class PropertyInfo {
    public static Properties getTableProperties(String string, String string2) throws SQLException {
        return PropertyInfo.getConglomerateProperties(string, string2, false);
    }

    public static Properties getIndexProperties(String string, String string2) throws SQLException {
        return PropertyInfo.getConglomerateProperties(string, string2, true);
    }

    public static String getDatabaseProperty(String string) throws SQLException {
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        try {
            return PropertyUtil.getDatabaseProperty(languageConnectionContext.getTransactionExecute(), string);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public static void setDatabaseProperty(String string, String string2) throws SQLException {
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        try {
            Authorizer authorizer = languageConnectionContext.getAuthorizer();
            authorizer.authorize(5);
            TransactionController transactionController = languageConnectionContext.getTransactionExecute();
            transactionController.setProperty(string, (Serializable)((Object)string2), false);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    private PropertyInfo() {
    }

    private static Properties getConglomerateProperties(String string, String string2, boolean bl) throws SQLException {
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        try {
            long l;
            Object object2;
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(string, transactionController, true);
            if (!bl) {
                object2 = dataDictionary.getTableDescriptor(string2, schemaDescriptor);
                if (object2 == null || ((TableDescriptor)object2).getTableType() == 2) {
                    return new Properties();
                }
                l = ((TableDescriptor)object2).getHeapConglomerateId();
            } else {
                object2 = dataDictionary.getConglomerateDescriptor(string2, schemaDescriptor, false);
                if (object2 == null) {
                    return new Properties();
                }
                l = ((ConglomerateDescriptor)object2).getConglomerateNumber();
            }
            object2 = transactionController.openConglomerate(l, false, 0, 6, 5);
            Properties properties = transactionController.getUserCreateConglomPropList();
            object2.getTableProperties(properties);
            object2.close();
            return properties;
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }
}

