/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.drda;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;

public class NetServlet
extends HttpServlet {
    private static final int MAX_CONNECT_TRYS = 20;
    private static final String SERVLET_PROP_MESSAGES = "org.apache.derby.loc.drda.servlet";
    private static final String SERVLET_ADDRESS = "derbynet";
    private String formHeader = null;
    private String host = "localhost";
    private int portNumber = 1527;
    private String tracingDirectory;
    private boolean logStatus = false;
    private boolean traceStatus = false;
    private String[] knownLang = new String[]{"en", "es", "de_DE", "fr", "it", "ja_JP", "ko_KR", "zh_CN", "zh_TW"};
    private String locale;
    private static final int NOT_GIVEN = -2;
    private static final int INVALID = -3;
    private NetworkServerControl server;
    private PrintWriter out;
    private Runnable service;

    public void init(ServletConfig servletConfig) throws ServletException {
        boolean bl;
        int n;
        LocalizedResource localizedResource = new LocalizedResource(null, null, SERVLET_PROP_MESSAGES);
        String string = servletConfig.getInitParameter("portNumber");
        if (string != null && (n = Integer.valueOf(string).intValue()) > 0) {
            this.portNumber = n;
        }
        String string2 = servletConfig.getInitParameter("tracingDirectory");
        String string3 = servletConfig.getInitParameter("startNetworkServerOnInit");
        try {
            if (this.server == null) {
                this.server = new NetworkServerControl(InetAddress.getByName(this.host), this.portNumber);
            }
            if (NetServlet.isServerStarted(this.server, 1)) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 != null && (bl = Boolean.valueOf(string3).booleanValue())) {
            this.runServer(localizedResource, null, null);
            return;
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        LocalizedResource localizedResource = this.getCurrentAppUI(httpServletRequest);
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        httpServletResponse.setHeader("Cache-Control", "no-cache,no-store");
        this.formHeader = "<form enctype='multipart/form-data; charset=UTF-8' action='" + httpServletRequest.getRequestURI() + " '>";
        this.out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), "UTF8"), true);
        String string = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_LogOn"));
        String string2 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_LogOff"));
        String string3 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_TraceOn"));
        String string4 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_TraceOff"));
        String string5 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_Start"));
        String string6 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_Stop"));
        String string7 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_TraceSessButton"));
        String string8 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_TraceOnOff"));
        String string9 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_Return"));
        String string10 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_TraceDir"));
        String string11 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_Continue"));
        String string12 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_SetParam"));
        String string13 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_SetParam2"));
        String string14 = this.escapeSingleQuotes(localizedResource.getTextMessage("SRV_NetParam"));
        this.printBanner(localizedResource);
        if (this.server == null) {
            try {
                this.server = new NetworkServerControl();
            }
            catch (Exception exception) {
                this.printErrorForm(localizedResource, httpServletRequest, exception, string9);
                return;
            }
        }
        this.server.setClientLocale(this.locale);
        String string15 = this.getForm(httpServletRequest);
        String string16 = this.getDoAction(httpServletRequest);
        if (string16 != null) {
            string15 = string16.equals(string8) ? string7 : string16;
        }
        boolean bl = this.getServerStatus();
        if (string15 == null) {
            string15 = bl ? string5 : string6;
        } else if (string15.equals(string5)) {
            if (!bl) {
                this.runServer(localizedResource, httpServletRequest, string9);
            }
        } else if (string15.equals(string6)) {
            if (bl) {
                this.shutdownServer(localizedResource, httpServletRequest, string9);
            }
            this.setDefaults();
        } else if (string15.equals(string9) || string15.equals(string9)) {
            string15 = bl ? string5 : string6;
        }
        this.out.println(this.formHeader);
        string15 = this.escapeSingleQuotes(string15);
        string16 = this.escapeSingleQuotes(string16);
        if (string15.equals(string5)) {
            String string17 = this.getLogging(httpServletRequest);
            String string18 = this.getTrace(httpServletRequest);
            if (string17 != null && string17.equals(string) && this.logging(localizedResource, true, httpServletRequest, string9)) {
                this.logStatus = true;
            }
            if (string17 != null && string17.equals(string2) && this.logging(localizedResource, false, httpServletRequest, string9)) {
                this.logStatus = false;
            }
            if (string18 != null && string18.equals(string3) && this.traceAll(localizedResource, true, httpServletRequest, string9)) {
                this.traceStatus = true;
            }
            if (string18 != null && string18.equals(string4) && this.traceAll(localizedResource, false, httpServletRequest, string9)) {
                this.traceStatus = false;
            }
            this.displayCurrentStatus(httpServletRequest, localizedResource, string9);
            this.out.println("<h4>" + localizedResource.getTextMessage("SRV_StopButton") + "</h4>");
            this.out.println("<INPUT type=submit name=form value='" + string6 + "'>");
            this.out.println("<h4>" + localizedResource.getTextMessage("SRV_LogButton2") + "</h4>");
            if (this.logStatus) {
                this.out.println("<INPUT type=submit name=logform value='" + string2 + "'>");
            } else {
                this.out.println("<INPUT type=submit name=logform value='" + string + "'>");
            }
            this.out.println("<h4>" + localizedResource.getTextMessage("SRV_TraceButton2") + "</h4>");
            if (this.traceStatus) {
                this.out.println("<INPUT type=submit name=traceform value='" + string4 + "'>");
            } else {
                this.out.println("<INPUT type=submit name=traceform value='" + string3 + "'>");
            }
            this.out.println("<h4>" + localizedResource.getTextMessage("SRV_TraceSession") + "</h4>");
            this.out.println("<INPUT type=submit name=form value='" + string7 + "'>");
            this.out.println("<h4>" + localizedResource.getTextMessage("SRV_TraceDirButton") + "</h4>");
            this.out.println("<INPUT type=submit name=form value='" + string10 + "'>");
            this.out.println("<h4>" + localizedResource.getTextMessage("SRV_ThreadButton") + "</h4>");
            this.out.println("<INPUT type=submit name=form value='" + string14 + "'>");
        } else if (string15.equals(string6)) {
            this.printAsContentHeader(localizedResource.getTextMessage("SRV_NotStarted"));
            String string19 = this.getLogging(httpServletRequest);
            String string20 = this.getTrace(httpServletRequest);
            if (string19 != null && string19.equals(string)) {
                this.logStatus = true;
            }
            if (string19 != null && string19.equals(string2)) {
                this.logStatus = false;
            }
            if (string20 != null && string20.equals(string3)) {
                this.traceStatus = true;
            }
            if (string20 != null && string20.equals(string4)) {
                this.traceStatus = false;
            }
            if (this.logStatus) {
                this.out.println("<h4>" + localizedResource.getTextMessage("SRV_LogOffButton") + "</h4>");
                this.out.println("<INPUT type=submit name=logform value='" + string2 + "'>");
            } else {
                this.out.println("<h4>" + localizedResource.getTextMessage("SRV_LogOnButton") + "</h4>");
                this.out.println("<INPUT type=submit name=logform value='" + string + "'>");
            }
            if (this.traceStatus) {
                this.out.println("<h4>" + localizedResource.getTextMessage("SRV_TraceOffButton") + "</h4>");
                this.out.println("<INPUT type=submit name=traceform value='" + string4 + "'>");
            } else {
                this.out.println("<h4>" + localizedResource.getTextMessage("SRV_TraceOnButton") + "</h4>");
                this.out.println("<INPUT type=submit name=traceform value='" + string3 + "'>");
            }
            this.out.println("<h4>" + localizedResource.getTextMessage("SRV_StartButton") + "</h4>");
            this.out.println("<INPUT type=submit name=form value='" + string5 + "'>");
        } else if (string15.equals(string7)) {
            if (string16 != null && string16.equals(string8)) {
                String string21 = httpServletRequest.getParameter("sessionid");
                int n = 0;
                try {
                    n = new Integer(string21);
                }
                catch (Exception exception) {
                    this.printErrorForm(localizedResource, httpServletRequest, localizedResource.getTextMessage("SRV_InvalidVal", string21, localizedResource.getTextMessage("SRV_SessionID")), string9);
                    return;
                }
                Properties properties = null;
                try {
                    properties = this.server.getCurrentProperties();
                }
                catch (Exception exception) {
                    this.printErrorForm(localizedResource, httpServletRequest, exception, string9);
                    return;
                }
                boolean bl2 = properties.getProperty("derby.drda.trace" + string21) == null;
                if (this.traceSession(localizedResource, bl2, n, httpServletRequest, string9)) {
                    if (bl2) {
                        this.out.println("<h4>" + localizedResource.getTextMessage("SRV_StatusTraceNoOn", string21) + "</h4>");
                    } else {
                        this.out.println("<h4>" + localizedResource.getTextMessage("SRV_StatusTraceNoOff", string21) + "</h4>");
                    }
                } else {
                    return;
                }
            }
            this.printAsContentHeader(localizedResource.getTextMessage("SRV_TraceSessButton"));
            this.out.println("<h4>" + this.getHtmlLabelledMessageInstance(localizedResource, "SRV_SessionID", "sessionId") + "</h4>");
            this.out.println("<INPUT type=text name=sessionid size=10 maxlength=10 id='sessionId' value=''>");
            this.out.println("<h4> </h4>");
            this.out.println("<INPUT type=submit name=doaction value='" + string8 + "'>");
            this.out.println("<INPUT type=submit name=form value='" + string9 + "'>");
        } else if (string15.equals(string10)) {
            boolean bl3 = false;
            String string22 = null;
            this.printAsContentHeader(string10);
            if (string16 != null && string16.equals(string10)) {
                string22 = this.getParam(httpServletRequest, "tracedirectory");
                if (this.traceDirectory(localizedResource, string22, httpServletRequest, string9)) {
                    bl3 = true;
                } else {
                    return;
                }
            }
            if (bl3) {
                this.out.println("<h2>" + localizedResource.getTextMessage("SRV_TraceDirDone", string22) + "</h2>");
                this.out.println("<INPUT type=submit name=form value='" + string9 + "'>");
            } else {
                this.out.println("<h4>" + this.getHtmlLabelledMessageInstance(localizedResource, "SRV_TraceDir", "tracedir") + "</h4>");
                this.out.println("<INPUT type=text name=tracedirectory size=60 maxlength=256 id='tracedir' value=''>");
                this.out.println("<h4> </h4>");
                this.out.println("<INPUT type=submit name=doaction value='" + string10 + "'>");
                this.out.println("<INPUT type=submit name=form value='" + string9 + "'>");
            }
        } else if (string15.equals(string14)) {
            int n = 0;
            int n2 = 0;
            String string23 = localizedResource.getTextMessage("SRV_NewMaxThreads");
            String string24 = localizedResource.getTextMessage("SRV_NewTimeSlice");
            try {
                Properties properties = this.server.getCurrentProperties();
                String string25 = properties.getProperty("derby.drda.maxThreads");
                n = new Integer(string25);
                string25 = properties.getProperty("derby.drda.timeSlice");
                n2 = new Integer(string25);
            }
            catch (Exception exception) {
                this.printErrorForm(localizedResource, httpServletRequest, exception, string9);
                return;
            }
            if (string16 != null && string16.equals(string14)) {
                int n3;
                int n4 = this.getIntParameter(httpServletRequest, "newmaxthreads", "SRV_NewMaxThreads", localizedResource, string9);
                int n5 = n3 = n4 == -3 ? -2 : this.getIntParameter(httpServletRequest, "newtimeslice", "SRV_NewTimeSlice", localizedResource, string9);
                if (n4 == -3 || n3 == -3) {
                    return;
                }
                if (n4 != -2 || n3 != -2) {
                    if (n4 != -2) {
                        n = n4;
                    }
                    if (n3 != -2) {
                        n2 = n3;
                    }
                    if (!this.setNetParam(localizedResource, n, n2, httpServletRequest, string9)) {
                        return;
                    }
                }
            }
            this.out.println(this.formHeader);
            this.printAsContentHeader(string14);
            this.out.println("<h4>" + localizedResource.getTextMessage("SRV_MaxThreads", new Integer(n).toString()) + "</h4>");
            this.out.println("<h4>" + localizedResource.getTextMessage("SRV_TimeSlice", new Integer(n2).toString()) + "</h4>");
            this.out.println("<h4> </h4>");
            this.out.println("<h4> <label for='newmaxthreads'>" + string23 + "</label> </h4>");
            this.out.println("<INPUT type=text name=newmaxthreads size=10 maxlength=10 id='newmaxthreads' value=''>");
            this.out.println("<h4> <label for='newslice'>" + string24 + "</label> </h4>");
            this.out.println("<INPUT type=text name=newtimeslice size=10 maxlength=10 id='newslice' value=''>");
            this.out.println("<h4> </h4>");
            this.out.println("<INPUT type=submit name=doaction value='" + string14 + "'>");
            this.out.println("<INPUT type=submit name=form value='" + string9 + "'>");
        } else {
            System.out.println("Internal Error: Unknown form, " + string15);
            this.out.println("Internal Error: Unknown form, " + string15);
        }
        this.out.println("</html>");
        this.out.println("</body>");
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    private String getForm(HttpServletRequest httpServletRequest) throws IOException {
        return this.getParam(httpServletRequest, "form");
    }

    private String getDoAction(HttpServletRequest httpServletRequest) throws IOException {
        return this.getParam(httpServletRequest, "doaction");
    }

    private String getLogging(HttpServletRequest httpServletRequest) throws IOException {
        return this.getParam(httpServletRequest, "logform");
    }

    private String getTrace(HttpServletRequest httpServletRequest) throws IOException {
        return this.getParam(httpServletRequest, "traceform");
    }

    private String getParam(HttpServletRequest httpServletRequest, String string) throws IOException {
        String string2 = null;
        String string3 = httpServletRequest.getParameter(string);
        if (string3 == null) {
            return string3;
        }
        string2 = new String(string3.getBytes("ISO-8859-1"), "UTF8");
        return string2;
    }

    private void runServer(LocalizedResource localizedResource, HttpServletRequest httpServletRequest, String string) throws ServletException {
        this.service = new Runnable(){

            public void run() {
                try {
                    NetworkServerControl networkServerControl = new NetworkServerControl(InetAddress.getByName(NetServlet.this.host), NetServlet.this.portNumber);
                    networkServerControl.start(null);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
            }
        };
        Thread thread = null;
        try {
            thread = (Thread)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new Thread(NetServlet.this.service);
                }
            });
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        thread.start();
        try {
            boolean bl = false;
            int n = 0;
            do {
                ++n;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    throw new ServletException(localizedResource.getTextMessage("SRV_Interupt"));
                }
                try {
                    if (!NetServlet.isServerStarted(this.server, 1)) continue;
                    bl = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (!bl && n < 20);
            if (n >= 20) {
                throw new Exception(localizedResource.getTextMessage("SRV_MaxTrys", new Integer(20).toString()));
            }
            if (this.logStatus) {
                this.server.logConnections(true);
            }
            if (this.traceStatus) {
                this.server.trace(true);
            }
        }
        catch (Exception exception) {
            if (this.out != null) {
                this.printErrorForm(localizedResource, httpServletRequest, exception, string);
            }
            throw new ServletException(exception.getMessage());
        }
    }

    private void printErrorForm(LocalizedResource localizedResource, HttpServletRequest httpServletRequest, Exception exception, String string) {
        this.printAsContentHeader(localizedResource.getTextMessage("SRV_NetworkServerError"));
        this.out.println("<h4>" + localizedResource.getTextMessage("SRV_Message", exception.getMessage()) + "</h4>");
        this.out.println("<INPUT type=submit name=form value='" + string + "'>");
        this.out.println("</html>");
        this.out.println("</body>");
    }

    private void printErrorForm(LocalizedResource localizedResource, HttpServletRequest httpServletRequest, String string, String string2) {
        this.printAsContentHeader(localizedResource.getTextMessage("SRV_NetworkServerError"));
        this.out.println("<h4>" + localizedResource.getTextMessage("SRV_Message", string) + "</h4>");
        this.out.println("<INPUT type=submit name=form value='" + string2 + "'>");
        this.out.println("</html>");
        this.out.println("</body>");
    }

    private void displayCurrentStatus(HttpServletRequest httpServletRequest, LocalizedResource localizedResource, String string) {
        try {
            this.printAsContentHeader(localizedResource.getTextMessage("SRV_Started"));
            Properties properties = this.server.getCurrentProperties();
            String string2 = properties.getProperty("derby.drda.logConnections");
            this.logStatus = string2.equals("true");
            if (this.logStatus) {
                this.out.println("<h4>" + localizedResource.getTextMessage("SRV_StatusLogOn") + "</h4>");
            } else {
                this.out.println("<h4>" + localizedResource.getTextMessage("SRV_StatusLogOff") + "</h4>");
            }
            string2 = properties.getProperty("derby.drda.traceAll");
            this.traceStatus = string2.equals("true");
            if (this.traceStatus) {
                this.out.println("<h4>" + localizedResource.getTextMessage("SRV_StatusTraceOn") + "</h4>");
            } else {
                this.out.println("<h4>" + localizedResource.getTextMessage("SRV_StatusTraceOff") + "</h4>");
            }
        }
        catch (Exception exception) {
            this.printErrorForm(localizedResource, httpServletRequest, exception, string);
        }
    }

    private boolean getServerStatus() {
        try {
            if (NetServlet.isServerStarted(this.server, 1)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean shutdownServer(LocalizedResource localizedResource, HttpServletRequest httpServletRequest, String string) {
        boolean bl = false;
        try {
            this.server.shutdown();
            bl = true;
        }
        catch (Exception exception) {
            this.printErrorForm(localizedResource, httpServletRequest, exception, string);
        }
        return bl;
    }

    private boolean logging(LocalizedResource localizedResource, boolean bl, HttpServletRequest httpServletRequest, String string) {
        boolean bl2 = false;
        try {
            this.server.logConnections(bl);
            bl2 = true;
        }
        catch (Exception exception) {
            this.printErrorForm(localizedResource, httpServletRequest, exception, string);
        }
        return bl2;
    }

    private boolean traceAll(LocalizedResource localizedResource, boolean bl, HttpServletRequest httpServletRequest, String string) {
        boolean bl2 = false;
        try {
            this.server.trace(bl);
            bl2 = true;
        }
        catch (Exception exception) {
            this.printErrorForm(localizedResource, httpServletRequest, exception, string);
        }
        return bl2;
    }

    private boolean traceSession(LocalizedResource localizedResource, boolean bl, int n, HttpServletRequest httpServletRequest, String string) {
        boolean bl2 = false;
        try {
            this.server.trace(n, bl);
            bl2 = true;
        }
        catch (Exception exception) {
            this.printErrorForm(localizedResource, httpServletRequest, exception, string);
        }
        return bl2;
    }

    private boolean traceDirectory(LocalizedResource localizedResource, String string, HttpServletRequest httpServletRequest, String string2) {
        boolean bl = false;
        if (string == null || string.equals("")) {
            this.printErrorForm(localizedResource, httpServletRequest, localizedResource.getTextMessage("SRV_MissingParam", localizedResource.getTextMessage("SRV_TraceDir")), string2);
            return bl;
        }
        try {
            this.server.setTraceDirectory(string);
            bl = true;
        }
        catch (Exception exception) {
            this.printErrorForm(localizedResource, httpServletRequest, exception, string2);
        }
        return bl;
    }

    private boolean setNetParam(LocalizedResource localizedResource, int n, int n2, HttpServletRequest httpServletRequest, String string) {
        boolean bl = false;
        try {
            this.server.setMaxThreads(n);
            this.server.setTimeSlice(n2);
            bl = true;
        }
        catch (Exception exception) {
            this.printErrorForm(localizedResource, httpServletRequest, exception, string);
        }
        return bl;
    }

    private void setDefaults() {
        this.logStatus = false;
        this.traceStatus = false;
    }

    private int getIntParameter(HttpServletRequest httpServletRequest, String string, String string2, LocalizedResource localizedResource, String string3) {
        int n;
        String string4 = httpServletRequest.getParameter(string);
        if (string4 == null || string4.equals("")) {
            return -2;
        }
        try {
            n = new Integer(string4);
        }
        catch (Exception exception) {
            this.printErrorForm(localizedResource, httpServletRequest, localizedResource.getTextMessage("SRV_InvalidVal", string4, localizedResource.getTextMessage(string2)), string3);
            return -3;
        }
        if (n < 0) {
            this.printErrorForm(localizedResource, httpServletRequest, localizedResource.getTextMessage("SRV_InvalidVal", string4, localizedResource.getTextMessage(string2)), string3);
            return -3;
        }
        return n;
    }

    private void printBanner(LocalizedResource localizedResource) {
        this.out.println("<a href=\"#navskip\">[ " + localizedResource.getTextMessage("SRV_SkipToContent") + " ]</a>");
        this.out.println("  -  <a href=\"derbynet\">[ " + localizedResource.getTextMessage("SRV_BackToMain") + " ]</a>");
        this.out.println("<html>");
        this.out.println("<title>" + localizedResource.getTextMessage("SRV_Banner") + "</title>");
        this.out.println("<body>");
        this.out.println("<hr>");
        this.out.println("<h1>" + localizedResource.getTextMessage("SRV_Banner") + "</h1>");
        this.out.println("<hr>");
    }

    private LocalizedResource getCurrentAppUI(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("Accept-Language");
        LocalizedResource localizedResource = new LocalizedResource(null, null, SERVLET_PROP_MESSAGES);
        this.locale = null;
        if (string == null) {
            return localizedResource;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = this.translationAvailable(string2 = this.getLocStringFromLanguage(string2));
            if (n == -1) continue;
            localizedResource.init(null, string2, SERVLET_PROP_MESSAGES);
            this.locale = string2;
            return localizedResource;
        }
        return localizedResource;
    }

    private String getLocStringFromLanguage(String string) {
        int n = string.indexOf(59);
        if (n != -1) {
            string = string.substring(0, n);
        }
        string = string.trim();
        return string;
    }

    private int translationAvailable(String string) {
        for (int j = 0; j < this.knownLang.length; ++j) {
            if (!this.knownLang[j].toUpperCase(Locale.ENGLISH).equals(string.toUpperCase(Locale.ENGLISH))) continue;
            return j;
        }
        return -1;
    }

    public String getHtmlLabelledMessageInstance(LocalizedResource localizedResource, String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        return "<label for='" + string2 + "'>" + localizedResource.getTextMessage(string) + "</label>";
    }

    private void printAsContentHeader(String string) {
        this.out.println("<a name=\"navskip\"></a><h2>" + string + "</h2>");
    }

    private String escapeSingleQuotes(String string) {
        if (string == null || string.indexOf("'") < 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[4 * cArray.length];
        int n = 0;
        for (int j = 0; j < cArray.length; ++j) {
            if (cArray[j] == '\'') {
                cArray2[n++] = 38;
                cArray2[n++] = 35;
                cArray2[n++] = 51;
                cArray2[n++] = 57;
                continue;
            }
            cArray2[n++] = cArray[j];
        }
        return new String(cArray2, 0, n);
    }

    private static boolean isServerStarted(NetworkServerControl networkServerControl, int n) {
        for (int j = 1; j <= n; ++j) {
            try {
                Thread.sleep(500L);
                networkServerControl.ping();
                return true;
            }
            catch (Exception exception) {
                if (j != n) continue;
                return false;
            }
        }
        return false;
    }
}

