/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.diag.ConglomInfo;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.SpaceInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.vti.VTICosting;
import org.apache.derby.vti.VTIEnvironment;
import org.apache.derby.vti.VTITemplate;

public class SpaceTable
extends VTITemplate
implements VTICosting {
    private ConglomInfo[] conglomTable;
    boolean initialized;
    int currentRow;
    private boolean wasNull;
    private String schemaName;
    private String tableName;
    private SpaceInfo spaceInfo;
    private TransactionController tc;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("CONGLOMERATENAME", 12, true, 128), EmbedResultSetMetaData.getResultColumnDescriptor("ISINDEX", 5, false), EmbedResultSetMetaData.getResultColumnDescriptor("NUMALLOCATEDPAGES", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("NUMFREEPAGES", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("NUMUNFILLEDPAGES", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("PAGESIZE", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("ESTIMSPACESAVING", -5, false)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public SpaceTable(String string, String string2) {
        this.schemaName = string;
        this.tableName = string2;
    }

    public SpaceTable(String string) {
        this.tableName = string;
    }

    private void getConglomInfo(LanguageConnectionContext languageConnectionContext) throws StandardException {
        SchemaDescriptor schemaDescriptor;
        TableDescriptor tableDescriptor;
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        if (this.schemaName == null) {
            this.schemaName = languageConnectionContext.getCurrentSchemaName();
        }
        if ((tableDescriptor = dataDictionary.getTableDescriptor(this.tableName, schemaDescriptor = dataDictionary.getSchemaDescriptor(this.schemaName, languageConnectionContext.getTransactionExecute(), true))) == null) {
            this.conglomTable = new ConglomInfo[0];
            return;
        }
        ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
        this.conglomTable = new ConglomInfo[conglomerateDescriptorArray.length];
        for (int j = 0; j < conglomerateDescriptorArray.length; ++j) {
            this.conglomTable[j] = new ConglomInfo(conglomerateDescriptorArray[j].getConglomerateNumber(), conglomerateDescriptorArray[j].isIndex() ? conglomerateDescriptorArray[j].getConglomerateName() : this.tableName, conglomerateDescriptorArray[j].isIndex());
        }
    }

    private void getSpaceInfo(int n) throws StandardException {
        ConglomerateController conglomerateController = this.tc.openConglomerate(this.conglomTable[n].getConglomId(), false, 0, 6, 2);
        this.spaceInfo = conglomerateController.getSpaceInfo();
        conglomerateController.close();
        conglomerateController = null;
    }

    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    public boolean next() throws SQLException {
        try {
            if (!this.initialized) {
                LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
                this.getConglomInfo(languageConnectionContext);
                this.tc = languageConnectionContext.getTransactionExecute();
                this.initialized = true;
                this.currentRow = -1;
            }
            if (this.conglomTable == null) {
                return false;
            }
            ++this.currentRow;
            if (this.currentRow >= this.conglomTable.length) {
                return false;
            }
            this.spaceInfo = null;
            this.getSpaceInfo(this.currentRow);
            return true;
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public void close() {
        this.conglomTable = null;
        this.spaceInfo = null;
        this.tc = null;
    }

    public String getString(int n) {
        ConglomInfo conglomInfo = this.conglomTable[this.currentRow];
        String string = conglomInfo.getConglomName();
        this.wasNull = string == null;
        return string;
    }

    public long getLong(int n) {
        long l;
        ConglomInfo conglomInfo = this.conglomTable[this.currentRow];
        switch (n) {
            case 3: {
                l = this.spaceInfo.getNumAllocatedPages();
                break;
            }
            case 4: {
                l = this.spaceInfo.getNumFreePages();
                break;
            }
            case 5: {
                l = this.spaceInfo.getNumUnfilledPages();
                break;
            }
            case 7: {
                int n2 = this.spaceInfo.getPageSize();
                l = this.spaceInfo.getNumFreePages() * (long)n2;
                break;
            }
            default: {
                l = -1L;
            }
        }
        this.wasNull = false;
        return l;
    }

    public short getShort(int n) {
        ConglomInfo conglomInfo = this.conglomTable[this.currentRow];
        this.wasNull = false;
        return (short)(conglomInfo.getIsIndex() ? 1 : 0);
    }

    public int getInt(int n) {
        return this.spaceInfo.getPageSize();
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public double getEstimatedRowCount(VTIEnvironment vTIEnvironment) {
        return 10000.0;
    }

    public double getEstimatedCostPerInstantiation(VTIEnvironment vTIEnvironment) {
        return 100000.0;
    }

    public boolean supportsMultipleInstantiations(VTIEnvironment vTIEnvironment) {
        return true;
    }
}

