/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.TableNameInfo;
import org.apache.derby.vti.VTICosting;
import org.apache.derby.vti.VTIEnvironment;
import org.apache.derby.vti.VTITemplate;

public class LockTable
extends VTITemplate
implements VTICosting {
    public static final int LATCH = 1;
    public static final int TABLE_AND_ROWLOCK = 2;
    public static final int ALL = -1;
    private TransactionController tc;
    private LanguageConnectionFactory lcf;
    private Hashtable currentRow;
    private Enumeration lockTable;
    private boolean wasNull;
    private boolean initialized;
    private final int flag;
    private TableNameInfo tabInfo;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("XID", 12, false, 15), EmbedResultSetMetaData.getResultColumnDescriptor("TYPE", 12, true, 5), EmbedResultSetMetaData.getResultColumnDescriptor("MODE", 12, false, 4), EmbedResultSetMetaData.getResultColumnDescriptor("TABLENAME", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("LOCKNAME", 12, false, 20), EmbedResultSetMetaData.getResultColumnDescriptor("STATE", 12, true, 5), EmbedResultSetMetaData.getResultColumnDescriptor("TABLETYPE", 12, false, 9), EmbedResultSetMetaData.getResultColumnDescriptor("LOCKCOUNT", 12, false, 5), EmbedResultSetMetaData.getResultColumnDescriptor("INDEXNAME", 12, true, 128)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public LockTable() {
        this.flag = 2;
    }

    public LockTable(int n) {
        this.flag = n;
    }

    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    public boolean next() throws SQLException {
        try {
            if (!this.initialized) {
                LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
                this.tc = languageConnectionContext.getTransactionExecute();
                LanguageConnectionFactory languageConnectionFactory = languageConnectionContext.getLanguageConnectionFactory();
                LockFactory lockFactory = languageConnectionFactory.getAccessFactory().getLockFactory();
                this.lockTable = lockFactory.makeVirtualLockTable();
                this.initialized = true;
                this.tabInfo = new TableNameInfo(languageConnectionContext, true);
            }
            this.currentRow = null;
            if (this.lockTable != null) {
                while (this.lockTable.hasMoreElements() && this.currentRow == null) {
                    this.currentRow = this.dumpLock((Latch)this.lockTable.nextElement());
                }
            }
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
        return this.currentRow != null;
    }

    public void close() {
        this.lockTable = null;
    }

    public String getString(int n) {
        String string = (String)this.currentRow.get(columnInfo[n - 1].getName());
        this.wasNull = string == null;
        return string;
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public double getEstimatedRowCount(VTIEnvironment vTIEnvironment) {
        return 10000.0;
    }

    public double getEstimatedCostPerInstantiation(VTIEnvironment vTIEnvironment) {
        return 100000.0;
    }

    public boolean supportsMultipleInstantiations(VTIEnvironment vTIEnvironment) {
        return false;
    }

    private Hashtable dumpLock(Latch latch) throws StandardException {
        Object object2;
        String string;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(17);
        Object object3 = latch.getQualifier();
        Lockable lockable = latch.getLockable();
        if (!lockable.lockAttributes(this.flag, hashtable)) {
            return null;
        }
        if (hashtable.get("LOCKNAME") == null || hashtable.get("TYPE") == null) {
            return null;
        }
        int n = latch.getCount();
        if (n != 0) {
            string = "GRANT";
        } else {
            if (!(latch instanceof ActiveLock)) {
                return null;
            }
            string = "WAIT";
        }
        Long l = (Long)hashtable.get("CONGLOMID");
        if (l == null) {
            if (hashtable.get("CONTAINERID") == null) {
                return null;
            }
            object2 = (Long)hashtable.get("CONTAINERID");
            l = new Long(this.tc.findConglomid((Long)object2));
            hashtable.put("CONGLOMID", l);
        }
        hashtable.put("LOCKOBJ", latch);
        hashtable.put("XID", latch.getCompatabilitySpace().toString());
        hashtable.put("MODE", object3.toString());
        hashtable.put("LOCKCOUNT", Integer.toString(n));
        hashtable.put("STATE", string);
        object2 = this.tabInfo.getTableName(l);
        hashtable.put("TABLENAME", object2);
        String string2 = this.tabInfo.getIndexName(l);
        if (string2 != null) {
            hashtable.put("INDEXNAME", string2);
        }
        String string3 = this.tabInfo.getTableType(l);
        hashtable.put("TABLETYPE", string3);
        return hashtable;
    }
}

