/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.ReferencedColumns;
import org.apache.derby.iapi.services.io.Formatable;

public class ReferencedColumnsDescriptorImpl
implements ReferencedColumns,
Formatable {
    private int[] referencedColumns;

    public ReferencedColumnsDescriptorImpl(int[] nArray) {
        this.referencedColumns = nArray;
    }

    public ReferencedColumnsDescriptorImpl() {
    }

    public int[] getReferencedColumnPositions() {
        return this.referencedColumns;
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        this.referencedColumns = new int[n];
        for (int j = 0; j < n; ++j) {
            this.referencedColumns[j] = objectInput.readInt();
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.referencedColumns.length);
        for (int j = 0; j < this.referencedColumns.length; ++j) {
            objectOutput.writeInt(this.referencedColumns[j]);
        }
    }

    public int getTypeFormatId() {
        return 205;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append('(');
        for (int j = 0; j < this.referencedColumns.length; ++j) {
            if (j > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(String.valueOf(this.referencedColumns[j]));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

