/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.IndexDescriptor;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableHashtable;

public class IndexDescriptorImpl
implements IndexDescriptor,
Formatable {
    private boolean isUnique;
    private int[] baseColumnPositions;
    private boolean[] isAscending;
    private int numberOfOrderedColumns;
    private String indexType;

    public IndexDescriptorImpl(String string, boolean bl, int[] nArray, boolean[] blArray, int n) {
        this.indexType = string;
        this.isUnique = bl;
        this.baseColumnPositions = nArray;
        this.isAscending = blArray;
        this.numberOfOrderedColumns = n;
    }

    public IndexDescriptorImpl() {
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public int[] baseColumnPositions() {
        return this.baseColumnPositions;
    }

    public Integer getKeyColumnPosition(Integer n) {
        return new Integer(this.getKeyColumnPosition((int)n));
    }

    public int getKeyColumnPosition(int n) {
        int n2 = 0;
        for (int j = 0; j < this.baseColumnPositions.length; ++j) {
            if (this.baseColumnPositions[j] != n) continue;
            n2 = j + 1;
            break;
        }
        return n2;
    }

    public int numberOfOrderedColumns() {
        return this.numberOfOrderedColumns;
    }

    public String indexType() {
        return this.indexType;
    }

    public boolean isAscending(Integer n) {
        int n2 = n - 1;
        if (n2 < 0 || n2 >= this.baseColumnPositions.length) {
            return false;
        }
        return this.isAscending[n2];
    }

    public boolean isDescending(Integer n) {
        int n2 = n - 1;
        if (n2 < 0 || n2 >= this.baseColumnPositions.length) {
            return false;
        }
        return !this.isAscending[n2];
    }

    public boolean[] isAscending() {
        return this.isAscending;
    }

    public void setBaseColumnPositions(int[] nArray) {
        this.baseColumnPositions = nArray;
    }

    public void setIsAscending(boolean[] blArray) {
        this.isAscending = blArray;
    }

    public void setNumberOfOrderedColumns(int n) {
        this.numberOfOrderedColumns = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(60);
        if (this.isUnique) {
            stringBuffer.append("UNIQUE ");
        }
        stringBuffer.append(this.indexType);
        stringBuffer.append(" (");
        for (int j = 0; j < this.baseColumnPositions.length; ++j) {
            if (j > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.baseColumnPositions[j]);
            if (this.isAscending[j]) continue;
            stringBuffer.append(" DESC");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        FormatableHashtable formatableHashtable = (FormatableHashtable)objectInput.readObject();
        this.isUnique = formatableHashtable.getBoolean("isUnique");
        int n = formatableHashtable.getInt("keyLength");
        this.baseColumnPositions = new int[n];
        this.isAscending = new boolean[n];
        for (int j = 0; j < n; ++j) {
            this.baseColumnPositions[j] = formatableHashtable.getInt("bcp" + j);
            this.isAscending[j] = formatableHashtable.getBoolean("isAsc" + j);
        }
        this.numberOfOrderedColumns = formatableHashtable.getInt("orderedColumns");
        this.indexType = (String)formatableHashtable.get("indexType");
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        FormatableHashtable formatableHashtable = new FormatableHashtable();
        formatableHashtable.putBoolean("isUnique", this.isUnique);
        formatableHashtable.putInt("keyLength", this.baseColumnPositions.length);
        for (int j = 0; j < this.baseColumnPositions.length; ++j) {
            formatableHashtable.putInt("bcp" + j, this.baseColumnPositions[j]);
            formatableHashtable.putBoolean("isAsc" + j, this.isAscending[j]);
        }
        formatableHashtable.putInt("orderedColumns", this.numberOfOrderedColumns);
        formatableHashtable.put("indexType", this.indexType);
        objectOutput.writeObject(formatableHashtable);
    }

    public int getTypeFormatId() {
        return 387;
    }

    public boolean equals(Object object2) {
        boolean bl = false;
        if (object2 instanceof IndexDescriptorImpl) {
            IndexDescriptorImpl indexDescriptorImpl = (IndexDescriptorImpl)object2;
            if (indexDescriptorImpl.isUnique == this.isUnique && indexDescriptorImpl.baseColumnPositions.length == this.baseColumnPositions.length && indexDescriptorImpl.numberOfOrderedColumns == this.numberOfOrderedColumns && indexDescriptorImpl.indexType.equals(this.indexType)) {
                bl = true;
                for (int j = 0; j < this.baseColumnPositions.length; ++j) {
                    if (indexDescriptorImpl.baseColumnPositions[j] == this.baseColumnPositions[j] && indexDescriptorImpl.isAscending[j] == this.isAscending[j]) continue;
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = this.isUnique ? 1 : 2;
        n *= this.numberOfOrderedColumns;
        for (int j = 0; j < this.baseColumnPositions.length; ++j) {
            n *= this.baseColumnPositions[j];
        }
        return n *= this.indexType.hashCode();
    }
}

