/*
 * Decompiled with CFR 0.152.
 */
package com.sfcommerce.jpaymentcomponent.utilities;

import com.sfcommerce.jpaymentcomponent.utilities.Config;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EventLog {
    public static final int INFORMATION = 0;
    public static final int ERROR = 1;
    public static final int TRACE = 2;
    public static final String ERROR_EVENT = "ERROR";
    public static final String INFO_EVENT = "INFORMATION";
    public static final String TRACE_EVENT = "TRACE";
    private static int theDebugLevel = 0;
    private static String theApplicationID = "SF";
    private static boolean theIsInitialized = false;
    private static boolean theInInit = false;
    private static boolean theIsOpen = false;
    private static String theLogBasePath = "";
    private static String theFileName = null;
    private static File theLogFile = null;
    private static OutputStream theOutputStream = null;
    private static BufferedWriter thePrintWriter = null;
    private static long theMaximumSize = 0L;
    private static int theMaximumBackupFiles = 0;

    public static synchronized void init(String anApplicationID) {
        if (theIsInitialized || theInInit) {
            return;
        }
        theInInit = true;
        theApplicationID = anApplicationID;
        String LogLevel2 = null;
        try {
            LogLevel2 = Config.getProperty("LogLevel", INFO_EVENT);
        }
        catch (Exception e2) {
            System.err.println(e2.getMessage());
        }
        if (LogLevel2.equals(INFO_EVENT)) {
            theDebugLevel = 0;
        } else if (LogLevel2.equals(ERROR_EVENT)) {
            theDebugLevel = 1;
        } else if (LogLevel2.equals(TRACE_EVENT)) {
            theDebugLevel = 2;
        }
        try {
            theLogBasePath = Config.getProperty("LogBasePath", ".");
            theFileName = Config.getProperty("LogFilename", "event_log.log");
            theMaximumSize = Math.max(Long.parseLong(Config.getProperty("LogMaxSize", new Integer(10240000).toString())), 10240L);
            theMaximumBackupFiles = Math.max(Integer.parseInt(Config.getProperty("LogMaxBackupFiles", new Integer(10).toString())), 1);
        }
        catch (Exception e3) {
            System.err.println(e3.getMessage());
        }
        if (!EventLog.isOpen()) {
            EventLog.open();
        }
        theIsInitialized = true;
        theInInit = false;
    }

    public static synchronized void log(int aLevel, String anEvent) {
        StringBuffer buffer = null;
        if (anEvent == null) {
            return;
        }
        if (aLevel > theDebugLevel) {
            return;
        }
        buffer = aLevel == 0 ? new StringBuffer(INFO_EVENT) : (aLevel == 1 ? new StringBuffer(ERROR_EVENT) : new StringBuffer(TRACE_EVENT));
        buffer.append(": ");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd, HH-mm-ss a: ");
        buffer.append(dateFormat.format(new Date()));
        buffer.append(anEvent);
        if (EventLog.isOpen()) {
            if (thePrintWriter != null) {
                if (theLogFile != null && theLogFile.length() > theMaximumSize) {
                    EventLog.close();
                    try {
                        EventLog.open();
                    }
                    catch (Exception e2) {
                        System.err.println(e2.getMessage());
                    }
                }
                try {
                    thePrintWriter.write(buffer.toString());
                    thePrintWriter.newLine();
                    thePrintWriter.flush();
                }
                catch (Exception e3) {
                    System.err.println(e3.getMessage());
                }
            } else {
                System.out.println(buffer.toString());
            }
        } else {
            System.out.println(buffer.toString());
        }
    }

    public static synchronized void open() {
        block2: {
            if (EventLog.isOpen()) break block2;
            try {
                File file = EventLog.getFile(theLogBasePath, theFileName);
                thePrintWriter = new BufferedWriter(new FileWriter(theLogBasePath + "/" + theFileName, true));
                theLogFile = file;
                theIsOpen = true;
            }
            catch (Exception e2) {
                System.err.println("ERROR: Can't open log file " + theLogBasePath + File.separator + theFileName);
            }
        }
    }

    private static synchronized File getFile(String aPath, String aName) {
        File f2;
        block4: {
            f2 = new File(aPath, aName);
            if (!f2.exists()) break block4;
            try {
                if (f2.length() < theMaximumSize) break block4;
                int ext = Integer.parseInt(aName.substring(aName.lastIndexOf(46) + 1));
                if (ext >= theMaximumBackupFiles) {
                    f2.delete();
                    return f2;
                }
                String name2 = aName.substring(0, aName.lastIndexOf(46) + 1) + (ext + 1);
                File f22 = EventLog.getFile(aPath, name2);
                boolean r = f2.renameTo(f22);
                if (!r) {
                    System.err.println("Can't backup log!");
                }
            }
            catch (NumberFormatException e2) {
                String name2 = aName + ".1";
                File f23 = EventLog.getFile(aPath, name2);
                f2.renameTo(f23);
            }
        }
        return f2;
    }

    public static synchronized void close() {
        if (EventLog.isOpen()) {
            if (thePrintWriter != null) {
                try {
                    thePrintWriter.close();
                }
                catch (Exception e2) {
                    System.out.println(e2.getMessage());
                }
            }
            theIsOpen = false;
        }
    }

    public static synchronized boolean isOpen() {
        return theIsOpen;
    }
}

