/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.FontPolicies;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.common.MinimumSizedIcon;
import com.jgoodies.looks.common.ShadowPopupFactory;
import com.jgoodies.looks.windows.WindowsBorders;
import com.jgoodies.looks.windows.WindowsIconFactory;
import java.awt.Color;
import java.awt.Insets;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;

public final class WindowsLookAndFeel
extends com.sun.java.swing.plaf.windows.WindowsLookAndFeel {
    public static final String BORDER_STYLE_KEY = "jgoodies.windows.borderStyle";

    public String getID() {
        return "JGoodies Windows";
    }

    public String getName() {
        return "JGoodies Windows";
    }

    public String getDescription() {
        return "The JGoodies Windows Look and Feel - \u00a9 2001-2006 JGoodies Karsten Lentzsch";
    }

    public static FontPolicy getFontPolicy() {
        FontPolicy policy = (FontPolicy)UIManager.get("Windows.fontChoicePolicy");
        if (policy != null) {
            return policy;
        }
        FontPolicy defaultPolicy = FontPolicies.getDefaultWindowsPolicy();
        return FontPolicies.customSettingsPolicy(defaultPolicy);
    }

    public static void setFontPolicy(FontPolicy fontPolicy) {
        UIManager.put("Windows.fontChoicePolicy", fontPolicy);
    }

    public void initialize() {
        super.initialize();
        ShadowPopupFactory.install();
    }

    public void uninitialize() {
        super.uninitialize();
        ShadowPopupFactory.uninstall();
    }

    protected void initClassDefaults(UIDefaults table2) {
        super.initClassDefaults(table2);
        String windowsPrefix = "com.jgoodies.looks.windows.Windows";
        String commonPrefix = "com.jgoodies.looks.common.ExtBasic";
        Object[] uiDefaults = new Object[]{"ComboBoxUI", "com.jgoodies.looks.windows.WindowsComboBoxUI", "ButtonUI", "com.jgoodies.looks.windows.WindowsButtonUI", "ScrollPaneUI", "com.jgoodies.looks.windows.WindowsScrollPaneUI", "MenuBarUI", "com.jgoodies.looks.windows.WindowsMenuBarUI", "MenuItemUI", "com.jgoodies.looks.windows.WindowsMenuItemUI", "CheckBoxMenuItemUI", "com.jgoodies.looks.common.ExtBasicCheckBoxMenuItemUI", "RadioButtonMenuItemUI", "com.jgoodies.looks.common.ExtBasicRadioButtonMenuItemUI", "PopupMenuUI", "com.jgoodies.looks.windows.WindowsPopupMenuUI", "PopupMenuSeparatorUI", "com.jgoodies.looks.common.ExtBasicPopupMenuSeparatorUI", "OptionPaneUI", "com.jgoodies.looks.windows.WindowsOptionPaneUI", "SplitPaneUI", "com.jgoodies.looks.windows.WindowsSplitPaneUI", "TabbedPaneUI", "com.jgoodies.looks.windows.WindowsTabbedPaneUI", "TextAreaUI", "com.jgoodies.looks.windows.WindowsTextAreaUI", "TreeUI", "com.jgoodies.looks.windows.WindowsTreeUI", "SeparatorUI", "com.jgoodies.looks.windows.WindowsSeparatorUI"};
        if (LookUtils.IS_JAVA_1_4_2_OR_LATER) {
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "SpinnerUI", "com.jgoodies.looks.windows.WindowsSpinnerUI");
        }
        if (LookUtils.IS_JAVA_1_4_OR_5) {
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "PasswordFieldUI", "com.jgoodies.looks.windows.WindowsPasswordFieldUI");
        }
        if (LookUtils.IS_LAF_WINDOWS_XP_ENABLED) {
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "MenuUI", "com.jgoodies.looks.windows.WindowsXPMenuUI");
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "ToolBarUI", "com.jgoodies.looks.windows.WindowsXPToolBarUI");
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "TableHeaderUI", "com.jgoodies.looks.windows.WindowsXPTableHeaderUI");
        } else {
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "MenuUI", "com.jgoodies.looks.common.ExtBasicMenuUI");
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "ToolBarUI", "com.jgoodies.looks.windows.WindowsToolBarUI");
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "ScrollBarUI", "com.jgoodies.looks.windows.WindowsScrollBarUI");
            if (!LookUtils.IS_JAVA_1_4_2_OR_LATER) {
                uiDefaults = WindowsLookAndFeel.append(uiDefaults, "ToolBarSeparatorUI", "com.jgoodies.looks.windows.WindowsToolBarSeparatorUI");
            }
        }
        table2.putDefaults(uiDefaults);
    }

    protected void initComponentDefaults(UIDefaults table2) {
        InsetsUIResource menuItemMargin;
        DimensionUIResource toolBarSeparatorSize;
        int buttonPad;
        super.initComponentDefaults(table2);
        boolean isXP = LookUtils.IS_LAF_WINDOWS_XP_ENABLED;
        boolean isClassic = !isXP;
        boolean isVista = LookUtils.IS_OS_WINDOWS_VISTA;
        this.initFontDefaults(table2);
        if (isClassic) {
            this.initComponentDefaultsClassic(table2);
        }
        if (isXP && LookUtils.IS_JAVA_1_4) {
            this.initComponentDefaultsXP14(table2);
        }
        BasicBorders.MarginBorder marginBorder = new BasicBorders.MarginBorder();
        InsetsUIResource checkBoxMargin = new InsetsUIResource(2, 0, 2, 0);
        UIDefaults.ProxyLazyValue etchedBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource", "getEtchedBorderUIResource");
        SimpleProxyLazyValue buttonBorder = new SimpleProxyLazyValue("com.jgoodies.looks.windows.WindowsLookAndFeel", "getButtonBorder");
        Border menuBorder = isXP ? WindowsBorders.getXPMenuBorder() : WindowsBorders.getMenuBorder();
        BasicBorders.MarginBorder menuBarEmptyBorder = marginBorder;
        Border menuBarSeparatorBorder = WindowsBorders.getSeparatorBorder();
        Border menuBarEtchedBorder = WindowsBorders.getEtchedBorder();
        Border menuBarHeaderBorder = WindowsBorders.getMenuBarHeaderBorder();
        BasicBorders.MarginBorder toolBarEmptyBorder = marginBorder;
        Border toolBarSeparatorBorder = WindowsBorders.getSeparatorBorder();
        Border toolBarEtchedBorder = WindowsBorders.getEtchedBorder();
        Border toolBarHeaderBorder = WindowsBorders.getToolBarHeaderBorder();
        int n = buttonPad = Options.getUseNarrowButtons() ? 4 : 14;
        InsetsUIResource buttonMargin = isVista ? (isClassic ? new InsetsUIResource(1, buttonPad, 1, buttonPad) : new InsetsUIResource(1, buttonPad, 2, buttonPad)) : (isClassic ? new InsetsUIResource(1, buttonPad, 1, buttonPad) : new InsetsUIResource(2, buttonPad, 3, buttonPad));
        DimensionUIResource dimensionUIResource = toolBarSeparatorSize = LookUtils.IS_JAVA_1_4_2_OR_LATER ? null : new DimensionUIResource(6, Options.getDefaultIconSize().height);
        InsetsUIResource textInsets = isVista ? (isClassic ? new InsetsUIResource(1, 2, 2, 2) : new InsetsUIResource(1, 2, 2, 2)) : (isClassic ? new InsetsUIResource(1, 2, 2, 2) : new InsetsUIResource(2, 2, 3, 2));
        int comboBorderSize = isClassic ? 2 : 1;
        int comboPopupBorderSize = 1;
        int comboRendererGap = textInsets.left + comboBorderSize - comboPopupBorderSize;
        EmptyBorder comboRendererBorder = new EmptyBorder(1, comboRendererGap, 1, comboRendererGap);
        Insets comboTableEditorInsets = new Insets(0, 0, 0, 0);
        InsetsUIResource insetsUIResource = menuItemMargin = LookUtils.IS_LOW_RESOLUTION ? new InsetsUIResource(3, 0, 3, 0) : new InsetsUIResource(2, 0, 2, 0);
        InsetsUIResource menuMargin = isXP ? (LookUtils.IS_LOW_RESOLUTION ? new InsetsUIResource(2, 3, 2, 4) : new InsetsUIResource(2, 5, 2, 6)) : (LookUtils.IS_LOW_RESOLUTION ? new InsetsUIResource(2, 3, 2, 3) : new InsetsUIResource(2, 4, 2, 4));
        int pad = isXP ? 3 : 0;
        InsetsUIResource popupMenuSeparatorMargin = LookUtils.IS_LOW_RESOLUTION ? new InsetsUIResource(2, pad, 3, pad) : new InsetsUIResource(3, pad, 4, pad);
        MinimumSizedIcon menuItemCheckIcon = new MinimumSizedIcon();
        int treeFontSize = table2.getFont("Tree.font").getSize();
        Integer rowHeight = new Integer(treeFontSize + 6);
        Class<?> superclass = ((Object)((Object)this)).getClass().getSuperclass();
        Color controlColor = table2.getColor("control");
        Color disabledTextBackground = table2.getColor("TextField.disabledBackground");
        Color inactiveTextBackground = table2.getColor("TextField.inactiveBackground");
        Object menuBarBackground = isXP ? table2.get("control") : table2.get("menu");
        Object menuSelectionBackground = isXP ? table2.get("MenuItem.selectionBackground") : table2.get("Menu.background");
        Object menuSelectionForeground = isXP ? table2.get("MenuItem.selectionForeground") : table2.get("Menu.foreground");
        Character passwordEchoChar = new Character(isXP ? (char)'\u25cf' : '*');
        Object[] defaults = new Object[]{"Button.border", buttonBorder, "Button.margin", buttonMargin, "CheckBox.border", marginBorder, "CheckBox.margin", checkBoxMargin, "ComboBox.disabledBackground", disabledTextBackground, "ComboBox.editorBorder", marginBorder, "ComboBox.editorColumns", new Integer(5), "ComboBox.editorInsets", textInsets, "ComboBox.tableEditorInsets", comboTableEditorInsets, "ComboBox.rendererBorder", comboRendererBorder, "EditorPane.margin", textInsets, "Menu.border", menuBorder, "Menu.borderPainted", Boolean.TRUE, "Menu.background", menuBarBackground, "Menu.selectionForeground", menuSelectionForeground, "Menu.selectionBackground", menuSelectionBackground, "Menu.margin", menuMargin, "MenuBar.background", menuBarBackground, "MenuBar.border", menuBarSeparatorBorder, "MenuBar.emptyBorder", menuBarEmptyBorder, "MenuBar.separatorBorder", menuBarSeparatorBorder, "MenuBar.etchedBorder", menuBarEtchedBorder, "MenuBar.headerBorder", menuBarHeaderBorder, "MenuItem.borderPainted", Boolean.TRUE, "MenuItem.checkIcon", menuItemCheckIcon, "MenuItem.margin", menuItemMargin, "CheckBoxMenuItem.margin", menuItemMargin, "RadioButtonMenuItem.margin", menuItemMargin, "FormattedTextField.disabledBackground", disabledTextBackground, "FormattedTextField.inactiveBackground", inactiveTextBackground, "FormattedTextField.margin", textInsets, "PasswordField.margin", textInsets, "PasswordField.echoChar", passwordEchoChar, "PopupMenu.border", WindowsBorders.getPopupMenuBorder(), "PopupMenu.noMarginBorder", WindowsBorders.getNoMarginPopupMenuBorder(), "PopupMenuSeparator.margin", popupMenuSeparatorMargin, "ScrollPane.etchedBorder", etchedBorder, "Spinner.defaultEditorInsets", textInsets, "RadioButton.border", marginBorder, "RadioButton.margin", checkBoxMargin, "Table.gridColor", controlColor, "TextArea.margin", textInsets, "TextArea.disabledBackground", disabledTextBackground, "TextArea.inactiveBackground", inactiveTextBackground, "TextField.margin", textInsets, "ToggleButton.margin", buttonMargin, "ToolBar.emptyBorder", toolBarEmptyBorder, "ToolBar.separatorBorder", toolBarSeparatorBorder, "ToolBar.etchedBorder", toolBarEtchedBorder, "ToolBar.headerBorder", toolBarHeaderBorder, "ToolBar.separatorSize", toolBarSeparatorSize, "ToolBar.margin", new InsetsUIResource(0, 10, 0, 0), "Tree.selectionBorderColor", controlColor, "Tree.rowHeight", rowHeight};
        if (LookUtils.IS_JAVA_1_4) {
            defaults = WindowsLookAndFeel.append(defaults, new Object[]{"InternalFrame.icon", WindowsLookAndFeel.makeIcon(superclass, (String)"icons/JavaCup.gif"), "OptionPane.errorIcon", isXP ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/Error.png") : WindowsLookAndFeel.makeIcon(superclass, (String)"icons/Error.gif"), "OptionPane.informationIcon", isXP ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/Inform.png") : WindowsLookAndFeel.makeIcon(superclass, (String)"icons/Inform.gif"), "OptionPane.warningIcon", isXP ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/Warn.png") : WindowsLookAndFeel.makeIcon(superclass, (String)"icons/Warn.gif"), "OptionPane.questionIcon", isXP ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/Inform.png") : WindowsLookAndFeel.makeIcon(superclass, (String)"icons/Question.gif")});
        }
        if (LookUtils.IS_JAVA_1_4 || LookUtils.IS_JAVA_5) {
            defaults = WindowsLookAndFeel.append(defaults, new Object[]{"Tree.openIcon", isXP ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/TreeOpen.png") : WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/TreeOpen.gif"), "Tree.closedIcon", isXP ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/TreeClosed.png") : WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/TreeClosed.gif")});
        }
        if (LookUtils.IS_JAVA_6_OR_LATER) {
            defaults = WindowsLookAndFeel.append(defaults, new Object[]{"Spinner.border", table2.get("TextField.border")});
        }
        table2.putDefaults(defaults);
    }

    private void initComponentDefaultsClassic(UIDefaults table2) {
        SimpleProxyLazyValue checkBoxIcon = new SimpleProxyLazyValue("com.jgoodies.looks.windows.WindowsLookAndFeel", "getCheckBoxIcon");
        SimpleProxyLazyValue radioButtonIcon = new SimpleProxyLazyValue("com.jgoodies.looks.windows.WindowsLookAndFeel", "getRadioButtonIcon");
        BasicBorders.FieldBorder winInsetBorder = new BasicBorders.FieldBorder(table2.getColor("controlShadow"), table2.getColor("controlDkShadow"), table2.getColor("controlHighlight"), table2.getColor("controlLtHighlight"));
        Object[] defaults = new Object[]{"CheckBox.checkColor", table2.get("controlText"), "CheckBox.icon", checkBoxIcon, "RadioButton.checkColor", table2.get("controlText"), "RadioButton.icon", radioButtonIcon, "Table.scrollPaneBorder", winInsetBorder};
        table2.putDefaults(defaults);
    }

    private void initComponentDefaultsXP14(UIDefaults table2) {
        Object[] defaults = new Object[]{"TitledBorder.titleColor", table2.getColor("activeCaption")};
        table2.putDefaults(defaults);
    }

    private void initFontDefaults(UIDefaults table2) {
        FontPolicy fontChoicePolicy = WindowsLookAndFeel.getFontPolicy();
        FontSet fontSet = fontChoicePolicy.getFontSet("Windows", table2);
        WindowsLookAndFeel.initFontDefaults(table2, fontSet);
    }

    private static void initFontDefaults(UIDefaults table2, FontSet fontSet) {
        FontUIResource controlFont = fontSet.getControlFont();
        FontUIResource menuFont = fontSet.getMenuFont();
        FontUIResource messageFont = fontSet.getMessageFont();
        FontUIResource toolTipFont = fontSet.getSmallFont();
        FontUIResource titleFont = fontSet.getTitleFont();
        FontUIResource windowFont = fontSet.getWindowTitleFont();
        Object[] defaults = new Object[]{"Button.font", controlFont, "CheckBox.font", controlFont, "ColorChooser.font", controlFont, "ComboBox.font", controlFont, "EditorPane.font", controlFont, "FormattedTextField.font", controlFont, "Label.font", controlFont, "List.font", controlFont, "Panel.font", controlFont, "PasswordField.font", controlFont, "ProgressBar.font", controlFont, "RadioButton.font", controlFont, "ScrollPane.font", controlFont, "Spinner.font", controlFont, "TabbedPane.font", controlFont, "Table.font", controlFont, "TableHeader.font", controlFont, "TextArea.font", controlFont, "TextField.font", controlFont, "TextPane.font", controlFont, "ToolBar.font", controlFont, "ToggleButton.font", controlFont, "Tree.font", controlFont, "Viewport.font", controlFont, "InternalFrame.titleFont", windowFont, "OptionPane.font", messageFont, "OptionPane.messageFont", messageFont, "OptionPane.buttonFont", messageFont, "TitledBorder.font", titleFont, "ToolTip.font", toolTipFont, "CheckBoxMenuItem.font", menuFont, "CheckBoxMenuItem.acceleratorFont", menuFont, "Menu.font", menuFont, "Menu.acceleratorFont", menuFont, "MenuBar.font", menuFont, "MenuItem.font", menuFont, "MenuItem.acceleratorFont", menuFont, "PopupMenu.font", menuFont, "RadioButtonMenuItem.font", menuFont, "RadioButtonMenuItem.acceleratorFont", menuFont};
        table2.putDefaults(defaults);
    }

    public static Border getButtonBorder() {
        return WindowsBorders.getButtonBorder();
    }

    public static Icon getCheckBoxIcon() {
        return WindowsIconFactory.getCheckBoxIcon();
    }

    public static Icon getRadioButtonIcon() {
        return WindowsIconFactory.getRadioButtonIcon();
    }

    private static Object[] append(Object[] source, String key, Object value) {
        int length = source.length;
        Object[] destination = new Object[length + 2];
        System.arraycopy(source, 0, destination, 0, length);
        destination[length] = key;
        destination[length + 1] = value;
        return destination;
    }

    private static Object[] append(Object[] source, Object[] keysAndValues) {
        int length = source.length;
        Object[] destination = new Object[length + keysAndValues.length];
        System.arraycopy(source, 0, destination, 0, length);
        for (int i2 = 0; i2 < keysAndValues.length; ++i2) {
            destination[length + i2] = keysAndValues[i2];
        }
        return destination;
    }

    private static class SimpleProxyLazyValue
    implements UIDefaults.LazyValue {
        private final String className;
        private final String methodName;

        public SimpleProxyLazyValue(String c2, String m) {
            this.className = c2;
            this.methodName = m;
        }

        public Object createValue(UIDefaults table2) {
            Object instance = null;
            try {
                ClassLoader classLoader;
                ClassLoader classLoader2 = classLoader = table2 != null ? (ClassLoader)table2.get("ClassLoader") : Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                Class<?> c2 = Class.forName(this.className, true, classLoader);
                Method m = c2.getMethod(this.methodName, null);
                instance = m.invoke(c2, null);
            }
            catch (Throwable t) {
                LookUtils.log("Problem creating " + this.className + " with method " + this.methodName + t);
            }
            return instance;
        }
    }
}

