/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;

final class WindowsArrowButton
extends BasicArrowButton {
    public WindowsArrowButton(int direction) {
        super(direction);
    }

    public Dimension getPreferredSize() {
        int width = Math.max(5, UIManager.getInt("ScrollBar.width"));
        return new Dimension(width, width);
    }

    public void paintTriangle(Graphics g2, int x, int y, int size, int triangleDirection, boolean isEnabled) {
        Color oldColor = g2.getColor();
        int j = 0;
        size = Math.max(size, 2);
        int mid = (size - 1) / 2;
        g2.translate(x, y);
        if (isEnabled) {
            g2.setColor(Color.black);
        } else {
            g2.setColor(UIManager.getColor("controlShadow"));
        }
        switch (triangleDirection) {
            case 1: {
                int i2;
                for (i2 = 0; i2 < size; ++i2) {
                    g2.drawLine(mid - i2, i2, mid + i2, i2);
                }
                if (isEnabled) break;
                g2.setColor(UIManager.getColor("controlLtHighlight"));
                g2.drawLine(mid - i2 + 2, i2, mid + i2, i2);
                break;
            }
            case 5: {
                int i3;
                if (!isEnabled) {
                    g2.translate(1, 1);
                    g2.setColor(UIManager.getColor("controlLtHighlight"));
                    for (i3 = size - 1; i3 >= 0; --i3) {
                        g2.drawLine(mid - i3, j, mid + i3, j);
                        ++j;
                    }
                    g2.translate(-1, -1);
                    g2.setColor(UIManager.getColor("controlShadow"));
                }
                j = 0;
                for (i3 = size - 1; i3 >= 0; --i3) {
                    g2.drawLine(mid - i3, j, mid + i3, j);
                    ++j;
                }
                break;
            }
            case 7: {
                int i4;
                for (i4 = 0; i4 < size; ++i4) {
                    g2.drawLine(i4, mid - i4, i4, mid + i4);
                }
                if (isEnabled) break;
                g2.setColor(UIManager.getColor("controlLtHighlight"));
                g2.drawLine(i4, mid - i4 + 2, i4, mid + i4);
                break;
            }
            case 3: {
                int i5;
                if (!isEnabled) {
                    g2.translate(1, 1);
                    g2.setColor(UIManager.getColor("controlLtHighlight"));
                    for (i5 = size - 1; i5 >= 0; --i5) {
                        g2.drawLine(j, mid - i5, j, mid + i5);
                        ++j;
                    }
                    g2.translate(-1, -1);
                    g2.setColor(UIManager.getColor("controlShadow"));
                }
                j = 0;
                for (i5 = size - 1; i5 >= 0; --i5) {
                    g2.drawLine(j, mid - i5, j, mid + i5);
                    ++j;
                }
                break;
            }
        }
        g2.translate(-x, -y);
        g2.setColor(oldColor);
    }
}

