
separate (gameutils)

-- Warning:  this logic is not fully generalized...
--           Sokoban input files must be screened carefully.
--
--           On the other hand, Ada length function omits
--           confusing control characters at EOL, so we 
--           don't need to distinguish DOS from Unix files.
--

procedure readPuzzle( level: integer ) is

  gfil : file_type;
  l1,l2: natural := 1;
  rcd1, rcd2: string(1..mcols);
  lvl0 : integer := level-1;
  lv, nrcpt : integer := 0;

	function isblank( line : string; len:integer ) return boolean is
	begin

		if( len < 1 ) then return true; end if;

		for i in 1..len loop
		  if( line(i) = '#' ) then return false; end if;
		end loop;
		return true;
	end isblank;

begin


	myassert( level >= 1, 101 );
	myassert( level <= mxlev, 102 );
	myassert( dod >= 1, 103 );
	myassert( dod <= mxdeg, 104 );


	for i in 1..mrows loop
	for j in 1..mcols loop
		wall(i,j):=false;
		barl(i,j):=false;
		rcpt(i,j):=false;
	end loop;
	end loop;
	nbarrels:=0;


   text_io.open( file=> gfil, name=> pfname(dod), mode=>text_io.in_file);

	while( lv < lvl0 ) loop

		 rcd2:=(others=>' ');
     text_io.get_line(gfil, rcd2, l2); 

		--get 1st nonblank into rcd2
     while( isblank(rcd2,l2) ) loop
	    rcd1:=rcd2;  l1:=l2;  
		 rcd2:=(others=>' ');
       text_io.get_line(gfil, rcd2, l2); 
     end loop;
	  -- rcd2 is 1st nonblank

	--go to end of data block:
	  while( not isblank(rcd2,l2) ) loop
	  	 rcd1:=rcd2; l1:=l2;
		 rcd2:=(others=>' ');
       text_io.get_line(gfil, rcd2, l2);
	 end loop;
	 lv := lv+1; -- 1-based block count

	end loop;


	 rcd2:=(others=>' ');
    text_io.get_line(gfil, rcd2, l2); 

	--get 1st nonblank into rcd2
    while( isblank(rcd2,l2) ) loop 
	    rcd1:=rcd2;  l1:=l2;
		 rcd2:=(others=>' ');
       text_io.get_line(gfil, rcd2, l2); 
    end loop;
	-- rcd2 is 1st nonblank


-- we should now be in the right place with rcd2 holding 1st pattern


	nrows:=0; ncols:=0;
	loop 
		rcd1:=rcd2; l1:=l2;
		nrows := nrows + 1;
		if( l1>ncols ) then ncols:=l1; end if;
		for col in 1..l1 loop
			case rcd1(col) is
			when '#' =>  --wall
				wall(nrows,col):=true;

			when ' ' => --space
				null;

			when '.' =>  --goal
				rcpt(nrows,col):=true;
				nrcpt:=nrcpt+1;

			when '$' =>  --box
				barl(nrows,col):=true;
				nbarrels:=nbarrels+1;

			when '@' =>  --pusher
				null;

			when '+' =>  -- goal + pusher
				rcpt(nrows,col):=true;
				nrcpt:=nrcpt+1;

			when '*' =>  -- both goal and barrel
				rcpt(nrows,col):=true;
				nrcpt:=nrcpt+1;
				barl(nrows,col):=true;
				nbarrels:=nbarrels+1;

			when others => -- treat as space
				null;

			end case;

		end loop; --col

		exit when end_of_file(gfil); -- 26feb15 critical addendum
		 rcd2:=(others=>' ');
		text_io.get_line(gfil, rcd2, l2); --l2 excludes control chars; nice!
		exit when l2=0;


	end loop;

   text_io.close(gfil);


	myassert( nbarrels = nrcpt, 105 );
	myassert( nbarrels <= mxbarrels, 106 );
	myassert( nrows <= mrows, 107 );
	myassert( ncols < mcols, 108 ); -- need 1 extra char for EOL

end readPuzzle;



