#version 330 core

in float mynoise; // -eps...+eps

in vec3 oPos;
in float dotp;

out vec4 color;

uniform sampler2D myTextureSampler; //unused

// color assigned to match radial perturbations



void main(){

	float whiteness = clamp( 1.0 - abs(dotp), 0.0,1.0);

	float spread = 16.0; // color spread
	float yavg=0.3; // avg color (bigger=>darker)

	float yval= spread*mynoise;
	float tt = clamp(yval+yavg,0.0,1.0);
	vec3 dblu = vec3(0/255.,100/255.,200/255.); //darkerBlue
	vec3 white = vec3(1.,1.,1.);
	vec3 dlta = white-dblu;

	vec3 rgb = dblu + (1.0-tt)*dlta; //pure noise-based color
	vec3 col = mix( rgb, white, whiteness ); //add white @ fringe

	float opac = 0.9;
	color = vec4(col, opac);

	// oPos should be on a unit sphere.
	// this removes graphical glitch:
	if(length(oPos)>1.0001) discard;


}

/*
--
-- Copyright (C) 2020  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--
*/

