##=======================================================================================
## $var = &inline_link($var); で変換
sub inline_link {
	local($_) = $_[0]; 
	if (($_ =~ / src=/i)||($_ =~ / href=/i)) {
		$_;
	} else {
		$_ =~ s/([^=^\"]|^)((http|https|ftp)\:\/\/[a-zA-Z0-9\.\$\,\;\:\&\=\?\!\*\~\@\#\_\(\)\%\+\-\/]*)/$1<a href=\"$2\" target=\"_blank\">$2<\/a>/g;
	}
	$_;
}
##=======================================================================================
## $var = &cgi_include($var); で変換
## 書式 <!--#include file="./sample.txt" -->
sub cgi_include {
	local($_) = $_[0]; 
	if ($_ =~ /<\!--\#include file=\"/i) {
		($inc0,$inc1)=split(/<\!--\#include file=\"/,$_);
		$inc1=~ s/\" -->/\"-->/g;
		($incpath,$inc2)=split(/\"-->/,$inc1);
		if ($incpath !~ /\//i) { $incpath='./'.$incpath; }
		if (($incpath !~ /\.\.\//i)||($incpath !~ /\.\//i)) {
			if ($RootPath eq '') { 
				$incpath='..'.$incpath;
			} else {
				@ReqPath=split(/\//,$ENV{'REQUEST_URI'});
				$ReqLot=@ReqPath-2;
				if ($ReqLot > 0) {
					for (1..$ReqLot) {
						$incpath='../'.$incpath;
					}
				} else { 
					$incpath='../'.$incpath;
				}
				$incpath=~ s/\/\//\//g;
			}
		}
		if (open(INCRD,"$incpath")) {
			$IncData='';
			@IncLines = <INCRD>;
			close(INCRD);
			##文字コード判定→UTF8変換
			my $contCC=&checkCharCode($incpath);
			if ($contCC eq 'shiftjis') {
				foreach (@IncLines) { Encode::from_to($_, 'shiftjis', 'utf8'); }
			}
			foreach (@IncLines) { $IncData=$IncData.$_.''; }
			$_=$inc0.$IncData.$inc2.'';
		}
	}
	$_=~ s/class=\"KijiArea\"/class=\"IncludeArea\"/g;
	$_;
}
##=======================================================================================
## $var = &url_import($var); で変換
## 書式 <!--#include url="http://mydom.com/sample.txt" -->
sub url_import { 
	local($_) = $_[0]; 
	if ($_ =~ /<\!--\#include url=\"/i) {
		($inc0,$inc1)=split(/<\!--\#include url=\"/,$_);
		$inc1=~ s/\" -->/\"-->/g;
		($incurl,$inc2)=split(/\"-->/,$inc1);
		use LWP::Simple;
		$ImpData=get($incurl);
		Encode::from_to($ImpData, 'shiftjis', 'utf8');
		$_=$inc0.$ImpData.$inc2.'';
		$_=~ s/class=\"KijiArea\"/class=\"IncludeArea\"/g;
	}
	if ($_ =~ /<\!--\#include url:utf8=\"/i) {
		($inc0,$inc1)=split(/<\!--\#include url:utf8=\"/,$_);
		$inc1=~ s/\" -->/\"-->/g;
		($incurl,$inc2)=split(/\"-->/,$inc1);
		use LWP::Simple;
		$ImpData=get($incurl);
		$_=$inc0.$ImpData.$inc2.'';
		$_=~ s/class=\"KijiArea\"/class=\"IncludeArea\"/g;
	}
	if ($_ =~ /<\!--\#include url:eucjp=\"/i) {
		($inc0,$inc1)=split(/<\!--\#include url:eucjp=\"/,$_);
		$inc1=~ s/\" -->/\"-->/g;
		($incurl,$inc2)=split(/\"-->/,$inc1);
		use LWP::Simple;
		$ImpData=get($incurl);
		Encode::from_to($ImpData, 'shiftjis', 'utf8');
		$_=$inc0.$ImpData.$inc2.'';
		$_=~ s/class=\"KijiArea\"/class=\"IncludeArea\"/g;
	}
	$_;
}
##=======================================================================================
## $var = &checkCharCode('./FilePath'); で判定する
## $var には、shiftjis 7bit-jis utf8 false のいずれかが格納される
sub checkCharCode {
my $checkFile = $_[0]; 

##ファイル読込
if (open(CHARRD,"$checkFile")) {
	my @CHARCODE = <CHARRD>;
	close(CHARRD);
	my $i=0; my $charData;
	foreach (@CHARCODE) {
		$charData=$charData.$CHARCODE[$i];
		$i++;
	}
	if ($charData ne '') {
		##文字コード判定
		my $enc;
		my $enctype;
		use Encode::Guess qw/shiftjis 7bit-jis/;
		$enc = guess_encoding($charData);
		if (ref($enc)) {
			$enctype = $enc->name;
			return $enctype;
		} else {
			return 'false';
		}
	} else {
		return 'shiftjis';
	}
} else {
	return 'false';
}


}
##=======================================================================================
# ファイルリストの取得 
# &GetFilelist(ディレクトリ, 拡張子, スイッチ);
# 返り値：ファイル一覧（ディレクトリが開けない場合は「false」） 
# ディレクトリは相対パスで指定（絶対パスは不可） 
# 拡張子は「/（スラッシュ）」で区切ることで複数指定可 
# 拡張子に「.[*]」を指定すると全てのファイルを返す 
# 拡張子に0を指定する（&GetFilelist(ディレクトリ, 0, スイッチ);）とディレクトリ一覧を返す 
# スイッチは0か1を指定。1を指定するとファイル名を全て小文字に変換して検索。
# 0の場合は大文字と小文字が区別される 
sub GetFilelist {

# 引数の取得、変数の準備
my ($dir, $extension, $swich) = @_;
my ($temp, $file, $e, $n, @filelist);
my $i = 0;

# 複数指定の拡張子を分割
my @ext = split(/\//, $extension);

# ディレクトリを開く
opendir (DIR , $dir) || return 0;

# ディレクトリにあるファイル等を１つずつ抽出
while ($file = readdir DIR) {
	# ゴミをはじく
	if ($file =~ /^\.{1,2}$/) {
		next;
	} else {
		# 大文字小文字の判定
		if ($swich == 1) {
			$temp = lc($file);
			foreach (@ext) {
				$_ = lc($_);
			}
		} else {
			 $temp = $file;
		}
		# ファイルが指定拡張子と合致するかを拡張子毎にチェック
		foreach $e (@ext) {
			# 拡張子が指定されていて且つ、ワイルドカードではない
			if ($e && $e ne ".[*]") {
				# 拡張子以外の文字列に引っかからないための措置
				if (index($temp, $e, length($temp) - length($e)) != -1) {
					$filelist[$i] = $file;
					$i++;
					# ヒットしたら次のファイルへ
					last;
				} else {
					# ヒットしないため別の拡張子へ
					next;
				}
			} else {
					# ワイルドカードを指定された時
					if ($e eq ".[*]") {
						if ($file =~/\./) {
							$filelist[$i] = $file;
							$i++;
							last;
						}
					} else {
						# 拡張子の指定がない時
						$filelist[$i] = $file;
						$i++;
						last;
					}
			}
		}
	}
}

closedir(DIR) ;

# 結果としてファイル一覧を返す
return @filelist;

}
##=======================================================================================
# Cookie認証書込
sub set_cookie {


$ENV{'TZ'} = "GMT"; 
(my $c_sec,my $c_min,my $c_hour,my $c_mday,my $c_mon,my $c_year,my $c_wday,my $c_yday,my $c_isdst) = localtime(time + $LogoutTime);
$c_year = sprintf("%04d",$c_year + 1900);
$c_sec  = sprintf("%02d",$c_sec);
$c_min  = sprintf("%02d",$c_min);
$c_hour = sprintf("%02d",$c_hour);
$c_mday = sprintf("%02d",$c_mday);
my $youbi = ('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday') [$c_wday];
my $month = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec') [$c_mon];
my $date_gmt = "$youbi, $c_mday\-$month\-$c_year $c_hour:$c_min:$c_sec GMT";

$c_id = $in{'admin_id'};
	$c_id =~ s/=/\|eq\|/g;
	$c_id =~ s/!/\|excr\|/g;
	$c_id =~ s/,/\|coma\|/g;
	$c_id =~ s/:/\|clgn\|/g;
	$c_id =~ s/;/\|semc\|/g;
$c_pw = $in{'admin_pw'};
	$c_pw =crypt($c_pw,'ae');
	$c_pw =~ s/=/\|eq\|/g;
	$c_pw =~ s/!/\|excr\|/g;
	$c_pw =~ s/,/\|coma\|/g;
	$c_pw =~ s/:/\|clgn\|/g;
	$c_pw =~ s/;/\|semc\|/g;

my $cook = "id\!$c_id\,pw\!$c_pw";

if ((-e $conffile)&&($Domain ne 'www.yourdomain.com')) {
	$Domain =~ s/www.//g;
	my $dom1=$Domain; my $dom2='www.'.$Domain;
	print "Set-Cookie: $CookieName=$cook; path=/; domain=$dom1; expires=$date_gmt;\n";
	print "Set-Cookie: $CookieName=$cook; path=/; domain=$dom2; expires=$date_gmt;\n";
} else {
	print "Set-Cookie: $CookieName=$cook; expires=$date_gmt;\n";
}

}
##=======================================================================================
# Cookie認証取得
sub get_cookie {

my $cookies = $ENV{'HTTP_COOKIE'};
my @pairs = split(/;/,$cookies);
my %DUMMY;
my %COOKIE;
foreach my $pair (@pairs) {
	(my $name,my $value) = split(/=/, $pair);
	$name =~ s/ //g;
	$DUMMY{$name} = $value;
}
@pairs = split(/,/,$DUMMY{$CookieName});
my $pair;
my $value;
my $name;
foreach $pair (@pairs) {
	($name, $value) = split(/\!/, $pair);
	$value =~ s/\|eq\|/=/g;
	$value =~ s/\|excr\|/!/g;
	$value =~ s/\|coma\|/,/g;
	$value =~ s/\|clgn\|/:/g;
	$value =~ s/\|semc\|/;/g;
	$COOKIE{$name} = $value;
}
$ck_id = $COOKIE{'id'};
$ck_pw = $COOKIE{'pw'};

}
##=======================================================================================
sub domain_name {
	local($addr) = $ENV{'REMOTE_ADDR'};
	local($_) = gethostbyaddr(pack("C4",split(/\./,$addr)),2);
	if ($_ eq '') { $_ = $addr; }
	$_;
}
##=======================================================================================
# エラー画面出力
sub error {

my $error = $_[0];
my $ReturnLink='<a href="javascript:history.go(-1)">[先程のページへ戻る]</a>';

##★エラーメッセージの変更はここを訂正
my $errHTML = <<"ERRORMESS";
<h4 align="center"><span style="color:#ff0000">ERROR</span></h4>
<div align="center">&nbsp;<br>$error<br>&nbsp;<br>$ReturnLink</div>
ERRORMESS

&html_head;
print "$errHTML\n";
&html_foot;
exit;

}
##=======================================================================================
# 画像のサイズ(幅と高さ)を取得するサブルーチン
# ($format,$width,$height)= &GetImageSize( $FileName, [$out] );
sub GetImageSize{
    my ( $IMG, $in ) = @_;
    my ( %SHT, %LNG );
    my ( $buf, $mark, $type, $f_size, $width, $height );
    my ( $TAG, $TYPE, $COUNT, $V_OFFSET, $PK, $ENTRY, $Exif_IFD );
    my ( $endian, $dummy1, $dummy2, $dummy, $EOI, $APP1, $length, $exif );
    my ( $format, $offset, $line, $CODE, $jfif, $i );
    my @TGA;
    my $ntag;
    # 定数
    $mark = pack("C", 0xff);
    %SHT = ( 'II' => 'v', 'MM' => 'n' );
    %LNG = ( 'II' => 'V', 'MM' => 'N' );
    # 初期値
    $endian   = '';
    $width    = -1;
    $height   = -1;
    $format   = '';
    $Exif_IFD = -1;
    if( $in eq '' ){
	$in = 'IMG';
    }
    open( $in, $IMG ) || return( '', -1, -1 );
    binmode($in);
    seek( $in, 0, 0 );
    read( $in, $buf, 6 );
    # GIF 形式
    if($buf =~ /^GIF/i){
	$format = 'GIF';
	read( $in, $buf, 2 );
	$width  = unpack("v*", $buf);
	read( $in, $buf, 2);
	$height = unpack("v*", $buf);
    # Windows Bit Map 形式
    }elsif($buf =~ /BM/){
	$format = 'BMP';
	seek( $in, 12, 1 );
	read( $in, $buf, 8 );
	($width, $height) = unpack("VV", $buf);
    # TIFF 形式
    }elsif( $buf =~ /(II)/ || $buf =~ /(MM)/ ){
	$format = 'TIFF';
	$endian = $1;
	seek( $in, 0, 0 );
	read( $in, $buf, 8 );
	( $endian, $dummy1, $offset ) = 
	    unpack( "A2$SHT{$endian}$LNG{$endian}", $buf );
	seek( $in, $offset, 0 );
	read( $in, $buf, 2 );
	$ENTRY = unpack( $SHT{$endian}, $buf );
	for( $i = 0 ; $i < $ENTRY ; $i++ ){
	    read( $in, $buf, 8 );
	    $PK = "$SHT{$endian}$SHT{$endian}$LNG{$endian}";
	    ( $TAG, $TYPE, $COUNT ) = unpack( $PK, $buf );
	    read( $in, $buf, 4 );
	    ( $TAG != 256 && $TAG != 257 ) and next;
	    if( $TYPE == 3 ){
		$PK = "$SHT{$endian}";
	    }elsif( $TYPE == 4 ){
		$PK = "$LNG{$endian}";
	    }else{
		next;
	    }
	    $V_OFFSET = unpack( $PK, $buf );

	    # Image width and height
	    ( $TAG == 256   ) and ( $width  = $V_OFFSET   );
	    ( $TAG == 257   ) and ( $height = $V_OFFSET   );
	    ( $TAG == 34665 ) and ( $format .= '-EXIF'    );
	}
    # PPM 形式
    }elsif( $buf =~ /^(P[123456])\n/ ){
	if( $1 eq 'P1' || $1 eq 'P4' ){
	    $format = 'PBM';
	}elsif( $1 eq 'P2' || $1 eq 'P5' ){
	    $format = 'PGM';
	}else{
	    $format = 'PPM';
	}
	seek( $in, 0, 0 );
	<$in>;
	while( <$in> ){
	    next if ( /^\#/ );
	    chomp;
	    ( $width, $height ) = split( /\s+/, $_ );
	    last;
	}
    # PNG 形式
    }elsif( $buf =~ /PNG/){
	$format = 'PNG';
	seek( $in, 8, 0 );
	while(1){
	    read( $in, $buf, 8 );
	    ( $offset, $CODE ) = unpack( "NA4", $buf );
	    if( $CODE eq 'IHDR' ){
		read( $in, $buf, 8 );
		( $width, $height ) = unpack( "NN", $buf );
		seek( $in, $offset-8+4, 1 );
		last;
	    }elsif( $CODE eq 'IEND' ){
		last;
	    }else{
		seek( $in, $offset+4, 1 );
	    }
	}
    }else{
	# JPEG 形式
	seek( $in, 0, 0 );
	read( $in, $buf, 2 );
	( $buf, $type ) = unpack("C*", $buf );
	if( $buf == 0xFF && $type == 0xD8 ){
	    $format = 'JPEG';
	  JPEG:while(read( $in, $buf, 1 )){
	      if(($buf eq $mark) && read( $in, $buf, 3 )){
		  $type   = unpack("C*", substr($buf, 0, 1));
		  $f_size = unpack("n*", substr($buf, 1, 2));
		  ( $type == 0xD9 ) and ( last JPEG );
		  ( $type == 0xDA ) and ( last JPEG );
		  if($type == 0xC0 || $type == 0xC2){
		      read( $in, $buf, $f_size-2 );
		      $height = unpack("n*", substr($buf, 1, 2));
		      $width  = unpack("n*", substr($buf, 3, 2));
		      ( $format =~ /EXIF/ ) and ( last JPEG );
		  }elsif( $type == 0xE1 ){
		      read( $in, $buf, $f_size-2 );
		      $exif = unpack( "A4", substr( $buf, 0, 4 ) );
		      if( $exif =~ /exif/i ){
			  $format .= '-EXIF';
			  ( $width > 0 && $height > 0 ) and ( last JPEG );
		      }
		  }elsif( $type == 0xE0 ){
		      read( $in, $buf, $f_size-2 );
		      $jfif = unpack( "A4", substr( $buf, 0, 4 ) );
		      if( $jfif =~ /jfif/i ){
			  $format .= '-JFIF';
		      }
		  }elsif( $type == 0x01 || $type == 0xFF ||
			  ( $type >= 0xD0 && $type < 0xD9 ) ){
		      seek( $in, -2, 1 );
		  }else{
		      read( $in, $buf, $f_size-2 );
		  }
	      }
	  }
	}
	if( $width > 0 && $height > 0 ){
	    close( $in );
	    return( $format, $width, $height );
	}
	# TGA 形式
	seek( $in, 0, 0 );
	read( $in, $buf, 18 );
	@TGA = unpack( "CCCvvCvvvvCC", $buf );
	if( $TGA[1] == 0 || $TGA[1] == 1 ){
	    if( $TGA[2] ==  0 || $TGA[2] == 1 || $TGA[2] ==  2 ||
		$TGA[2] ==  3 || $TGA[2] == 9 || $TGA[2] == 10 ||
		$TGA[1] == 11 ){
		$format = 'TGA';
		$width  = $TGA[8];
		$height = $TGA[9];
	    }
	}
    }
    close( $in );
    return( $format, $width, $height );
}

1;
##=======================================================================================
# WYSIWYG用変換ライブラリ
sub wgmsg {

$wgmsg = $_[0];
$wgmsg =~ s/<A/<a/g;
$wgmsg =~ s/<\/A>/<\/a>/g;
$wgmsg =~ s/target\|eq\|_blank/target\|eq\|\|quot\|_blank\|quot\|/g;
$wgmsg =~ s/<BR>/<br>/g;
$wgmsg =~ s/<P>/<p>/g;
$wgmsg =~ s/<\/P>/<\/p>/g;
$wgmsg =~ s/<HR>/<hr>/g;
$wgmsg =~ s/<hr size\|eq\|\|quot\|2\|quot\| width\|eq\|\|quot\|100\%\|quot\|>/<hr>/g;
$wgmsg =~ s/<hr style\|eq\|\|quot\|width\: 100\%; height\: 2px\;\|quot\|>/<hr>/g;
$wgmsg =~ s/<TABLE/<table/g;
$wgmsg =~ s/<\/TABLE>/<\/table>/g;
$wgmsg =~ s/<FONT/<font/g;
$wgmsg =~ s/<\/FONT>/<\/font>/g;
$wgmsg =~ s/<DIV/<div/g;
$wgmsg =~ s/<\/DIV>/<\/div>/g;
$wgmsg =~ s/<br clear\|eq\|\|quot\|all\|quot\| \/><br clear\|eq\|\|quot\|all\|quot\| \/>/<br clear\|eq\|\|quot\|all\|quot\| \/>/g;
$wgmsg =~ s/TBODY>/tbody>/g;
$wgmsg =~ s/<OL/<ol/g;
$wgmsg =~ s/\/OL>/\/ol>/g;
$wgmsg =~ s/<UL/<ul/g;
$wgmsg =~ s/\/UL>/\/ul>/g;
$wgmsg =~ s/<LI/<li/g;
$wgmsg =~ s/\/LI>/\/li>/g;
$wgmsg =~ s/<U/<u/g;
$wgmsg =~ s/\/U>/\/u>/g;
$wgmsg =~ s/<EM/<em/g;
$wgmsg =~ s/\/EM>/\/em>/g;
$wgmsg =~ s/<STRIKE/<strike/g;
$wgmsg =~ s/\/STRIKE>/\/strike>/g;
$wgmsg =~ s/<TR/<tr/g;
$wgmsg =~ s/\/TR>/\/tr>/g;
$wgmsg =~ s/<TD/<td/g;
$wgmsg =~ s/\/TD>/\/td>/g;
$wgmsg =~ s/<IMG (.*)\|quot\|>/<img $1\|quot\| \/>/g;
$wgmsg =~ s/alt\|eq\|\|quot\|\|quot\|/alt\|eq\|\|quot\|Atacched File\|quot\|/g;
$wgmsg =~ s/ name\|eq\|([a-zA-Z0-9]*)>/ name\|eq\|\|quot\|$1\|quot\|>/g;
$wgmsg =~ s/ name\|eq\|([a-zA-Z0-9]*) / name\|eq\|\|quot\|$1\|quot\| /g;
$wgmsg =~ s/ class\|eq\|([a-zA-Z0-9]*)>/ class\|eq\|\|quot\|$1\|quot\|>/g;
$wgmsg =~ s/ class\|eq\|([a-zA-Z0-9]*) / class\|eq\|\|quot\|$1\|quot\| /g;
$wgmsg =~ s/ classname\|eq\|([a-zA-Z0-9]*)>/ classname\|eq\|\|quot\|$1\|quot\|>/g;
$wgmsg =~ s/ classname\|eq\|([a-zA-Z0-9]*) / classname\|eq\|\|quot\|$1\|quot\| /g;
$wgmsg =~ s/ target\|eq\|([a-zA-Z0-9]*)>/ target\|eq\|\|quot\|$1\|quot\|>/g;
$wgmsg =~ s/ target\|eq\|([a-zA-Z0-9]*) / target\|eq\|\|quot\|$1\|quot\| /g;
$wgmsg =~ s/ hspace\|eq\|([a-zA-Z0-9]*)>/ hspace\|eq\|\|quot\|$1\|quot\|>/g;
$wgmsg =~ s/ hspace\|eq\|([a-zA-Z0-9]*) / hspace\|eq\|\|quot\|$1\|quot\| /g;
$wgmsg =~ s/ size\|eq\|([a-zA-Z0-9]*)>/ size\|eq\|\|quot\|$1\|quot\|>/g;
$wgmsg =~ s/ size\|eq\|([a-zA-Z0-9]*) / size\|eq\|\|quot\|$1\|quot\| /g;
$wgmsg =~ s/ color\|eq\|([a-zA-Z0-9\#]*)>/ color\|eq\|\|quot\|$1\|quot\|>/g;
$wgmsg =~ s/ color\|eq\|([a-zA-Z0-9\#]*) / color\|eq\|\|quot\|$1\|quot\| /g;
$wgmsg =~ s/ border\|eq\|([a-zA-Z0-9]*)>/ border\|eq\|\|quot\|$1\|quot\|>/g;
$wgmsg =~ s/ border\|eq\|([a-zA-Z0-9]*) / border\|eq\|\|quot\|$1\|quot\| /g;
$wgmsg =~ s/ cellSpacing\|eq\|([a-zA-Z0-9]*) / cellspacing\|eq\|\|quot\|$1\|quot\| /g;
$wgmsg =~ s/ borderColor\|eq\|([a-zA-Z0-9\#]*) / bordercolor\|eq\|\|quot\|$1\|quot\| /g;
$wgmsg =~ s/ cellPadding\|eq\|([a-zA-Z0-9]*) / cellpadding\|eq\|\|quot\|$1\|quot\| /g;
$wgmsg =~ s/ bgColor\|eq\|([a-zA-Z0-9\#]*)/ bgcolor\|eq\|\|quot\|$1\|quot\|/g;
$wgmsg =~ s/ align\|eq\|([a-zA-Z0-9]*)>/ align\|eq\|\|quot\|$1\|quot\|>/g;
$wgmsg =~ s/ align\|eq\|([a-zA-Z0-9]*) / align\|eq\|\|quot\|$1\|quot\| /g;
$wgmsg =~ s/\|eq\|\|quot\|\|quot\|\|quot\|/\|eq\|\|quot\|/g;

}
##=======================================================================================

1;