/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.Node;
import javax.media.j3d.PointSound;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import org.jdesktop.j3d.loaders.vrml97.impl.AudioClip;
import org.jdesktop.j3d.loaders.vrml97.impl.Browser;
import org.jdesktop.j3d.loaders.vrml97.impl.ContentNegotiator;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.NonSharedNode;
import org.jdesktop.j3d.loaders.vrml97.impl.RGroup;
import org.jdesktop.j3d.loaders.vrml97.impl.SFBool;
import org.jdesktop.j3d.loaders.vrml97.impl.SFFloat;
import org.jdesktop.j3d.loaders.vrml97.impl.SFNode;
import org.jdesktop.j3d.loaders.vrml97.impl.SFVec3f;

public class Sound
extends NonSharedNode {
    SFVec3f direction;
    SFFloat intensity;
    SFVec3f location;
    SFFloat maxBack;
    SFFloat maxFront;
    SFFloat minBack;
    SFFloat minFront;
    SFFloat priority;
    SFNode source;
    SFBool spatialize;
    BranchGroup impl;
    PointSound soundImpl;
    boolean wait = false;
    Point3f pos3f = new Point3f();
    Point3d pos3d = new Point3d();
    BoundingSphere bounds = new BoundingSphere();
    float[] distance = new float[2];
    float[] attenuation = new float[2];
    MediaContainer media;
    AudioClip clip;

    public Sound(Loader loader) {
        super(loader);
        this.direction = new SFVec3f(0.0f, 0.0f, 1.0f);
        this.intensity = new SFFloat(1.0f);
        this.location = new SFVec3f(0.0f, 0.0f, 0.0f);
        this.maxBack = new SFFloat(10.0f);
        this.maxFront = new SFFloat(10.0f);
        this.minBack = new SFFloat(1.0f);
        this.minFront = new SFFloat(1.0f);
        this.priority = new SFFloat(0.0f);
        this.source = new SFNode();
        this.spatialize = new SFBool(true);
        this.initFields();
    }

    public Sound(Loader loader, SFVec3f direction, SFFloat intensity, SFVec3f location, SFFloat maxBack, SFFloat maxFront, SFFloat minBack, SFFloat minFront, SFFloat priority, SFNode source, SFBool spatialize) {
        super(loader);
        this.direction = direction;
        this.intensity = intensity;
        this.location = location;
        this.maxBack = maxBack;
        this.maxFront = maxFront;
        this.minBack = minBack;
        this.minFront = minFront;
        this.priority = priority;
        this.source = source;
        this.initFields();
    }

    public void initImpl() {
        this.pos3f.x = this.location.value[0];
        this.pos3f.y = this.location.value[1];
        this.pos3f.z = this.location.value[2];
        this.pos3d.x = this.pos3f.x;
        this.pos3d.y = this.pos3f.y;
        this.pos3d.z = this.pos3f.z;
        this.soundImpl = new PointSound();
        this.soundImpl.setPosition(this.pos3f);
        this.bounds.setCenter(this.pos3d);
        this.bounds.setRadius((double)this.maxFront.value);
        this.soundImpl.setReleaseEnable(false);
        this.soundImpl.setContinuousEnable(false);
        this.soundImpl.setSchedulingBounds((Bounds)this.bounds);
        this.soundImpl.setInitialGain(this.intensity.value);
        this.soundImpl.setLoop(0);
        this.distance[0] = this.minFront.value;
        this.distance[1] = this.maxFront.value * 100.0f;
        this.attenuation[0] = 1.0f;
        this.attenuation[1] = 0.0f;
        this.soundImpl.setDistanceGain(this.distance, this.attenuation);
        this.soundImpl.setCapability(23);
        this.soundImpl.setCapability(15);
        this.soundImpl.setCapability(13);
        this.soundImpl.setCapability(28);
        this.soundImpl.setCapability(30);
        this.soundImpl.setCapability(25);
        this.soundImpl.setCapability(21);
        this.soundImpl.setCapability(17);
        this.soundImpl.setCapability(19);
        this.soundImpl.setCapability(29);
        this.setClip();
        this.impl = new RGroup();
        this.impl.addChild((Node)this.soundImpl);
        this.implNode = this.impl;
        this.implReady = true;
    }

    void setClip() {
        if (this.source.node != null && this.source.node instanceof AudioClip) {
            if (Browser.debug) {
                System.out.println(this + " setClip() available");
            }
            this.clip = (AudioClip)this.source.node;
            if (this.media != this.clip.impl) {
                this.media = this.clip.impl;
                this.clip.setSound(this);
            }
            if (Browser.debug) {
                System.out.println(this.browser.environment.getAudioDevice());
            }
            this.soundImpl.setSoundData(this.media);
            this.waitSoundReadiness();
            long duration = this.soundImpl.getDuration();
            if (Browser.debug) {
                System.out.println(this + " duration = " + duration);
            }
            this.clip.setDuration((double)duration / 1000.0);
        } else {
            if (Browser.debug) {
                System.out.println(this + "setClip() null media");
            }
            this.soundImpl.setSoundData(null);
        }
    }

    void setEnable(boolean enable) {
        this.soundImpl.setEnable(enable);
    }

    void setLoop(int l) {
        this.soundImpl.setLoop(l);
    }

    public void notifyMethod(String eventInName, double time) {
    }

    void doneParse() {
    }

    void initFields() {
        this.direction.init(this, this.FieldSpec, 3, "direction");
        this.intensity.init(this, this.FieldSpec, 3, "intensity");
        this.location.init(this, this.FieldSpec, 3, "location");
        this.maxBack.init(this, this.FieldSpec, 3, "maxBack");
        this.minBack.init(this, this.FieldSpec, 3, "minBack");
        this.minFront.init(this, this.FieldSpec, 3, "minFront");
        this.maxFront.init(this, this.FieldSpec, 3, "maxFront");
        this.priority.init(this, this.FieldSpec, 3, "priority");
        this.source.init(this, this.FieldSpec, 3, "source");
        this.spatialize.init(this, this.FieldSpec, 0, "spatialize");
    }

    public Object clone() {
        return new Sound(this.loader, (SFVec3f)this.direction.clone(), (SFFloat)this.intensity.clone(), (SFVec3f)this.location.clone(), (SFFloat)this.maxBack.clone(), (SFFloat)this.maxFront.clone(), (SFFloat)this.minBack.clone(), (SFFloat)this.minFront.clone(), (SFFloat)this.priority.clone(), (SFNode)this.source.clone(), (SFBool)this.spatialize.clone());
    }

    public String getType() {
        return "Sound";
    }

    void waitSoundReadiness() {
        ContentNegotiator cn = new ContentNegotiator(this);
        Sound returned = (Sound)cn.getContent();
    }

    void updateParent(Node p) {
        if (this.impl.getParent() != null) {
            ((Group)p).addChild((Node)this.impl);
        }
        this.setClip();
    }
}

