/* Copyright (c) 2004, 2022, Oracle and/or its affiliates.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2.0,
   as published by the Free Software Foundation.

   This program is also distributed with certain software (including
   but not limited to OpenSSL) that is licensed under separate terms,
   as designated in a particular file or component or in included license
   documentation.  The authors of MySQL hereby grant you an additional
   permission to link the program and your derivative works with the
   separately licensed software that they have included with MySQL.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License, version 2.0, for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA */
/*
  Do not edit this file, it is automatically generated from:
  </var/lib/pb2/sb_1-6507086-1648075098.5/rpm/BUILD/mysql-cluster-gpl-8.0.29/mysql-cluster-gpl-8.0.29/scripts/mysql_system_tables.sql>
*/
const char* mysql_system_tables[]={
"-- Copyright (c) 2007, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License, version 2.0,\n"
  "-- as published by the Free Software Foundation.\n"
  "--\n"
  "-- This program is also distributed with certain software (including\n"
  "-- but not limited to OpenSSL) that is licensed under separate terms,\n"
  "-- as designated in a particular file or component or in included license\n"
  "-- documentation.  The authors of MySQL hereby grant you an additional\n"
  "-- permission to link the program and your derivative works with the\n"
  "-- separately licensed software that they have included with MySQL.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License, version 2.0, for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- The system tables of MySQL Server\n"
  "--\n"
  "set @have_innodb= (select count(engine) from information_schema.engines where engine='INNODB' and support != 'NO');\n",
"set @is_mysql_encrypted = (select ENCRYPTION from information_schema.INNODB_TABLESPACES where NAME='mysql');\n",
"-- Tables below are NOT treated as DD tables by MySQL server yet.\n"
  "SET FOREIGN_KEY_CHECKS= 1;\n",
"# Added sql_mode elements and making it as SET, instead of ENUM\n"
  "set default_storage_engine=InnoDB;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS db\n"
  "(\n"
  "Host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL,\n"
  "Db char(64) binary DEFAULT '' NOT NULL,\n"
  "User char(32) binary DEFAULT '' NOT NULL,\n"
  "Select_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Insert_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Update_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Delete_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Drop_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Grant_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "References_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Index_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Alter_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_tmp_table_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Lock_tables_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Show_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Alter_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Execute_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Event_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Trigger_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "PRIMARY KEY Host (Host,Db,User), KEY User (User)\n"
  ")\n"
  "engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_bin comment='Database privileges' ROW_FORMAT=DYNAMIC"
  " TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- Remember for later if db table already existed\n"
  "set @had_db_table= @@warning_count != 0;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS user\n"
  "(\n"
  "Host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL,\n"
  "User char(32) binary DEFAULT '' NOT NULL,\n"
  "Select_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Insert_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Update_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Delete_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Drop_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Reload_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Shutdown_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Process_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "File_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Grant_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "References_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Index_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Alter_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Show_db_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Super_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_tmp_table_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Lock_tables_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Execute_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Repl_slave_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Repl_client_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Show_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Alter_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_user_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Event_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Trigger_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_tablespace_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "ssl_type enum('','ANY','X509', 'SPECIFIED') COLLATE utf8_general_ci DEFAULT '' NOT NULL,\n"
  "ssl_cipher BLOB NOT NULL,\n"
  "x509_issuer BLOB NOT NULL,\n"
  "x509_subject BLOB NOT NULL,\n"
  "max_questions int unsigned DEFAULT 0  NOT NULL,\n"
  "max_updates int unsigned DEFAULT 0  NOT NULL,\n"
  "max_connections int unsigned DEFAULT 0  NOT NULL,\n"
  "max_user_connections int unsigned DEFAULT 0  NOT NULL,\n"
  "plugin char(64) DEFAULT 'caching_sha2_password' NOT NULL,\n"
  "authentication_string TEXT,\n"
  "password_expired ENUM('N', 'Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "password_last_changed timestamp NULL DEFAULT NULL,\n"
  "password_lifetime smallint unsigned NULL DEFAULT NULL,\n"
  "account_locked ENUM('N', 'Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_role_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Drop_role_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Password_reuse_history smallint unsigned NULL DEFAULT NULL,\n"
  "Password_reuse_time smallint unsigned NULL DEFAULT NULL,\n"
  "Password_require_current enum('N', 'Y') COLLATE utf8_general_ci DEFAULT NULL,\n"
  "User_attributes JSON DEFAULT NULL,\n"
  "PRIMARY KEY Host (Host,User)\n"
  ") engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_bin comment='Users and global privileges' ROW_FORM"
  "AT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS default_roles\n"
  "(\n"
  "HOST CHAR(255) CHARACTER SET ASCII DEFAULT '' NOT NULL,\n"
  "USER CHAR(32) BINARY DEFAULT '' NOT NULL,\n"
  "DEFAULT_ROLE_HOST CHAR(255) CHARACTER SET ASCII DEFAULT '%' NOT NULL,\n"
  "DEFAULT_ROLE_USER CHAR(32) BINARY DEFAULT '' NOT NULL,\n"
  "PRIMARY KEY (HOST, USER, DEFAULT_ROLE_HOST, DEFAULT_ROLE_USER)\n"
  ") engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_bin comment='Default roles' ROW_FORMAT=DYNAMIC TAB"
  "LESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS role_edges\n"
  "(\n"
  "FROM_HOST CHAR(255) CHARACTER SET ASCII DEFAULT '' NOT NULL,\n"
  "FROM_USER CHAR(32) BINARY DEFAULT '' NOT NULL,\n"
  "TO_HOST CHAR(255) CHARACTER SET ASCII DEFAULT '' NOT NULL,\n"
  "TO_USER CHAR(32) BINARY DEFAULT '' NOT NULL,\n"
  "WITH_ADMIN_OPTION ENUM('N', 'Y') COLLATE UTF8_GENERAL_CI DEFAULT 'N' NOT NULL,\n"
  "PRIMARY KEY (FROM_HOST,FROM_USER,TO_HOST,TO_USER)\n"
  ") engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_bin comment='Role hierarchy and role grants' ROW_F"
  "ORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS global_grants\n"
  "(\n"
  "USER CHAR(32) BINARY DEFAULT '' NOT NULL,\n"
  "HOST CHAR(255) CHARACTER SET ASCII DEFAULT '' NOT NULL,\n"
  "PRIV CHAR(32) COLLATE UTF8_GENERAL_CI DEFAULT '' NOT NULL,\n"
  "WITH_GRANT_OPTION ENUM('N','Y') COLLATE UTF8_GENERAL_CI DEFAULT 'N' NOT NULL,\n"
  "PRIMARY KEY (USER,HOST,PRIV)\n"
  ") engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_bin comment='Extended global grants' ROW_FORMAT=DY"
  "NAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- Remember for later if user table already existed\n"
  "set @had_user_table= @@warning_count != 0;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS password_history\n"
  "(\n"
  "  Host CHAR(255) CHARACTER SET ASCII DEFAULT '' NOT NULL,\n"
  "  User CHAR(32) BINARY DEFAULT '' NOT NULL,\n"
  "  Password_timestamp TIMESTAMP(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),\n"
  "  Password TEXT,\n"
  "  PRIMARY KEY(Host, User, Password_timestamp DESC)\n"
  " ) engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_bin\n"
  " comment='Password history for user accounts' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS func (  name char(64) binary DEFAULT '' NOT NULL, ret tinyint DEFAULT '0' NOT NU"
  "LL, dl char(128) DEFAULT '' NOT NULL, type enum ('function','aggregate') COLLATE utf8_general_ci NOT NULL, PRIMARY KE"
  "Y (name) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_bin   comment='User defined functions' RO"
  "W_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS plugin ( name varchar(64) DEFAULT '' NOT NULL, dl varchar(128) DEFAULT '' NOT NU"
  "LL, PRIMARY KEY (name) ) engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_general_ci comment='MySQL p"
  "lugins' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS help_topic ( help_topic_id int unsigned not null, name char(64) not null, help_c"
  "ategory_id smallint unsigned not null, description text not null, example text not null, url text not null, primary k"
  "ey (help_topic_id), unique index (name) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8 comment='help topics' R"
  "OW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS help_category ( help_category_id smallint unsigned not null, name  char(64) not "
  "null, parent_category_id smallint unsigned null, url text not null, primary key (help_category_id), unique index (nam"
  "e) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8 comment='help categories' ROW_FORMAT=DYNAMIC TABLESPACE=mysq"
  "l\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS help_relation ( help_topic_id int unsigned not null, help_keyword_id  int unsign"
  "ed not null, primary key (help_keyword_id, help_topic_id) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8 comme"
  "nt='keyword-topic relation' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS servers ( Server_name char(64) NOT NULL DEFAULT '', Host char(255) CHARACTER SET"
  " ASCII NOT NULL DEFAULT '', Db char(64) NOT NULL DEFAULT '', Username char(64) NOT NULL DEFAULT '', Password char(64)"
  " NOT NULL DEFAULT '', Port INT NOT NULL DEFAULT '0', Socket char(64) NOT NULL DEFAULT '', Wrapper char(64) NOT NULL D"
  "EFAULT '', Owner char(64) NOT NULL DEFAULT '', PRIMARY KEY (Server_name)) engine=InnoDB STATS_PERSISTENT=0 CHARACTER "
  "SET utf8 comment='MySQL Foreign Servers table' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS tables_priv ( Host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL, Db char(64"
  ") binary DEFAULT '' NOT NULL, User char(32) binary DEFAULT '' NOT NULL, Table_name char(64) binary DEFAULT '' NOT NUL"
  "L, Grantor varchar(288) DEFAULT '' NOT NULL, Timestamp timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT"
  "_TIMESTAMP, Table_priv set('Select','Insert','Update','Delete','Create','Drop','Grant','References','Index','Alter','"
  "Create View','Show view','Trigger') COLLATE utf8_general_ci DEFAULT '' NOT NULL, Column_priv set('Select','Insert','U"
  "pdate','References') COLLATE utf8_general_ci DEFAULT '' NOT NULL, PRIMARY KEY (Host,Db,User,Table_name), KEY Grantor "
  "(Grantor) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8   engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8"
  " COLLATE utf8_bin   comment='Table privileges' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS columns_priv ( Host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL, Db char(6"
  "4) binary DEFAULT '' NOT NULL, User char(32) binary DEFAULT '' NOT NULL, Table_name char(64) binary DEFAULT '' NOT NU"
  "LL, Column_name char(64) binary DEFAULT '' NOT NULL, Timestamp timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE"
  " CURRENT_TIMESTAMP, Column_priv set('Select','Insert','Update','References') COLLATE utf8_general_ci DEFAULT '' NOT N"
  "ULL, PRIMARY KEY (Host,Db,User,Table_name,Column_name) ) engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE "
  "utf8_bin   comment='Column privileges' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS help_keyword (   help_keyword_id  int unsigned not null, name char(64) not null,"
  " primary key (help_keyword_id), unique index (name) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8 comment='he"
  "lp keywords' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS time_zone_name (   Name char(64) NOT NULL, Time_zone_id int unsigned NOT NULL, P"
  "RIMARY KEY Name (Name) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8   comment='Time zone names' ROW_FORMAT=D"
  "YNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS time_zone (   Time_zone_id int unsigned NOT NULL auto_increment, Use_leap_second"
  "s enum('Y','N') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, PRIMARY KEY TzId (Time_zone_id) ) engine=INNODB STATS_P"
  "ERSISTENT=0 CHARACTER SET utf8   comment='Time zones' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS time_zone_transition (   Time_zone_id int unsigned NOT NULL, Transition_time big"
  "int signed NOT NULL, Transition_type_id int unsigned NOT NULL, PRIMARY KEY TzIdTranTime (Time_zone_id, Transition_tim"
  "e) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8   comment='Time zone transitions' ROW_FORMAT=DYNAMIC TABLESP"
  "ACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS time_zone_transition_type (   Time_zone_id int unsigned NOT NULL, Transition_typ"
  "e_id int unsigned NOT NULL, Offset int signed DEFAULT 0 NOT NULL, Is_DST tinyint unsigned DEFAULT 0 NOT NULL, Abbrevi"
  "ation char(8) DEFAULT '' NOT NULL, PRIMARY KEY TzIdTrTId (Time_zone_id, Transition_type_id) ) engine=INNODB STATS_PER"
  "SISTENT=0 CHARACTER SET utf8   comment='Time zone transition types' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS time_zone_leap_second (   Transition_time bigint signed NOT NULL, Correction int"
  " signed NOT NULL, PRIMARY KEY TranTime (Transition_time) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8   comm"
  "ent='Leap seconds information for time zones' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS procs_priv ( Host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL, Db char(64)"
  " binary DEFAULT '' NOT NULL, User char(32) binary DEFAULT '' NOT NULL, Routine_name char(64) COLLATE utf8_general_ci "
  "DEFAULT '' NOT NULL, Routine_type enum('FUNCTION','PROCEDURE') NOT NULL, Grantor varchar(288) DEFAULT '' NOT NULL, Pr"
  "oc_priv set('Execute','Alter Routine','Grant') COLLATE utf8_general_ci DEFAULT '' NOT NULL, Timestamp timestamp NOT N"
  "ULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY (Host,Db,User,Routine_name,Routine_type), KEY "
  "Grantor (Grantor) ) engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_bin   comment='Procedure privile"
  "ges' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- bug#92988: Temporarily turn off sql_require_primary_key for the\n"
  "-- next 2 tables as this is not necessary as they do not replicate.\n"
  "SET @old_sql_require_primary_key = @@session.sql_require_primary_key;\n",
"SET @@session.sql_require_primary_key = 0;\n",
"-- Create general_log\n"
  "CREATE TABLE IF NOT EXISTS general_log (event_time TIMESTAMP(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRE"
  "NT_TIMESTAMP(6), user_host MEDIUMTEXT NOT NULL, thread_id BIGINT UNSIGNED NOT NULL, server_id INTEGER UNSIGNED NOT NU"
  "LL, command_type VARCHAR(64) NOT NULL, argument MEDIUMBLOB NOT NULL) engine=CSV CHARACTER SET utf8 comment=\"General "
  "log\";\n",
"-- Create slow_log\n"
  "CREATE TABLE IF NOT EXISTS slow_log (start_time TIMESTAMP(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_"
  "TIMESTAMP(6), user_host MEDIUMTEXT NOT NULL, query_time TIME(6) NOT NULL, lock_time TIME(6) NOT NULL, rows_sent INTEG"
  "ER NOT NULL, rows_examined INTEGER NOT NULL, db VARCHAR(512) NOT NULL, last_insert_id INTEGER NOT NULL, insert_id INT"
  "EGER NOT NULL, server_id INTEGER UNSIGNED NOT NULL, sql_text MEDIUMBLOB NOT NULL, thread_id BIGINT UNSIGNED NOT NULL)"
  " engine=CSV CHARACTER SET utf8 comment=\"Slow log\";\n",
"SET @@session.sql_require_primary_key = @old_sql_require_primary_key;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS component ( component_id int unsigned NOT NULL AUTO_INCREMENT, component_group_i"
  "d int unsigned NOT NULL, component_urn text NOT NULL, PRIMARY KEY (component_id)) engine=INNODB DEFAULT CHARSET=utf8 "
  "COMMENT 'Components' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"CREATE TABLE IF NOT EXISTS slave_relay_log_info (\n"
  "  Number_of_lines INTEGER UNSIGNED NOT NULL COMMENT 'Number of lines in the file or rows in the table. Used to versio"
  "n table definitions.',\n"
  "  Relay_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the current relay log file.',\n"
  "  Relay_log_pos BIGINT UNSIGNED COMMENT 'The relay log position of the last executed event.',\n"
  "  Master_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the master binary log file from which"
  " the events in the relay log file were read.',\n"
  "  Master_log_pos BIGINT UNSIGNED COMMENT 'The master log position of the last executed event.',\n"
  "  Sql_delay INTEGER COMMENT 'The number of seconds that the slave must lag behind the master.',\n"
  "  Number_of_workers INTEGER UNSIGNED,\n"
  "  Id INTEGER UNSIGNED COMMENT 'Internal Id that uniquely identifies this record.',\n"
  "  Channel_name VARCHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'The channel on which the repl"
  "ica is connected to a source. Used in Multisource Replication',\n"
  "  Privilege_checks_username VARCHAR(32) COLLATE utf8_bin DEFAULT NULL COMMENT 'Username part of PRIVILEGE_CHECKS_USER"
  ".',\n"
  "  Privilege_checks_hostname VARCHAR(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL COMMENT 'Hostname "
  "part of PRIVILEGE_CHECKS_USER.',\n"
  "  Require_row_format BOOLEAN NOT NULL COMMENT 'Indicates whether the channel shall only accept row based events.',\n"
  "  Require_table_primary_key_check ENUM('STREAM','ON','OFF') NOT NULL DEFAULT 'STREAM' COMMENT 'Indicates what is the "
  "channel policy regarding tables having primary keys on create and alter table queries',\n"
  "  Assign_gtids_to_anonymous_transactions_type ENUM('OFF', 'LOCAL', 'UUID')  NOT NULL DEFAULT 'OFF' COMMENT 'Indicates"
  " whether the channel will generate a new GTID for anonymous transactions. OFF means that anonymous transactions will "
  "remain anonymous. LOCAL means that anonymous transactions will be assigned a newly generated GTID based on server_uui"
  "d. UUID indicates that anonymous transactions will be assigned a newly generated GTID based on Assign_gtids_to_anonym"
  "ous_transactions_value',\n"
  "  Assign_gtids_to_anonymous_transactions_value TEXT CHARACTER SET utf8 COLLATE utf8_bin  COMMENT 'Indicates the UUID "
  "used while generating GTIDs for anonymous transactions',\n"
  "  PRIMARY KEY(Channel_name)) DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT 'Relay Log Information'\";\n",
"SET @str=IF(@have_innodb <> 0, CONCAT(@cmd, ' ENGINE= INNODB ROW_FORMAT=DYNAMIC TABLESPACE=mysql ENCRYPTION=\\'', @is_mys"
  "ql_encrypted,'\\''), CONCAT(@cmd, ' ENGINE= MYISAM'));\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd= \"CREATE TABLE IF NOT EXISTS slave_master_info (\n"
  "  Number_of_lines INTEGER UNSIGNED NOT NULL COMMENT 'Number of lines in the file.',\n"
  "  Master_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The name of the master binary log curren"
  "tly being read from the master.',\n"
  "  Master_log_pos BIGINT UNSIGNED NOT NULL COMMENT 'The master log position of the last read event.',\n"
  "  Host VARCHAR(255) CHARACTER SET ASCII COMMENT 'The host name of the source.',\n"
  "  User_name TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The user name used to connect to the master.',\n"
  "  User_password TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The password used to connect to the master.',\n"
  "  Port INTEGER UNSIGNED NOT NULL COMMENT 'The network port used to connect to the master.',\n"
  "  Connect_retry INTEGER UNSIGNED NOT NULL COMMENT 'The period (in seconds) that the slave will wait before trying to "
  "reconnect to the master.',\n"
  "  Enabled_ssl BOOLEAN NOT NULL COMMENT 'Indicates whether the server supports SSL connections.',\n"
  "  Ssl_ca TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The file used for the Certificate Authority (CA) certifica"
  "te.',\n"
  "  Ssl_capath TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The path to the Certificate Authority (CA) certificate"
  "s.',\n"
  "  Ssl_cert TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the SSL certificate file.',\n"
  "  Ssl_cipher TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the cipher in use for the SSL connection.'"
  ",\n"
  "  Ssl_key TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the SSL key file.',\n"
  "  Ssl_verify_server_cert BOOLEAN NOT NULL COMMENT 'Whether to verify the server certificate.',\n"
  "  Heartbeat FLOAT NOT NULL COMMENT '',\n"
  "  Bind TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'Displays which interface is employed when connecting to the "
  "MySQL server',\n"
  "  Ignored_server_ids TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The number of server IDs to be ignored, follow"
  "ed by the actual server IDs',\n"
  "  Uuid TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The master server uuid.',\n"
  "  Retry_count BIGINT UNSIGNED NOT NULL COMMENT 'Number of reconnect attempts, to the master, before giving up.',\n"
  "  Ssl_crl TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The file used for the Certificate Revocation List (CRL)',"
  "\n"
  "  Ssl_crlpath TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The path used for Certificate Revocation List (CRL) f"
  "iles',\n"
  "  Enabled_auto_position BOOLEAN NOT NULL COMMENT 'Indicates whether GTIDs will be used to retrieve events from the ma"
  "ster.',\n"
  "  Channel_name VARCHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'The channel on which the repl"
  "ica is connected to a source. Used in Multisource Replication',\n"
  "  Tls_version TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'Tls version',\n"
  "  Public_key_path TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The file containing public key of master server.'"
  ",\n"
  "  Get_public_key BOOLEAN NOT NULL COMMENT 'Preference to get public key from master.',\n"
  "  Network_namespace TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'Network namespace used for communication with t"
  "he master server.',\n"
  "  Master_compression_algorithm VARCHAR(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'Compression algorith"
  "m supported for data transfer between source and replica.',\n"
  "  Master_zstd_compression_level INTEGER UNSIGNED NOT NULL COMMENT 'Compression level associated with zstd compression"
  " algorithm.',\n"
  "  Tls_ciphersuites TEXT CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT 'Ciphersuites used for TLS 1.3 commu"
  "nication with the master server.',\n"
  "  Source_connection_auto_failover BOOLEAN NOT NULL DEFAULT FALSE COMMENT 'Indicates whether the channel connection fa"
  "ilover is enabled.',\n"
  "  Gtid_only BOOLEAN NOT NULL DEFAULT FALSE COMMENT 'Indicates if this channel only uses GTIDs and does not persist po"
  "sitions.',\n"
  "  PRIMARY KEY(Channel_name)) DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT 'Master Information'\";\n",
"SET @str=IF(@have_innodb <> 0, CONCAT(@cmd, ' ENGINE= INNODB ROW_FORMAT=DYNAMIC TABLESPACE=mysql ENCRYPTION=\\'', @is_mys"
  "ql_encrypted,'\\''), CONCAT(@cmd, ' ENGINE= MYISAM'));\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd= \"CREATE TABLE IF NOT EXISTS slave_worker_info (\n"
  "  Id INTEGER UNSIGNED NOT NULL,\n"
  "  Relay_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,\n"
  "  Relay_log_pos BIGINT UNSIGNED NOT NULL,\n"
  "  Master_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,\n"
  "  Master_log_pos BIGINT UNSIGNED NOT NULL,\n"
  "  Checkpoint_relay_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,\n"
  "  Checkpoint_relay_log_pos BIGINT UNSIGNED NOT NULL,\n"
  "  Checkpoint_master_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,\n"
  "  Checkpoint_master_log_pos BIGINT UNSIGNED NOT NULL,\n"
  "  Checkpoint_seqno INT UNSIGNED NOT NULL,\n"
  "  Checkpoint_group_size INTEGER UNSIGNED NOT NULL,\n"
  "  Checkpoint_group_bitmap BLOB NOT NULL,\n"
  "  Channel_name VARCHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'The channel on which the repl"
  "ica is connected to a source. Used in Multisource Replication',\n"
  "  PRIMARY KEY(Channel_name, Id)) DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT 'Worker Information'\";\n",
"SET @str=IF(@have_innodb <> 0, CONCAT(@cmd, ' ENGINE= INNODB ROW_FORMAT=DYNAMIC TABLESPACE=mysql ENCRYPTION=\\'', @is_mys"
  "ql_encrypted,'\\''), CONCAT(@cmd, ' ENGINE= MYISAM'));\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd= \"CREATE TABLE IF NOT EXISTS gtid_executed (\n"
  "    source_uuid CHAR(36) NOT NULL COMMENT 'uuid of the source where the transaction was originally executed.',\n"
  "    interval_start BIGINT NOT NULL COMMENT 'First number of interval.',\n"
  "    interval_end BIGINT NOT NULL COMMENT 'Last number of interval.',\n"
  "    PRIMARY KEY(source_uuid, interval_start)) STATS_PERSISTENT=0\";\n",
"SET @str=IF(@have_innodb <> 0, CONCAT(@cmd, ' ENGINE= INNODB ROW_FORMAT=DYNAMIC TABLESPACE=mysql ENCRYPTION=\\'', @is_mys"
  "ql_encrypted,'\\''), CONCAT(@cmd, ' ENGINE= MYISAM'));\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- replication_asynchronous_connection_failover table\n"
  "SET @cmd= \"CREATE TABLE IF NOT EXISTS replication_asynchronous_connection_failover (\n"
  "    Channel_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'The replication channel name t"
  "hat connects source and replica.',\n"
  "    Host CHAR(255) CHARACTER SET ASCII NOT NULL COMMENT 'The source hostname that the replica will attempt to switch "
  "over the replication connection to in case of a failure.',\n"
  "    Port INTEGER UNSIGNED NOT NULL COMMENT 'The source port that the replica will attempt to switch over the replicat"
  "ion connection to in case of a failure.',\n"
  "    Network_namespace CHAR(64) COMMENT 'The source network namespace that the replica will attempt to switch over the"
  " replication connection to in case of a failure. If its value is empty, connections use the default (global) namespac"
  "e.',\n"
  "    Weight TINYINT UNSIGNED NOT NULL COMMENT 'The order in which the replica shall try to switch the connection over "
  "to when there are failures. Weight can be set to a number between 1 and 100, where 100 is the highest weight and 1 th"
  "e lowest.',\n"
  "    Managed_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'The name of the gro"
  "up which this server belongs to.',\n"
  "    PRIMARY KEY(Channel_name, Host, Port, Network_namespace, Managed_name), KEY(Channel_name, Managed_name)) DEFAULT "
  "CHARSET=utf8 STATS_PERSISTENT=0 COMMENT 'The source configuration details'\";\n",
"SET @str=IF(@have_innodb <> 0, CONCAT(@cmd, ' ENGINE= INNODB ROW_FORMAT=DYNAMIC TABLESPACE=mysql ENCRYPTION=\\'', @is_mys"
  "ql_encrypted,'\\''), CONCAT(@cmd, ' ENGINE= MYISAM'));\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- replication_asynchronous_connection_failover_managed table\n"
  "SET @cmd= \"CREATE TABLE IF NOT EXISTS replication_asynchronous_connection_failover_managed (\n"
  "    Channel_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'The replication channel name t"
  "hat connects source and replica.',\n"
  "    Managed_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'The name of the sou"
  "rce which needs to be managed.',\n"
  "    Managed_type CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'Determines the mana"
  "ged type.',\n"
  "    Configuration JSON DEFAULT NULL COMMENT 'The data to help manage group. For Managed_type = GroupReplication, Conf"
  "iguration value should contain {\\\"Primary_weight\\\": 80, \\\"Secondary_weight\\\": 60}, so that it assigns weight=80 t"
  "o PRIMARY of the group, and weight=60 for rest of the members in mysql.replication_asynchronous_connection_failover t"
  "able.',\n"
  "    PRIMARY KEY(Channel_name, Managed_name)) DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT 'The managed source conf"
  "iguration details'\";\n",
"SET @str=IF(@have_innodb <> 0, CONCAT(@cmd, ' ENGINE= INNODB ROW_FORMAT=DYNAMIC TABLESPACE=mysql ENCRYPTION=\\'', @is_mys"
  "ql_encrypted,'\\''), CONCAT(@cmd, ' ENGINE= MYISAM'));\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- replication_group_member_actions\n"
  "SET @cmd= \"CREATE TABLE IF NOT EXISTS replication_group_member_actions (\n"
  "    name CHAR(255) CHARACTER SET ASCII NOT NULL COMMENT 'The action name.',\n"
  "    event CHAR(64) CHARACTER SET ASCII NOT NULL COMMENT 'The event that will trigger the action.',\n"
  "    enabled BOOLEAN NOT NULL COMMENT 'Whether the action is enabled.',\n"
  "    type CHAR(64) CHARACTER SET ASCII NOT NULL COMMENT 'The action type.',\n"
  "    priority TINYINT UNSIGNED NOT NULL COMMENT 'The order on which the action will be run, value between 1 and 100, l"
  "ower values first.',\n"
  "    error_handling CHAR(64) CHARACTER SET ASCII NOT NULL COMMENT 'On errors during the action will be handled: IGNORE"
  ", CRITICAL.',\n"
  "    PRIMARY KEY(name, event), KEY(event)) DEFAULT CHARSET=utf8mb4 STATS_PERSISTENT=0 COMMENT 'The member actions conf"
  "iguration.'\";\n",
"SET @str=IF(@have_innodb <> 0, CONCAT(@cmd, ' ENGINE= INNODB ROW_FORMAT=DYNAMIC TABLESPACE=mysql ENCRYPTION=\\'', @is_mys"
  "ql_encrypted,'\\''), CONCAT(@cmd, ' ENGINE= MYISAM'));\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- replication_group_configuration_version\n"
  "SET @cmd= \"CREATE TABLE IF NOT EXISTS replication_group_configuration_version (\n"
  "    name CHAR(255) CHARACTER SET ASCII NOT NULL COMMENT 'The configuration name.',\n"
  "    version BIGINT UNSIGNED NOT NULL COMMENT 'The version of the configuration name.',\n"
  "    PRIMARY KEY(name)) DEFAULT CHARSET=utf8mb4 STATS_PERSISTENT=0 COMMENT 'The group configuration version.'\";\n",
"SET @str=IF(@have_innodb <> 0, CONCAT(@cmd, ' ENGINE= INNODB ROW_FORMAT=DYNAMIC TABLESPACE=mysql ENCRYPTION=\\'', @is_mys"
  "ql_encrypted,'\\''), CONCAT(@cmd, ' ENGINE= MYISAM'));\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"--\n"
  "-- Optimizer Cost Model configuration\n"
  "-- (Note: Column definition for default_value needs to be updated when a\n"
  "--        default value is changed).\n"
  "--\n"
  "-- Server cost constants\n"
  "SET @cmd = \"CREATE TABLE IF NOT EXISTS server_cost (\n"
  "  cost_name   VARCHAR(64) NOT NULL,\n"
  "  cost_value  FLOAT DEFAULT NULL,\n"
  "  last_update TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n"
  "  comment     VARCHAR(1024) DEFAULT NULL,\n"
  "  default_value FLOAT GENERATED ALWAYS AS\n"
  "    (CASE cost_name\n"
  "       WHEN 'disk_temptable_create_cost' THEN 20.0\n"
  "       WHEN 'disk_temptable_row_cost' THEN 0.5\n"
  "       WHEN 'key_compare_cost' THEN 0.05\n"
  "       WHEN 'memory_temptable_create_cost' THEN 1.0\n"
  "       WHEN 'memory_temptable_row_cost' THEN 0.1\n"
  "       WHEN 'row_evaluate_cost' THEN 0.1\n"
  "       ELSE NULL\n"
  "     END) VIRTUAL,\n"
  "  PRIMARY KEY (cost_name)\n"
  ") ENGINE=InnoDB CHARACTER SET=utf8 COLLATE=utf8_general_ci STATS_PERSISTENT=0 ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"INSERT IGNORE INTO server_cost(cost_name) VALUES\n"
  "  (\"row_evaluate_cost\"), (\"key_compare_cost\"),\n"
  "  (\"memory_temptable_create_cost\"), (\"memory_temptable_row_cost\"),\n"
  "  (\"disk_temptable_create_cost\"), (\"disk_temptable_row_cost\");\n",
"-- Engine cost constants\n"
  "SET @cmd = \"CREATE TABLE IF NOT EXISTS engine_cost (\n"
  "  engine_name VARCHAR(64) NOT NULL,\n"
  "  device_type INTEGER NOT NULL,\n"
  "  cost_name   VARCHAR(64) NOT NULL,\n"
  "  cost_value  FLOAT DEFAULT NULL,\n"
  "  last_update TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n"
  "  comment     VARCHAR(1024) DEFAULT NULL,\n"
  "  default_value FLOAT GENERATED ALWAYS AS\n"
  "    (CASE cost_name\n"
  "       WHEN 'io_block_read_cost' THEN 1.0\n"
  "       WHEN 'memory_block_read_cost' THEN 0.25\n"
  "       ELSE NULL\n"
  "     END) VIRTUAL,\n"
  "  PRIMARY KEY (cost_name, engine_name, device_type)\n"
  ") ENGINE=InnoDB CHARACTER SET=utf8 COLLATE=utf8_general_ci STATS_PERSISTENT=0 ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"INSERT IGNORE INTO engine_cost(engine_name, device_type, cost_name) VALUES\n"
  "  (\"default\", 0, \"memory_block_read_cost\"),\n"
  "  (\"default\", 0, \"io_block_read_cost\");\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS proxies_priv (Host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL, User char("
  "32) binary DEFAULT '' NOT NULL, Proxied_host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL, Proxied_user char(32)"
  " binary DEFAULT '' NOT NULL, With_grant BOOL DEFAULT 0 NOT NULL, Grantor varchar(288) DEFAULT '' NOT NULL, Timestamp "
  "timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY Host (Host,User,Proxied_host,Pr"
  "oxied_user), KEY Grantor (Grantor) ) engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_bin comment='Us"
  "er proxy privileges' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- Remember for later if proxies_priv table already existed\n"
  "set @had_proxies_priv_table= @@warning_count != 0;\n",
"--\n"
  "-- Only create the ndb_binlog_index table if the server is built with ndb.\n"
  "-- Create this table last among the tables in the mysql schema to make it\n"
  "-- easier to keep tests agnostic wrt. the existence of this table.\n"
  "--\n"
  "SET @have_ndb= (select count(engine) from information_schema.engines where engine='ndbcluster');\n",
"SET @cmd=\"CREATE TABLE IF NOT EXISTS ndb_binlog_index (\n"
  "  Position BIGINT UNSIGNED NOT NULL,\n"
  "  File VARCHAR(255) NOT NULL,\n"
  "  epoch BIGINT UNSIGNED NOT NULL,\n"
  "  inserts INT UNSIGNED NOT NULL,\n"
  "  updates INT UNSIGNED NOT NULL,\n"
  "  deletes INT UNSIGNED NOT NULL,\n"
  "  schemaops INT UNSIGNED NOT NULL,\n"
  "  orig_server_id INT UNSIGNED NOT NULL,\n"
  "  orig_epoch BIGINT UNSIGNED NOT NULL,\n"
  "  gci INT UNSIGNED NOT NULL,\n"
  "  next_position BIGINT UNSIGNED NOT NULL,\n"
  "  next_file VARCHAR(255) NOT NULL,\n"
  "  PRIMARY KEY(epoch, orig_server_id, orig_epoch)\n"
  "  ) ENGINE=INNODB CHARACTER SET latin1 STATS_PERSISTENT=0 ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"SET @str = IF(@have_ndb = 1, @str, 'SET @dummy = 0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
NULL
};
