/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.IClasspathEntry;
import org.aspectj.org.eclipse.jdt.core.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.internal.core.ClasspathEntry;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.JavaProject;
import org.aspectj.org.eclipse.jdt.internal.core.NameLookup;
import org.aspectj.org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragment;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.util.HashtableOfArrayToObject;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

class JavaProjectElementInfo
extends OpenableElementInfo {
    private Object[] nonJavaResources = null;
    ProjectCache projectCache;

    private Object[] computeNonJavaResources(JavaProject project) {
        IPath projectPath = project.getProject().getFullPath();
        boolean srcIsProject = false;
        boolean binIsProject = false;
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = null;
        IClasspathEntry[] classpath = null;
        IPath projectOutput = null;
        try {
            classpath = project.getResolvedClasspath(true, false, false);
            int i = 0;
            while (i < classpath.length) {
                IClasspathEntry entry = classpath[i];
                if (projectPath.equals(entry.getPath())) {
                    srcIsProject = true;
                    inclusionPatterns = ((ClasspathEntry)entry).fullInclusionPatternChars();
                    exclusionPatterns = ((ClasspathEntry)entry).fullExclusionPatternChars();
                    break;
                }
                ++i;
            }
            projectOutput = project.getOutputLocation();
            binIsProject = projectPath.equals(projectOutput);
        }
        catch (JavaModelException i) {
            // empty catch block
        }
        Object[] resources = new IResource[5];
        int resourcesCounter = 0;
        try {
            IResource[] members = ((IContainer)project.getResource()).members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource res = members[i];
                switch (res.getType()) {
                    case 1: {
                        IPath resFullPath = res.getFullPath();
                        String resName = res.getName();
                        if (org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(resName) && this.isClasspathEntryOrOutputLocation(resFullPath, classpath, projectOutput) || srcIsProject && Util.isValidCompilationUnitName(resName) && !Util.isExcluded(res, inclusionPatterns, exclusionPatterns) || binIsProject && Util.isValidClassFileName(resName)) break;
                        if (resources.length == resourcesCounter) {
                            Object[] objectArray = resources;
                            resources = new IResource[resourcesCounter * 2];
                            System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
                        }
                        resources[resourcesCounter++] = res;
                        break;
                    }
                    case 2: {
                        IPath resFullPath = res.getFullPath();
                        if (srcIsProject && !Util.isExcluded(res, inclusionPatterns, exclusionPatterns) && Util.isValidFolderNameForPackage(res.getName()) || this.isClasspathEntryOrOutputLocation(resFullPath, classpath, projectOutput)) break;
                        if (resources.length == resourcesCounter) {
                            Object[] objectArray = resources;
                            resources = new IResource[resourcesCounter * 2];
                            System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
                        }
                        resources[resourcesCounter++] = res;
                    }
                }
                ++i;
            }
            if (resources.length != resourcesCounter) {
                Object[] objectArray = resources;
                resources = new IResource[resourcesCounter];
                System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
            }
        }
        catch (CoreException e) {
            resources = JavaElementInfo.NO_NON_JAVA_RESOURCES;
            resourcesCounter = 0;
        }
        return resources;
    }

    ProjectCache getProjectCache(JavaProject project) {
        ProjectCache cache = this.projectCache;
        if (cache == null) {
            IPackageFragmentRoot[] roots;
            HashMap reverseMap = new HashMap(3);
            try {
                roots = project.getAllPackageFragmentRoots(reverseMap);
            }
            catch (JavaModelException e) {
                roots = new IPackageFragmentRoot[]{};
                reverseMap.clear();
            }
            HashtableOfArrayToObject fragmentsCache = new HashtableOfArrayToObject();
            int i = 0;
            int length = roots.length;
            while (i < length) {
                block11: {
                    IPackageFragmentRoot root = roots[i];
                    IJavaElement[] frags = null;
                    try {
                        frags = root.getChildren();
                    }
                    catch (JavaModelException e) {
                        break block11;
                    }
                    int j = 0;
                    int length2 = frags.length;
                    while (j < length2) {
                        PackageFragment fragment = (PackageFragment)frags[j];
                        Object[] pkgName = fragment.names;
                        Object existing = fragmentsCache.get(pkgName);
                        if (existing == null) {
                            fragmentsCache.put(pkgName, root);
                        } else if (existing instanceof PackageFragmentRoot) {
                            fragmentsCache.put(pkgName, new IPackageFragmentRoot[]{(PackageFragmentRoot)existing, root});
                        } else {
                            IPackageFragmentRoot[] entry = (IPackageFragmentRoot[])existing;
                            IPackageFragmentRoot[] copy = new IPackageFragmentRoot[entry.length + 1];
                            System.arraycopy(entry, 0, copy, 0, entry.length);
                            copy[entry.length] = root;
                            fragmentsCache.put(pkgName, copy);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.projectCache = cache = new ProjectCache(roots, fragmentsCache, reverseMap);
        }
        return cache;
    }

    Object[] getNonJavaResources(JavaProject project) {
        if (this.nonJavaResources == null) {
            this.nonJavaResources = this.computeNonJavaResources(project);
        }
        return this.nonJavaResources;
    }

    private boolean isClasspathEntryOrOutputLocation(IPath path, IClasspathEntry[] resolvedClasspath, IPath projectOutput) {
        if (projectOutput.equals(path)) {
            return true;
        }
        int i = 0;
        int length = resolvedClasspath.length;
        while (i < length) {
            IClasspathEntry entry = resolvedClasspath[i];
            if (entry.getPath().equals(path)) {
                return true;
            }
            IPath output = entry.getOutputLocation();
            if (output != null && output.equals(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    NameLookup newNameLookup(JavaProject project, ICompilationUnit[] workingCopies) {
        ProjectCache cache = this.getProjectCache(project);
        return new NameLookup(cache.allPkgFragmentRootsCache, cache.allPkgFragmentsCache, workingCopies, cache.pathToResolvedEntries);
    }

    void resetCaches() {
        this.projectCache = null;
    }

    void setNonJavaResources(Object[] resources) {
        this.nonJavaResources = resources;
    }

    static class ProjectCache {
        public IPackageFragmentRoot[] allPkgFragmentRootsCache;
        public HashtableOfArrayToObject allPkgFragmentsCache;
        public Map pathToResolvedEntries;

        ProjectCache(IPackageFragmentRoot[] allPkgFragmentRootsCache, HashtableOfArrayToObject allPkgFragmentsCache, Map pathToResolvedEntries) {
            this.allPkgFragmentRootsCache = allPkgFragmentRootsCache;
            this.allPkgFragmentsCache = allPkgFragmentsCache;
            this.pathToResolvedEntries = pathToResolvedEntries;
        }
    }
}

