/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.Files;
import com.mysql.management.util.QuietTestCase;
import com.mysql.management.util.RuntimeI;
import com.mysql.management.util.Shell;
import com.mysql.management.util.ShellTest;
import com.mysql.management.util.TestStubProcess;
import com.mysql.management.util.TestUtil;
import com.mysql.management.util.Threads;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;

public class ShellTest
extends QuietTestCase {
    private Shell.Default shell;
    private int shellName = 0;
    private TestProcess testProcess;
    private int processSleep = 0;
    static /* synthetic */ Class class$0;

    protected void setUp() {
        super.setUp();
        this.processSleep = 0;
        String[] commandLineArgs = new String[]{"java"};
        String threadName = "ShellTest" + this.shellName++;
        this.shell = new Shell.Default(commandLineArgs, threadName, System.out, System.err);
        this.setRuntime(0);
    }

    private void setRuntime(final int returnCode) {
        RuntimeI.Stub fakeRuntime = new RuntimeI.Stub(){

            public Process exec(String[] cmdarray, String[] envp, File dir) {
                ShellTest.assertNotNull((Object)cmdarray);
                ShellTest.assertNull((Object)envp);
                ShellTest.assertNull((Object)dir);
                ShellTest.this.testProcess = new TestProcess(returnCode, ShellTest.this.processSleep);
                return ShellTest.this.testProcess;
            }
        };
        this.shell.setRuntime(fakeRuntime);
    }

    public void testCompletionListener() {
        IllegalArgumentException expected = null;
        try {
            this.shell.addCompletionListener(null);
        }
        catch (IllegalArgumentException e) {
            expected = e;
        }
        ShellTest.assertNotNull((Object)expected);
        class TestListener
        implements Runnable {
            int timesRun;
            final /* synthetic */ ShellTest this$0;

            TestListener(ShellTest shellTest) {
                this.this$0 = shellTest;
                this.timesRun = 0;
            }

            public void run() {
                ++this.timesRun;
            }
        }
        TestListener listener = new TestListener(this);
        this.shell.addCompletionListener(listener);
        this.shell.run();
        int c = 0;
        while (c < 5 && listener.timesRun == 0) {
            new Threads().pause(10);
            ++c;
        }
        ShellTest.assertEquals((int)1, (int)listener.timesRun);
    }

    public void testShellReturnsWithReturnCode() {
        int returnCode = 7;
        this.setRuntime(returnCode);
        this.shell.run();
        ShellTest.assertTrue((boolean)this.shell.hasReturned());
        ShellTest.assertEquals((int)returnCode, (int)this.shell.returnCode());
    }

    public void testSetters() {
        this.shell.setRuntime(new RuntimeI.Default());
        this.shell.setEnvironment(new String[0]);
        this.shell.setWorkingDir(new Files().testDir());
        this.shell.run();
        ShellTest.assertTrue((boolean)this.shell.hasReturned());
        int rv = this.shell.returnCode();
        ShellTest.assertEquals((String)("" + rv), (boolean)true, (rv == 1 || rv == 0 ? 1 : 0) != 0);
    }

    public void testDoubleRun() {
        this.processSleep = 2000;
        this.shell.start();
        new Threads().pause(20);
        IllegalStateException expected = null;
        try {
            this.shell.run();
        }
        catch (IllegalStateException e) {
            expected = e;
        }
        ShellTest.assertNotNull((Object)expected);
    }

    public void testShellThrowsIfNotYetReturned() {
        ShellTest.assertFalse((boolean)this.shell.hasReturned());
        Exception expected = null;
        try {
            this.shell.returnCode();
        }
        catch (Exception e) {
            expected = e;
        }
        ShellTest.assertNotNull((String)"Should have throws", (Object)expected);
    }

    public void testDestroy() throws Exception {
        this.processSleep = 2000;
        ShellTest.assertNull((Object)this.testProcess);
        this.shell.start();
        new Threads().pause(20);
        this.shell.destroyProcess();
        ShellTest.assertEquals((int)1, (int)this.testProcess.destroyCalled);
    }

    public void testForThrownExceptions() throws Exception {
        this.shell = new Shell.Default(null, "foo", null, null);
        Exception expected = null;
        try {
            this.shell.run();
        }
        catch (Exception e) {
            expected = e;
        }
        ShellTest.assertNotNull((Object)expected);
    }

    public void testStub() throws Exception {
        TestUtil testUtil = new TestUtil();
        Shell.Stub stub = new Shell.Stub();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mysql.management.util.Shell");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        testUtil.assertObjStubsInterface(stub, clazz);
    }

    public static class TestProcess
    extends TestStubProcess {
        private int returnCode;
        int destroyCalled;
        int sleep;

        public TestProcess(int returnCode, int sleep) {
            this.returnCode = returnCode;
            this.destroyCalled = 0;
            this.sleep = sleep;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(new byte[0]);
        }

        public InputStream getErrorStream() {
            return new ByteArrayInputStream(new byte[0]);
        }

        public int waitFor() {
            new Threads().pause(this.sleep);
            return this.returnCode;
        }

        public void destroy() {
            ++this.destroyCalled;
        }
    }
}

