/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.Exceptions;
import com.mysql.management.util.NotImplementedException;
import com.mysql.management.util.RuntimeI;
import com.mysql.management.util.StreamConnector;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public interface Shell
extends Runnable {
    public void setEnvironment(String[] var1);

    public void setWorkingDir(File var1);

    public void addCompletionListener(Runnable var1);

    public int returnCode();

    public boolean hasReturned();

    public void destroyProcess();

    public String getName();

    public boolean isAlive();

    public boolean isDaemon();

    public void setDaemon(boolean var1);

    public void join();

    public void start();

    public static class Factory {
        public Shell newShell(String[] args, String name, PrintStream out, PrintStream err) {
            return new Default(args, name, out, err);
        }
    }

    public static final class Default
    implements Shell {
        private Thread me;
        private String[] args;
        private String[] envp;
        private File workingDir;
        private PrintStream out;
        private PrintStream err;
        private Integer returnCode;
        private Process p;
        private List listeners;
        private Exceptions exceptions;
        private RuntimeI runtime;

        public Default(String[] args, String name, PrintStream out, PrintStream err) {
            this.me = new Thread((Runnable)this, name);
            this.args = args;
            this.out = out;
            this.err = err;
            this.envp = null;
            this.workingDir = null;
            this.returnCode = null;
            this.listeners = new ArrayList();
            this.exceptions = new Exceptions();
            this.runtime = new RuntimeI.Default();
        }

        public void setEnvironment(String[] envp) {
            this.envp = envp;
        }

        public void setWorkingDir(File workingDir) {
            this.workingDir = workingDir;
        }

        void setRuntime(RuntimeI runtime) {
            this.runtime = runtime;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (this.p != null) {
                throw new IllegalStateException("Process already running");
            }
            try {
                try {
                    this.returnCode = null;
                    this.p = this.runtime.exec(this.args, this.envp, this.workingDir);
                    this.captureStdOutAndStdErr();
                    this.returnCode = new Integer(this.p.waitFor());
                    ** GOTO lbl-1000
                }
                catch (Exception e) {
                    throw this.exceptions.toRuntime(e);
                }
            }
            catch (Throwable var3_2) {
                var2_3 = null;
                this.p = null;
                i = 0;
            }
            while (true) {
                if (i >= this.listeners.size()) {
                    this.listeners.clear();
                    throw var3_2;
                }
                new Thread((Runnable)this.listeners.get(i)).start();
                ++i;
            }
lbl-1000:
            // 1 sources

            {
                var2_4 = null;
                this.p = null;
                i = 0;
            }
            while (true) {
                if (i >= this.listeners.size()) {
                    this.listeners.clear();
                    return;
                }
                new Thread((Runnable)this.listeners.get(i)).start();
                ++i;
            }
        }

        private void captureStdOutAndStdErr() {
            InputStream pOut = this.p.getInputStream();
            InputStream pErr = this.p.getErrorStream();
            new StreamConnector(pOut, this.out, String.valueOf(this.getName()) + " std out").start();
            new StreamConnector(pErr, this.err, String.valueOf(this.getName()) + " std err").start();
        }

        public void addCompletionListener(Runnable listener) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener is null");
            }
            this.listeners.add(listener);
        }

        public int returnCode() {
            if (!this.hasReturned()) {
                throw new RuntimeException("Process hasn't returned yet");
            }
            return this.returnCode;
        }

        public boolean hasReturned() {
            return this.returnCode != null;
        }

        public void destroyProcess() {
            if (this.p != null) {
                this.p.destroy();
            }
        }

        public String getName() {
            return this.me.getName();
        }

        public boolean isAlive() {
            return this.me.isAlive();
        }

        public boolean isDaemon() {
            return this.me.isDaemon();
        }

        public void setDaemon(boolean val) {
            this.me.setDaemon(val);
        }

        public void join() {
            new Exceptions.VoidBlock(this){
                final /* synthetic */ Default this$1;
                {
                    this.this$1 = default_;
                }

                protected void inner() throws InterruptedException {
                    Default.access$0(this.this$1).join();
                }
            }.exec();
        }

        public void start() {
            this.me.start();
        }

        static /* synthetic */ Thread access$0(Default default_) {
            return default_.me;
        }
    }

    public static class Stub
    implements Shell {
        public void addCompletionListener(Runnable listener) {
            throw new NotImplementedException(listener);
        }

        public void destroyProcess() {
            throw new NotImplementedException();
        }

        public String getName() {
            throw new NotImplementedException();
        }

        public boolean hasReturned() {
            throw new NotImplementedException();
        }

        public boolean isAlive() {
            throw new NotImplementedException();
        }

        public boolean isDaemon() {
            throw new NotImplementedException();
        }

        public void join() {
            throw new NotImplementedException();
        }

        public int returnCode() {
            throw new NotImplementedException();
        }

        public void run() {
            throw new NotImplementedException();
        }

        public void setDaemon(boolean val) {
            throw new NotImplementedException(new Boolean(val));
        }

        public void setEnvironment(String[] envp) {
            throw new NotImplementedException(envp);
        }

        public void setWorkingDir(File workingDir) {
            throw new NotImplementedException(workingDir);
        }

        public void start() {
            throw new NotImplementedException();
        }
    }
}

