.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XAllocIconSize __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XAllocIconSize, XSetIconSizes, XGetIconSizes, XIconSize \- allocate icon size structure and set or read a window's WM_ICON_SIZES property
.SH SYNTAX
XIconSize *XAllocIconSize\^(void\^);
.LP
int XSetIconSizes\^(\^Display *\fIdisplay\fP, Window \fIw\fP, XIconSize
*\fIsize_list\fP, int \fIcount\fP\^);
.LP
Status XGetIconSizes\^(\^Display *\fIdisplay\fP, Window \fIw\fP, XIconSize
**\fIsize_list_return\fP, int \fIcount_return\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIcount\fP 1i
Specifies the number of items in the size list.
.IP \fIcount_return\fP 1i
Returns the number of items in the size list.
.IP \fIsize_list\fP 1i
Specifies the size list.
.IP \fIsize_list_return\fP 1i
Returns the size list.
.IP \fIw\fP 1i
Specifies the window.
.SH DESCRIPTION
The
.B XAllocIconSize
function allocates and returns a pointer to a
.B XIconSize
structure.
Note that all fields in the
.B XIconSize
structure are initially set to zero.
If insufficient memory is available,
.B XAllocIconSize
returns NULL.
To free the memory allocated to this structure,
use
.BR XFree .
.LP
The
.B XSetIconSizes
function is used only by window managers to set the supported icon sizes.
.LP
.B XSetIconSizes
can generate
.B BadAlloc
and
.B BadWindow
errors.
.LP
The
.B XGetIconSizes
function returns zero if a window manager has not set icon sizes;
otherwise, it return nonzero.
.B XGetIconSizes
should be called by an application that
wants to find out what icon sizes would be most appreciated by the
window manager under which the application is running.
The application
should then use
.B XSetWMHints
to supply the window manager with an icon pixmap or window in one of the
supported sizes.
To free the data allocated in size_list_return, use
.BR XFree .
.LP
.B XGetIconSizes
can generate a
.B BadWindow
error.
.SH PROPERTIES
.TP 1i
\s-1WM_ICON_SIZES\s+1
The window manager may set this property on the root window to
specify the icon sizes it supports.
The C type of this property is
.BR XIconSize .
.SH STRUCTURES
The
.B XIconSize
structure contains:
.LP
.IN "XIconSize" "" "@DEF@"
.EX
typedef struct {
        int min_width, min_height;
        int max_width, max_height;
        int width_inc, height_inc;
} XIconSize;
.EE
.LP
The width_inc and height_inc members define an arithmetic progression of
sizes (minimum to maximum) that represent the supported icon sizes.
.SH DIAGNOSTICS
.TP 1i
.B BadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.B BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XAllocClassHint(__libmansuffix__),
XAllocSizeHints(__libmansuffix__),
XAllocWMHints(__libmansuffix__),
XFree(__libmansuffix__),
XSetCommand(__libmansuffix__),
XSetTransientForHint(__libmansuffix__),
XSetTextProperty(__libmansuffix__),
XSetWMClientMachine(__libmansuffix__),
XSetWMColormapWindows(__libmansuffix__),
XSetWMIconName(__libmansuffix__),
XSetWMName(__libmansuffix__),
XSetWMProperties(__libmansuffix__),
XSetWMProtocols(__libmansuffix__),
XStringListToTextProperty(__libmansuffix__)
.br
\fI\*(xL\fP
