import QtQuick 2.15
import QtQuick3D 1.15

Node {
    id: rootNode

    Model {
        id: tire_front_left
        x: -322.882
        y: 132.8
        z: -521.514
        eulerRotation.x: -90
        source: "meshes/tire_front_left.mesh"

        DefaultMaterial {
            id: tire_material
            diffuseColor: "#ff000000"
            opacity: 0
        }
        materials: [
            tire_material
        ]
    }

    Model {
        id: door_front_left
        x: -348.529
        y: 287.392
        z: -343.59
        eulerRotation.x: -90
        source: "meshes/door_front_left.mesh"

        DefaultMaterial {
            id: material_004_material
            diffuseColor: "#ffa3a3a3"
        }

        DefaultMaterial {
            id: d_glass_material
            diffuseColor: "#ff000000"
            opacity: 0.55
        }
        materials: [
            material_004_material,
            d_glass_material
        ]
    }

    Model {
        id: hood
        x: 7.45058e-07
        y: 406.42
        z: -488.062
        eulerRotation.x: -90
        source: "meshes/hood.mesh"

        DefaultMaterial {
            id: body_material
            diffuseColor: "#ff070e10"
        }
        materials: [
            body_material
        ]
    }

    Model {
        id: body
        x: 8.76279
        y: 270.72
        z: -828.201
        eulerRotation.x: -90
        source: "meshes/body.mesh"

        DefaultMaterial {
            id: glass_tex2_material
            diffuseColor: "#ffcccccc"
        }
        materials: [
            body_material,
            glass_tex2_material,
            d_glass_material
        ]
    }

    Model {
        id: trunk
        x: -1.49012e-06
        y: 564.022
        z: 493.911
        eulerRotation.x: -90
        source: "meshes/trunk.mesh"
        materials: [
            body_material,
            glass_tex2_material,
            d_glass_material
        ]
    }

    Model {
        id: door_rear_right
        x: 364.382
        y: 294.705
        z: 91.3009
        eulerRotation.x: -90
        source: "meshes/door_rear_right.mesh"
        materials: [
            material_004_material,
            d_glass_material
        ]
    }

    Model {
        id: door_rear_left
        x: -347.924
        y: 337.4
        z: 92.2482
        eulerRotation.x: -90
        source: "meshes/door_rear_left.mesh"
        materials: [
            material_004_material,
            d_glass_material
        ]
    }

    Model {
        id: door_front_right
        x: 361.778
        y: 306.167
        z: -341.674
        eulerRotation.x: -90
        source: "meshes/door_front_right.mesh"
        materials: [
            material_004_material,
            d_glass_material
        ]
    }
}
