/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.billingclient.api.AccountIdentifiers;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.zzc;
import com.android.billingclient.api.zzd;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Purchase {
    private final String zza;
    private final String zzb;
    private final JSONObject zzc;

    public int getPurchaseState() {
        switch (this.zzc.optInt("purchaseState", 1)) {
            default: {
                return 1;
            }
            case 4: 
        }
        return 2;
    }

    @zzd
    public int getQuantity() {
        return this.zzc.optInt("quantity", 1);
    }

    public int hashCode() {
        return this.zza.hashCode();
    }

    public long getPurchaseTime() {
        return this.zzc.optLong("purchaseTime");
    }

    @Nullable
    public AccountIdentifiers getAccountIdentifiers() {
        String string = ((Purchase)((Object)this_)).zzc.optString("obfuscatedAccountId");
        String this_ = ((Purchase)((Object)this_)).zzc.optString("obfuscatedProfileId");
        if (string == null && this_ == null) {
            return null;
        }
        AccountIdentifiers accountIdentifiers = new AccountIdentifiers(string, this_);
        return accountIdentifiers;
    }

    @NonNull
    public String getDeveloperPayload() {
        return this.zzc.optString("developerPayload");
    }

    @NonNull
    public String getOrderId() {
        return this.zzc.optString("orderId");
    }

    @NonNull
    public String getOriginalJson() {
        return this.zza;
    }

    @NonNull
    public String getPackageName() {
        return this.zzc.optString("packageName");
    }

    @NonNull
    public String getPurchaseToken() {
        Purchase this_ = this_.zzc;
        return this_.optString("token", this_.optString("purchaseToken"));
    }

    @NonNull
    public String getSignature() {
        return this.zzb;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public String toString() {
        String this_ = String.valueOf(((Purchase)((Object)this_)).zza);
        String string = "Purchase. Json: ";
        if (this_.length() == 0) return new String(string);
        return string.concat(this_);
    }

    /*
     * Enabled aggressive block sorting
     */
    @zzc
    @NonNull
    public ArrayList<String> getSkus() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.zzc.has("productIds")) {
            if (!this.zzc.has("productId")) return arrayList;
            arrayList.add(this.zzc.optString("productId"));
            return arrayList;
        }
        JSONArray jSONArray = this.zzc.optJSONArray("productIds");
        if (jSONArray == null) return arrayList;
        int n = 0;
        while (n < jSONArray.length()) {
            arrayList.add(jSONArray.optString(n));
            ++n;
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public Purchase(@NonNull String jsonPurchaseInfo, @NonNull String signature) throws JSONException {
        void var2_2;
        JSONObject jSONObject;
        this.zza = jSONObject;
        this.zzb = var2_2;
        this.zzc = jSONObject = new JSONObject(this.zza);
    }

    public boolean equals(@Nullable Object o) {
        Purchase purchase;
        if (this == purchase) {
            return true;
        }
        if (!(purchase instanceof Purchase)) {
            return false;
        }
        return TextUtils.equals((CharSequence)this.zza, (CharSequence)(purchase = (Purchase)purchase).getOriginalJson()) && TextUtils.equals((CharSequence)this.zzb, (CharSequence)purchase.getSignature());
    }

    public boolean isAcknowledged() {
        return this.zzc.optBoolean("acknowledged", true);
    }

    public boolean isAutoRenewing() {
        return this.zzc.optBoolean("autoRenewing");
    }

    public static class PurchasesResult {
        @Nullable
        private final List<Purchase> zza;
        private final BillingResult zzb;

        public int getResponseCode() {
            return this.getBillingResult().getResponseCode();
        }

        @NonNull
        public BillingResult getBillingResult() {
            return this.zzb;
        }

        @Nullable
        public List<Purchase> getPurchasesList() {
            return this.zza;
        }

        /*
         * WARNING - void declaration
         */
        public PurchasesResult(@NonNull BillingResult mBillingResult, @Nullable List<Purchase> purchasesList) {
            void var1_1;
            void var2_2;
            this.zza = var2_2;
            this.zzb = var1_1;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PurchaseState {
        public static final int UNSPECIFIED_STATE = 0;
        public static final int PURCHASED = 1;
        public static final int PENDING = 2;
    }
}

