#ifndef SRC_NODE_NATIVE_MODULE_H_
#define SRC_NODE_NATIVE_MODULE_H_

#if defined(NODE_WANT_INTERNALS) && NODE_WANT_INTERNALS

#include <map>
#include <set>
#include <string>
#include "env.h"
#include "node_union_bytes.h"
#include "v8.h"

namespace node {
namespace native_module {

using NativeModuleRecordMap = std::map<std::string, UnionBytes>;
using NativeModuleHashMap = std::map<std::string, std::string>;

// The native (C++) side of the native module compilation.
// This class should not depend on Environment
class NativeModuleLoader {
 public:
  NativeModuleLoader();
  static void Initialize(v8::Local<v8::Object> target,
                         v8::Local<v8::Value> unused,
                         v8::Local<v8::Context> context);
  v8::Local<v8::Object> GetSourceObject(v8::Local<v8::Context> context) const;
  v8::Local<v8::String> GetSource(v8::Isolate* isolate, const char* id) const;

 private:
  static void GetCacheUsage(const v8::FunctionCallbackInfo<v8::Value>& args);
  // For legacy process.binding('natives') which is mutable, and for
  // internalBinding('native_module').source for internal use
  static void GetSourceObject(const v8::FunctionCallbackInfo<v8::Value>& args);
  // Compile code cache for a specific native module
  static void CompileCodeCache(const v8::FunctionCallbackInfo<v8::Value>& args);
  // Compile a specific native module as a function
  static void CompileFunction(const v8::FunctionCallbackInfo<v8::Value>& args);

  // Generated by tools/js2c.py as node_javascript.cc
  void LoadJavaScriptSource();  // Loads data into source_
  void LoadJavaScriptHash();    // Loads data into source_hash_

  // Generated by tools/generate_code_cache.js as node_code_cache.cc when
  // the build is configured with --code-cache-path=.... They are noops
  // in node_code_cache_stub.cc
  void LoadCodeCache();      // Loads data into code_cache_
  void LoadCodeCacheHash();  // Loads data into code_cache_hash_

  v8::ScriptCompiler::CachedData* GetCachedData(const char* id) const;
  static v8::Local<v8::Value> CompileAsModule(Environment* env,
                                              const char* id,
                                              bool produce_code_cache);
  // TODO(joyeecheung): make this public and reuse it to compile bootstrappers.
  // For bootstrappers optional_env may be a nullptr.
  // This method magically knows what parameter it should pass to
  // the function to be compiled.
  v8::Local<v8::Value> LookupAndCompile(v8::Local<v8::Context> context,
                                        const char* id,
                                        bool produce_code_cache,
                                        Environment* optional_env);

  bool has_code_cache_ = false;
  NativeModuleRecordMap source_;
  NativeModuleRecordMap code_cache_;
  NativeModuleHashMap source_hash_;
  NativeModuleHashMap code_cache_hash_;
};

}  // namespace native_module
}  // namespace node

#endif  // defined(NODE_WANT_INTERNALS) && NODE_WANT_INTERNALS

#endif  // SRC_NODE_NATIVE_MODULE_H_
