import { FileSystem, LanguageServicePlugin } from '@volar/language-service';
import { SnapshotDocument } from '@volar/snapshot-document';
import * as vscode from 'vscode-languageserver';
import { URI } from 'vscode-uri';
import type { InitializationOptions, ServerProjectProvider, VolarInitializeParams } from './types.js';
import { UriConverter } from './uri.js';
export * from '@volar/snapshot-document';
export declare function createServerBase(connection: vscode.Connection, getFs: (options: InitializationOptions, uriConverter: UriConverter) => FileSystem): {
    connection: vscode.Connection;
    initializeParams: VolarInitializeParams;
    languageServicePlugins: LanguageServicePlugin<any>[];
    projects: ServerProjectProvider;
    fs: FileSystem;
    semanticTokensLegend: vscode.SemanticTokensLegend;
    pullModelDiagnostics: boolean;
    documents: vscode.TextDocuments<SnapshotDocument>;
    uriConverter: {
        uriToFileName: (uri: string, parsed?: URI | undefined) => string;
        fileNameToUri: (fileName: string) => string;
    };
    workspaceFolders: {
        clear: () => void;
        values: () => IterableIterator<boolean>;
        keys: () => Generator<URI, void, unknown>;
        delete: (uri: URI) => boolean;
        get: (uri: URI) => boolean | undefined;
        has: (uri: URI) => boolean;
        set: (uri: URI, item: boolean) => Map<string, boolean>;
    };
    initialize: (initializeParams: VolarInitializeParams, languageServicePlugins: LanguageServicePlugin[], projects: ServerProjectProvider, options?: {
        semanticTokensLegend?: vscode.SemanticTokensLegend;
        pullModelDiagnostics?: boolean;
    }) => vscode.InitializeResult<any>;
    initialized: () => void;
    shutdown: () => Promise<void>;
    watchFiles: (patterns: string[]) => void;
    getConfiguration: <T>(section: string, scopeUri?: string) => Promise<T | undefined>;
    onDidChangeConfiguration: (cb: vscode.NotificationHandler<vscode.DidChangeConfigurationParams>) => {
        dispose(): void;
    };
    onDidChangeWatchedFiles: (cb: vscode.NotificationHandler<vscode.DidChangeWatchedFilesParams>) => {
        dispose: () => void;
    };
    clearPushDiagnostics: () => void;
    refresh: (projects: ServerProjectProvider) => Promise<void>;
};
