/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.registry;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.languageconfiguration.internal.model.LanguageConfiguration;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationRegistryManager;

public abstract class AbstractLanguageConfigurationRegistryManager
implements ILanguageConfigurationRegistryManager {
    protected final Map<IContentType, ILanguageConfigurationDefinition> pluginDefinitions = new HashMap<IContentType, ILanguageConfigurationDefinition>();
    protected final Map<IContentType, ILanguageConfigurationDefinition> userDefinitions = new HashMap<IContentType, ILanguageConfigurationDefinition>();

    @Override
    public ILanguageConfigurationDefinition[] getDefinitions() {
        HashSet definitions = new HashSet();
        this.userDefinitions.values().forEach(definitions::add);
        this.pluginDefinitions.values().forEach(definitions::add);
        return (ILanguageConfigurationDefinition[])definitions.toArray(ILanguageConfigurationDefinition[]::new);
    }

    @Override
    public void registerLanguageConfigurationDefinition(ILanguageConfigurationDefinition definition) {
        if (definition.getPluginId() == null) {
            this.userDefinitions.put(definition.getContentType(), definition);
        } else {
            this.pluginDefinitions.put(definition.getContentType(), definition);
        }
    }

    @Override
    public void unregisterLanguageConfigurationDefinition(ILanguageConfigurationDefinition definition) {
        if (definition.getPluginId() == null) {
            this.userDefinitions.remove(definition.getContentType());
        } else {
            this.pluginDefinitions.remove(definition.getContentType());
        }
    }

    @Override
    public @Nullable LanguageConfiguration getLanguageConfigurationFor(IContentType ... contentTypes) {
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            if (this.userDefinitions.containsKey(contentType)) {
                return this.userDefinitions.get(contentType).getLanguageConfiguration();
            }
            if (this.pluginDefinitions.containsKey(contentType)) {
                return this.pluginDefinitions.get(contentType).getLanguageConfiguration();
            }
            ++n2;
        }
        return null;
    }
}

