/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.typeHierarchy;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.FileBufferListenerAdapter;
import org.eclipse.lsp4e.operations.typeHierarchy.TypeHierarchyItemLabelProvider;
import org.eclipse.lsp4e.operations.typeHierarchy.TypeHierarchyViewContentProvider;
import org.eclipse.lsp4e.operations.typeHierarchy.TypeMemberContentProvider;
import org.eclipse.lsp4e.outline.SymbolsLabelProvider;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.views.HierarchyViewInput;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TypeHierarchyItem;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class TypeHierarchyView
extends ViewPart {
    public static final String ID = "org.eclipse.lsp4e.operations.typeHierarchy.TypeHierarchyView";
    TypeHierarchyViewContentProvider contentProvider = new TypeHierarchyViewContentProvider();
    DecoratingStyledCellLabelProvider symbolsLabelProvider = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new SymbolsLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), DecorationContext.DEFAULT_CONTEXT);
    private PageBook pagebook;
    private SashForm splitter;
    private ViewForm memberViewForm;
    private CLabel memberLabel;
    private Label infoText;
    private TableViewer memberViewer;
    protected TreeViewer treeViewer;
    private HashMap<URI, SymbolsContainer> cachedSymbols = new HashMap();
    private volatile String typeName;
    private final IFileBufferListener fileBufferListener = new FileBufferListenerAdapter(){

        @Override
        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            SymbolsContainer cachedSymbol;
            if (isDirty && (cachedSymbol = this.getSymbolsContainer(buffer)) != null) {
                cachedSymbol.isDirty = true;
            }
        }

        @Override
        public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
            URI uri;
            SymbolsContainer symbolsContainer = this.getSymbolsContainer(buffer);
            if (symbolsContainer != null && buffer != null && (uri = LSPEclipseUtils.toUri(buffer)) != null) {
                symbolsContainer.setUri(uri);
                TypeHierarchyView.this.cachedSymbols.put(uri, new SymbolsContainer(uri));
            }
        }

        private SymbolsContainer getSymbolsContainer(IFileBuffer buffer) {
            if (buffer != null) {
                return TypeHierarchyView.this.cachedSymbols.get(LSPEclipseUtils.toUri(buffer));
            }
            return null;
        }
    };

    public void setFocus() {
        this.pagebook.setFocus();
    }

    public void createPartControl(Composite parent) {
        this.pagebook = new PageBook(parent, 0);
        this.splitter = new SashForm((Composite)this.pagebook, 512);
        this.splitter.setLayoutData((Object)new GridData(1808));
        this.splitter.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TypeHierarchyView.this.splitter.setOrientation(TypeHierarchyView.this.getBestOrientation());
                TypeHierarchyView.this.splitter.layout();
            }
        });
        this.treeViewer = this.getFilteredTree((Composite)this.splitter).getViewer();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TypeHierarchyItemLabelProvider());
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.getControl().setEnabled(false);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            /*
             * WARNING - void declaration
             */
            public void doubleClick(DoubleClickEvent event) {
                Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                Object object = selection;
                if (object instanceof TypeHierarchyItem) {
                    void item;
                    TypeHierarchyItem typeHierarchyItem = (TypeHierarchyItem)object;
                    TypeHierarchyItem cfr_ignored_0 = (TypeHierarchyItem)object;
                    LSPEclipseUtils.open(item.getUri(), item.getSelectionRange());
                }
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TypeHierarchyView.this.onHierarchySelectionChanged(event);
            }
        });
        this.memberViewForm = new ViewForm((Composite)this.splitter, 0);
        Control memberControl = this.createMemberControl(this.memberViewForm);
        memberControl.setEnabled(false);
        this.memberViewForm.setContent(memberControl);
        this.memberLabel = new CLabel((Composite)this.memberViewForm, 0);
        this.memberViewForm.setTopLeft((Control)this.memberLabel);
        this.infoText = new Label((Composite)this.pagebook, 16576);
        this.infoText.setText(Messages.TH_diplay_hint);
        this.pagebook.showPage((Control)this.infoText);
        FileBuffers.getTextFileBufferManager().addFileBufferListener(this.fileBufferListener);
    }

    public void dispose() {
        FileBuffers.getTextFileBufferManager().removeFileBufferListener(this.fileBufferListener);
        this.cachedSymbols.forEach((uri, container) -> container.dispose());
        super.dispose();
    }

    public void initialize(IDocument document, int offset) {
        this.treeViewer.setInput((Object)new HierarchyViewInput(document, offset));
        this.pagebook.showPage((Control)this.splitter);
    }

    /*
     * WARNING - void declaration
     */
    private void onHierarchySelectionChanged(SelectionChangedEvent event) {
        Object element;
        Object object;
        ISelection selection = event.getSelection();
        if (selection instanceof TreeSelection && !selection.isEmpty() && (object = (element = ((TreeSelection)selection).getFirstElement())) instanceof TypeHierarchyItem) {
            void item;
            TypeHierarchyItem typeHierarchyItem = (TypeHierarchyItem)object;
            TypeHierarchyItem cfr_ignored_0 = (TypeHierarchyItem)object;
            URI uri = null;
            try {
                uri = new URI(item.getUri());
            }
            catch (URISyntaxException e) {
                LanguageServerPlugin.logError(e);
                return;
            }
            this.refreshMemberViewer(this.getSymbolsContainer(uri), item.getName(), false);
        }
    }

    private void refreshMemberViewer(SymbolsContainer symbolsContainer, String typeName, boolean documentModified) {
        this.memberViewer.setInput((Object)new PendingUpdateAdapter());
        this.memberLabel.setImage(JFaceResources.getImage((String)"WAITING_JOB"));
        this.memberLabel.setText(Messages.outline_computingSymbols);
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            if (symbolsContainer != null) {
                this.refreshSymbols(symbolsContainer, documentModified);
                SymbolsModel.DocumentSymbolWithURI symbol = this.getDocumentSymbol(symbolsContainer, typeName);
                this.memberViewer.setInput((Object)symbol);
                this.memberLabel.setText(typeName + this.getFilePath(symbolsContainer.uri));
                if (symbol != null) {
                    this.memberViewer.getControl().setEnabled(true);
                    this.memberViewer.setSelection((ISelection)new StructuredSelection((Object)symbol));
                    this.memberLabel.setImage(this.symbolsLabelProvider.getImage((Object)symbol));
                }
            } else {
                this.memberViewer.setInput(null);
                this.memberLabel.setText(Messages.TH_cannot_find_file);
                this.memberLabel.setImage(null);
            }
        });
    }

    private String getFilePath(URI uri) {
        return Optional.ofNullable(uri.getPath()).map(path -> " - " + path).orElse("");
    }

    private Control createMemberControl(ViewForm parent) {
        this.memberViewer = new TableViewer((Composite)parent, 2816);
        this.memberViewer.setContentProvider((IContentProvider)new TypeMemberContentProvider());
        this.memberViewer.setLabelProvider((IBaseLabelProvider)this.symbolsLabelProvider);
        this.memberViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                SymbolsModel.DocumentSymbolWithURI container = (SymbolsModel.DocumentSymbolWithURI)((IStructuredSelection)event.getSelection()).getFirstElement();
                SymbolsContainer symbolsContainer = TypeHierarchyView.this.cachedSymbols.get(container.uri);
                if (symbolsContainer != null) {
                    LSPEclipseUtils.open(symbolsContainer.uri.toASCIIString(), container.symbol.getRange());
                }
            }
        });
        return this.memberViewer.getControl();
    }

    private int getBestOrientation() {
        Point size = this.splitter.getSize();
        if (size.x != 0 && size.y != 0 && 3 * size.x < 2 * size.y) {
            return 512;
        }
        return 256;
    }

    private FilteredTree getFilteredTree(Composite parent) {
        return new FilteredTree(parent, 2048, new PatternFilter(), true, false){

            protected Composite createFilterControls(Composite parent) {
                Composite composite = new Composite(parent, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.horizontalSpacing = 0;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                composite.setLayout((Layout)layout);
                Composite filterControls = super.createFilterControls(composite);
                filterControls.setLayoutData((Object)new GridData(4, 0, true, false));
                this.createToolBar(composite);
                return composite;
            }

            private void createToolBar(Composite composite) {
                ToolBar toolbar = new ToolBar(composite, 540676);
                final ToolItem hierchyModeItem = new ToolItem(toolbar, 8);
                this.updateHierarchyModeItem(hierchyModeItem, TypeHierarchyView.this.contentProvider.showSuperTypes);
                hierchyModeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        (this).TypeHierarchyView.this.contentProvider.showSuperTypes = !(this).TypeHierarchyView.this.contentProvider.showSuperTypes;
                        this.updateHierarchyModeItem(hierchyModeItem, (this).TypeHierarchyView.this.contentProvider.showSuperTypes);
                        this.getViewer().refresh();
                    }
                });
            }

            private void updateHierarchyModeItem(ToolItem hierchyModeItem, boolean showSuperTypes) {
                hierchyModeItem.setImage(LSPImages.getImage(showSuperTypes ? "IMG_SUBTYPE" : "IMG_SUPERTYPE"));
                hierchyModeItem.setToolTipText(showSuperTypes ? Messages.typeHierarchy_show_subtypes : Messages.typeHierarchy_show_supertypes);
            }
        };
    }

    private SymbolsContainer getSymbolsContainer(URI uri) {
        return this.cachedSymbols.computeIfAbsent(uri, entry -> new SymbolsContainer(uri));
    }

    private synchronized void refreshSymbols(SymbolsContainer symbolsContainer, boolean documentModified) {
        block7: {
            if (symbolsContainer == null || !symbolsContainer.isDirty && !documentModified) {
                return;
            }
            IDocument document = symbolsContainer.getDocument();
            try {
                if (document != null) {
                    CompletableFuture<Object> symbols;
                    block6: {
                        DocumentSymbolParams params = new DocumentSymbolParams(LSPEclipseUtils.toTextDocumentIdentifier(document));
                        CompletableFuture languageServer = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getDocumentSymbolProvider)).computeFirst((w, ls) -> CompletableFuture.completedFuture(w));
                        try {
                            symbols = languageServer.get(500L, TimeUnit.MILLISECONDS).filter(Objects::nonNull).filter(LanguageServerWrapper::isActive).map(s -> s.execute(ls -> ls.getTextDocumentService().documentSymbol(params))).orElse(CompletableFuture.completedFuture(null));
                        }
                        catch (InterruptedException | ExecutionException | TimeoutException e) {
                            LanguageServerPlugin.logError(e);
                            symbols = CompletableFuture.completedFuture(null);
                            if (!(e instanceof InterruptedException)) break block6;
                            Thread.currentThread().interrupt();
                        }
                    }
                    ((CompletableFuture)symbols.thenAcceptAsync(response -> {
                        symbolsContainer.symbolsModel.update((List<Either<SymbolInformation, DocumentSymbol>>)response);
                        symbolsContainer.isDirty = false;
                    })).join();
                    break block7;
                }
                symbolsContainer.symbolsModel.update(null);
            }
            catch (Exception e) {
                LanguageServerPlugin.logError(e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private SymbolsModel.DocumentSymbolWithURI getDocumentSymbol(SymbolsContainer symbolsContainer, String typeName) {
        if (symbolsContainer != null) {
            Object[] elements;
            Object[] objectArray = elements = symbolsContainer.symbolsModel.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                Object object = element;
                if (object instanceof SymbolsModel.DocumentSymbolWithURI) {
                    void symbolContainer;
                    SymbolsModel.DocumentSymbolWithURI cfr_ignored_0 = (SymbolsModel.DocumentSymbolWithURI)object;
                    SymbolsModel.DocumentSymbolWithURI cfr_ignored_1 = (SymbolsModel.DocumentSymbolWithURI)object;
                    if (this.isClass(symbolContainer.symbol.getKind()) && symbolContainer.symbol.getName().equals(typeName)) {
                        return new SymbolsModel.DocumentSymbolWithURI(symbolContainer.symbol, symbolContainer.uri);
                    }
                    DocumentSymbol grandchild = this.searchInChildren(symbolContainer.symbol.getChildren(), typeName);
                    if (grandchild != null) {
                        return new SymbolsModel.DocumentSymbolWithURI(grandchild, symbolContainer.uri);
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean isClass(SymbolKind kind) {
        return SymbolKind.Class.equals((Object)kind) || SymbolKind.Struct.equals((Object)kind);
    }

    private DocumentSymbol searchInChildren(List<DocumentSymbol> children, String typeName) {
        if (children == null) {
            return null;
        }
        for (DocumentSymbol child : children) {
            if (child.getName().equals(typeName) && this.isClass(child.getKind())) {
                return child;
            }
            DocumentSymbol grandchild = this.searchInChildren(child.getChildren(), typeName);
            if (grandchild == null) continue;
            return grandchild;
        }
        return null;
    }

    class SymbolsContainer {
        private final SymbolsModel symbolsModel = new SymbolsModel();
        private volatile boolean isDirty = true;
        private boolean temporaryLoadedDocument = false;
        private volatile URI uri;

        SymbolsContainer(URI uri) {
            this.setUri(uri);
        }

        public IDocument getDocument() {
            IDocument document = null;
            IFile file = LSPEclipseUtils.getFileHandle(this.uri);
            if (file == null) {
                document = LSPEclipseUtils.getDocument(this.uri);
                this.temporaryLoadedDocument = document != null;
            } else {
                document = LSPEclipseUtils.getExistingDocument((IResource)file);
                if (document == null) {
                    document = LSPEclipseUtils.getDocument((IResource)file);
                    this.temporaryLoadedDocument = document != null;
                }
            }
            return document;
        }

        public void setUri(URI uri) {
            this.dispose();
            this.uri = uri;
            this.symbolsModel.setUri(uri);
        }

        public void dispose() {
            if (this.temporaryLoadedDocument) {
                IFile file = LSPEclipseUtils.getFileHandle(this.uri);
                if (file != null) {
                    try {
                        FileBuffers.getTextFileBufferManager().disconnect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        LanguageServerPlugin.logError(e);
                    }
                } else {
                    try {
                        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
                        if (bufferManager != null) {
                            bufferManager.disconnectFileStore(EFS.getStore((URI)this.uri), (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (CoreException e) {
                        LanguageServerPlugin.logError(e);
                    }
                }
            }
        }
    }
}

