/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class EditVariableLogicalStructureAction
extends Action {
    private ILogicalStructureType fStructure = null;
    private VariablesView fView = null;

    public EditVariableLogicalStructureAction(VariablesView view) {
        this.fView = view;
        ISelection selection = view.getViewer().getSelection();
        if (selection != null) {
            this.init(selection);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run() {
        PreferencesUtil.createPreferenceDialogOn((Shell)DebugUIPlugin.getShell(), (String)"org.eclipse.jdt.debug.ui.JavaLogicalStructuresPreferencePage", (String[])new String[]{"org.eclipse.jdt.debug.ui.JavaDetailFormattersPreferencePage", "org.eclipse.jdt.debug.ui.JavaLogicalStructuresPreferencePage", "org.eclipse.jdt.debug.ui.heapWalking", "org.eclipse.jdt.debug.ui.JavaPrimitivesPreferencePage"}, this.fStructure != null ? this.fStructure.getId() + this.fStructure.getDescription() + this.fStructure.hashCode() : null).open();
    }

    private void init(ISelection selection) {
        this.fStructure = null;
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (element instanceof IVariable) {
            try {
                ILogicalStructureType type;
                IValue value = ((IVariable)element).getValue();
                this.fStructure = type = this.getLogicalStructure(value);
            }
            catch (DebugException e) {
                DebugUIPlugin.log(e.getStatus());
            }
        }
        this.setEnabled(this.fView.isShowLogicalStructure());
    }

    private ILogicalStructureType getLogicalStructure(IValue value) {
        ILogicalStructureType type = null;
        ILogicalStructureType[] types = DebugPlugin.getLogicalStructureTypes((IValue)value);
        if (types.length > 0) {
            type = DebugPlugin.getDefaultStructureType((ILogicalStructureType[])types);
        }
        return type;
    }
}

