/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.tracwiki.internal.token;

import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElementProcessor;
import org.eclipse.mylyn.wikitext.tracwiki.TracWikiLanguage;

public class HyperlinkReplacementToken
extends PatternBasedElement {
    protected String getPattern(int groupOffset) {
        return "\\[\\s*(wiki:)?([^\\]\\s]+)\\s*([^\\]]+)?\\s*\\]";
    }

    protected int getPatternGroupCount() {
        return 3;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new HyperlinkReplacementTokenProcessor();
    }

    private static class HyperlinkReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private HyperlinkReplacementTokenProcessor() {
        }

        public void emit() {
            String wikiUrl = this.group(1);
            String href = this.group(2);
            String text = this.group(3);
            if (text == null) {
                text = href;
            } else if ((text = text.trim()).length() == 0) {
                text = href;
            }
            if (wikiUrl != null) {
                href = ((TracWikiLanguage)this.markupLanguage).toInternalHref(href);
            }
            this.builder.link(href, text);
        }
    }
}

