/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.util.Version;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.util.HelpProperties;
import org.eclipse.help.internal.protocols.HelpURLConnection;
import org.eclipse.help.internal.protocols.HelpURLStreamHandler;
import org.eclipse.help.internal.search.AnalyzerDescriptor;
import org.eclipse.help.internal.search.HTMLSearchParticipant;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.LocalSearchManager;
import org.eclipse.help.internal.search.LuceneSearchDocument;
import org.eclipse.help.internal.search.PluginIndex;
import org.eclipse.help.internal.search.PluginVersionInfo;
import org.eclipse.help.internal.search.QueryBuilder;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.toc.TocManager;
import org.eclipse.help.search.IHelpSearchIndex;
import org.eclipse.help.search.ISearchDocument;
import org.eclipse.help.search.SearchParticipant;
import org.osgi.framework.Bundle;

public class SearchIndex
implements IHelpSearchIndex {
    private IndexReader ir;
    private IndexWriter iw;
    private File indexDir;
    private Directory luceneDirectory;
    private String locale;
    private String relativePath;
    private TocManager tocManager;
    private AnalyzerDescriptor analyzerDescriptor;
    private PluginVersionInfo docPlugins;
    private HelpProperties indexedDocs;
    public static final String INDEXED_CONTRIBUTION_INFO_FILE = "indexed_contributions";
    public static final String INDEXED_DOCS_FILE = "indexed_docs";
    public static final String DEPENDENCIES_VERSION_FILENAME = "indexed_dependencies";
    public static final String DEPENDENCIES_KEY_LUCENE = "lucene";
    public static final String DEPENDENCIES_KEY_ANALYZER = "analyzer";
    private static final String LUCENE_BUNDLE_ID = "org.apache.lucene.core";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_INDEX_ID = "index_path";
    private File inconsistencyFile;
    private HTMLSearchParticipant htmlSearchParticipant;
    private IndexSearcher searcher;
    private Object searcherCreateLock;
    private HelpProperties dependencies;
    private volatile boolean closed;
    private Collection<Thread> searches;
    private FileLock lock;
    private RandomAccessFile raf;
    private static boolean errorReported = false;

    public SearchIndex(String locale, AnalyzerDescriptor analyzerDesc, TocManager tocManager) {
        this(new File(HelpBasePlugin.getConfigurationDirectory(), "index/" + locale), locale, analyzerDesc, tocManager, null);
    }

    public SearchIndex(File indexDir, String locale, AnalyzerDescriptor analyzerDesc, TocManager tocManager, String relativePath) {
        block17: {
            this.searcherCreateLock = new Object();
            this.closed = false;
            this.searches = new ArrayList<Thread>();
            this.raf = null;
            this.locale = locale;
            this.analyzerDescriptor = analyzerDesc;
            this.tocManager = tocManager;
            this.indexDir = indexDir;
            this.relativePath = relativePath;
            this.inconsistencyFile = new File(indexDir.getParentFile(), String.valueOf(locale) + ".inconsistent");
            this.htmlSearchParticipant = new HTMLSearchParticipant(indexDir.getAbsolutePath());
            try {
                this.luceneDirectory = new NIOFSDirectory(indexDir.toPath());
            }
            catch (IOException iOException) {}
            if (!this.exists()) {
                try {
                    if (!this.tryLock()) break block17;
                    try {
                        this.unzipProductIndex();
                    }
                    finally {
                        this.releaseLock();
                    }
                }
                catch (OverlappingFileLockException overlappingFileLockException) {}
            }
        }
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                DirectoryReader reader = DirectoryReader.open((Directory)this.luceneDirectory);
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IllegalArgumentException | IndexFormatTooOldException | IndexNotFoundException throwable) {
            this.deleteDir(indexDir);
            indexDir.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void deleteDir(File indexDir) {
        File[] files = indexDir.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.deleteDir(file);
            }
            file.delete();
            ++n2;
        }
    }

    public IStatus addDocument(String name, URL url) {
        try {
            Document doc = new Document();
            doc.add((IndexableField)new StringField(FIELD_NAME, name, Field.Store.YES));
            this.addExtraFields(doc);
            String pluginId = LocalSearchManager.getPluginId(name);
            if (this.relativePath != null) {
                doc.add((IndexableField)new StringField(FIELD_INDEX_ID, this.relativePath, Field.Store.YES));
            }
            SearchParticipant participant = null;
            HelpURLConnection urlc = new HelpURLConnection(url);
            String id = urlc.getValue("id");
            String pid = urlc.getValue("participantId");
            if (pid != null) {
                participant = BaseHelpSystem.getLocalSearchManager().getGlobalParticipant(pid);
            }
            if (participant == null) {
                participant = BaseHelpSystem.getLocalSearchManager().getParticipant(pluginId, name);
            }
            if (participant != null) {
                IStatus status = participant.addDocument(this, pluginId, name, url, id, new LuceneSearchDocument(doc));
                if (status.getSeverity() == 0) {
                    String filters = doc.get("filters");
                    this.indexedDocs.put(name, filters != null ? filters : "0");
                    if (id != null) {
                        doc.add((IndexableField)new StoredField("id", id));
                    }
                    if (pid != null) {
                        doc.add((IndexableField)new StoredField("participantId", pid));
                    }
                    this.iw.addDocument((Iterable)doc);
                }
                return status;
            }
            IStatus status = this.htmlSearchParticipant.addDocument(this, pluginId, name, url, id, new LuceneSearchDocument(doc));
            if (status.getSeverity() == 0) {
                String filters = doc.get("filters");
                this.indexedDocs.put(name, filters != null ? filters : "0");
                this.iw.addDocument((Iterable)doc);
            }
            return status;
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.help.base", 4, "IO exception occurred while adding document " + name + " to index " + this.indexDir.getAbsolutePath() + ".", (Throwable)e);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.help.base", 4, "An unexpected internal error occurred while adding document " + name + " to index " + this.indexDir.getAbsolutePath() + ".", (Throwable)e);
        }
    }

    protected void addExtraFields(Document doc) {
    }

    public synchronized boolean beginAddBatch(boolean firstOperation) {
        boolean create;
        block4: {
            try {
                if (this.iw != null) {
                    this.iw.close();
                }
                create = false;
                if (this.indexDir.exists() && this.isLuceneCompatible() && this.isAnalyzerCompatible() && (!this.inconsistencyFile.exists() || !firstOperation)) break block4;
                create = true;
                this.indexDir.mkdirs();
                if (this.indexDir.exists()) break block4;
                return false;
            }
            catch (IOException e) {
                Platform.getLog(this.getClass()).error("Exception occurred in search indexing at beginAddBatch.", (Throwable)e);
                return false;
            }
        }
        this.indexedDocs = new HelpProperties(INDEXED_DOCS_FILE, this.indexDir);
        this.indexedDocs.restore();
        this.setInconsistent(true);
        LimitTokenCountAnalyzer analyzer = new LimitTokenCountAnalyzer(this.analyzerDescriptor.getAnalyzer(), 1000000);
        IndexWriterConfig writerConfig = new IndexWriterConfig((Analyzer)analyzer);
        writerConfig.setOpenMode(create ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.APPEND);
        LogByteSizeMergePolicy mergePolicy = new LogByteSizeMergePolicy();
        mergePolicy.setMergeFactor(20);
        writerConfig.setMergePolicy((MergePolicy)mergePolicy);
        this.iw = new IndexWriter(this.luceneDirectory, writerConfig);
        return true;
    }

    public synchronized boolean beginDeleteBatch() {
        try {
            if (this.iw != null) {
                this.iw.close();
            }
            this.indexedDocs = new HelpProperties(INDEXED_DOCS_FILE, this.indexDir);
            this.indexedDocs.restore();
            this.setInconsistent(true);
            this.iw = new IndexWriter(this.luceneDirectory, new IndexWriterConfig(this.analyzerDescriptor.getAnalyzer()));
            return true;
        }
        catch (IOException e) {
            Platform.getLog(this.getClass()).error("Exception occurred in search indexing at beginDeleteBatch.", (Throwable)e);
            return false;
        }
    }

    public synchronized boolean beginRemoveDuplicatesBatch() {
        try {
            if (this.ir != null) {
                this.ir.close();
            }
            this.ir = DirectoryReader.open((Directory)this.luceneDirectory);
            if (this.iw == null) {
                return this.beginDeleteBatch();
            }
            return true;
        }
        catch (IOException e) {
            Platform.getLog(this.getClass()).error("Exception occurred in search indexing at beginDeleteBatch.", (Throwable)e);
            return false;
        }
    }

    public IStatus removeDocument(String name) {
        Term term = new Term(FIELD_NAME, name);
        try {
            this.iw.deleteDocuments(new Term[]{term});
            this.indexedDocs.remove(name);
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.help.base", 4, "IO exception occurred while removing document " + name + " from index " + this.indexDir.getAbsolutePath() + ".", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public synchronized boolean endAddBatch(boolean optimize, boolean lastOperation) {
        block6: {
            try {
                if (this.iw != null) break block6;
                return false;
            }
            catch (IOException e) {
                Platform.getLog(this.getClass()).error("Exception occurred in search indexing at endAddBatch.", (Throwable)e);
                return false;
            }
        }
        if (optimize) {
            this.iw.forceMerge(1, true);
        }
        this.iw.close();
        this.iw = null;
        this.getDocPlugins().save();
        this.saveDependencies();
        if (lastOperation) {
            this.indexedDocs.save();
            this.indexedDocs = null;
            this.setInconsistent(false);
        }
        if (this.searcher != null) {
            this.searcher.getIndexReader().close();
            this.searcher = null;
        }
        return true;
    }

    public synchronized boolean endDeleteBatch() {
        block4: {
            try {
                if (this.iw != null) break block4;
                return false;
            }
            catch (IOException e) {
                Platform.getLog(this.getClass()).error("Exception occurred in search indexing at endDeleteBatch.", (Throwable)e);
                return false;
            }
        }
        this.iw.close();
        this.iw = null;
        this.indexedDocs.save();
        this.indexedDocs = null;
        this.getDocPlugins().save();
        this.saveDependencies();
        if (this.searcher != null) {
            this.searcher.getIndexReader().close();
            this.searcher = null;
        }
        return true;
    }

    public synchronized boolean endRemoveDuplicatesBatch() {
        block3: {
            try {
                if (this.ir != null) break block3;
                return false;
            }
            catch (IOException e) {
                Platform.getLog(this.getClass()).error("Exception occurred in search indexing at endDeleteBatch.", (Throwable)e);
                return false;
            }
        }
        this.ir.close();
        this.ir = null;
        this.iw.close();
        this.iw = null;
        this.indexedDocs.save();
        this.indexedDocs = null;
        this.getDocPlugins().save();
        this.saveDependencies();
        this.setInconsistent(false);
        return true;
    }

    public Map<String, String[]> merge(PluginIndex[] pluginIndexes, IProgressMonitor monitor) {
        ArrayList<NIOFSDirectory> dirList = new ArrayList<NIOFSDirectory>(pluginIndexes.length);
        HashMap<String, String[]> mergedDocs = new HashMap<String, String[]>();
        PluginIndex[] pluginIndexArray = pluginIndexes;
        int n = pluginIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            PluginIndex pluginIndex = pluginIndexArray[n2];
            List<String> indexIds = pluginIndex.getIDs();
            List<String> indexPaths = pluginIndex.getPaths();
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            int i = 0;
            while (i < indexPaths.size()) {
                block12: {
                    String indexId = indexIds.get(i);
                    String indexPath = indexPaths.get(i);
                    try {
                        NIOFSDirectory dir = new NIOFSDirectory(new File(indexPath).toPath());
                        dirList.add(dir);
                    }
                    catch (IOException ioe) {
                        Platform.getLog(this.getClass()).error("Help search indexing directory could not be created for directory " + indexPath, (Throwable)ioe);
                        break block12;
                    }
                    HelpProperties prebuiltDocs = new HelpProperties(INDEXED_DOCS_FILE, new File(indexPath));
                    prebuiltDocs.restore();
                    Set<Object> prebuiltHrefs = prebuiltDocs.keySet();
                    for (String string : prebuiltHrefs) {
                        if (i == 0) {
                            mergedDocs.put(string, null);
                            continue;
                        }
                        if (mergedDocs.containsKey(string)) {
                            String[] dups = (String[])mergedDocs.get(string);
                            if (dups == null) {
                                mergedDocs.put(string, new String[]{indexId});
                                continue;
                            }
                            String[] newDups = new String[dups.length + 1];
                            System.arraycopy(dups, 0, newDups, 0, dups.length);
                            newDups[dups.length] = indexId;
                            mergedDocs.put(string, newDups);
                            continue;
                        }
                        mergedDocs.put(string, null);
                    }
                }
                ++i;
            }
            ++n2;
        }
        for (String doc : mergedDocs.keySet()) {
            this.indexedDocs.put(doc, "0");
        }
        Directory[] luceneDirs = dirList.toArray(new Directory[dirList.size()]);
        try {
            this.iw.addIndexes(luceneDirs);
            this.iw.forceMerge(1, true);
        }
        catch (IOException ioe) {
            Platform.getLog(this.getClass()).error("Merging search indexes failed.", (Throwable)ioe);
            return new HashMap<String, String[]>();
        }
        return mergedDocs;
    }

    public IStatus removeDuplicates(String name, String[] index_paths) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DirectoryReader ar = DirectoryReader.open((Directory)this.luceneDirectory);){
                PostingsEnum hrefDocs = null;
                PostingsEnum indexDocs = null;
                Term hrefTerm = new Term(FIELD_NAME, name);
                String[] stringArray = index_paths;
                int n = index_paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String index_path = stringArray[n2];
                    Term indexTerm = new Term(FIELD_INDEX_ID, index_path);
                    List leaves = ar.leaves();
                    for (LeafReaderContext c : leaves) {
                        indexDocs = c.reader().postings(indexTerm);
                        hrefDocs = c.reader().postings(hrefTerm);
                        this.removeDocuments(hrefDocs, indexDocs);
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            return new Status(4, "org.eclipse.help.base", 4, "IO exception occurred while removing duplicates of document " + name + " from index " + this.indexDir.getAbsolutePath() + ".", (Throwable)ioe);
        }
        return Status.OK_STATUS;
    }

    private void removeDocuments(PostingsEnum doc1, PostingsEnum docs2) throws IOException {
        if (doc1.nextDoc() == Integer.MAX_VALUE) {
            return;
        }
        if (docs2.nextDoc() == Integer.MAX_VALUE) {
            return;
        }
        while (true) {
            if (doc1.docID() < docs2.docID() ? doc1.advance(docs2.docID()) == Integer.MAX_VALUE && doc1.nextDoc() == Integer.MAX_VALUE : doc1.docID() > docs2.docID() && docs2.advance(doc1.docID()) == Integer.MAX_VALUE && doc1.nextDoc() == Integer.MAX_VALUE) {
                return;
            }
            if (doc1.docID() != docs2.docID()) continue;
            this.iw.tryDeleteDocument(this.ir, doc1.docID());
            if (doc1.nextDoc() == Integer.MAX_VALUE) {
                return;
            }
            if (docs2.nextDoc() == Integer.MAX_VALUE) break;
        }
    }

    public boolean exists() {
        return this.indexDir.exists() && !this.isInconsistent();
    }

    public void search(ISearchQuery searchQuery, ISearchHitCollector collector) throws QueryTooComplexException {
        try {
            if (this.closed) {
                return;
            }
            this.registerSearch(Thread.currentThread());
            if (this.closed) {
                return;
            }
            try {
                QueryBuilder queryBuilder = new QueryBuilder(searchQuery.getSearchWord(), this.analyzerDescriptor);
                Query luceneQuery = queryBuilder.getLuceneQuery(searchQuery.getFieldNames(), searchQuery.isFieldSearch());
                if (HelpPlugin.DEBUG_SEARCH) {
                    System.out.println("Search Query: " + luceneQuery.toString());
                }
                String highlightTerms = queryBuilder.gethighlightTerms();
                if (luceneQuery != null) {
                    if (this.searcher == null) {
                        this.openSearcher();
                    }
                    TopDocs topDocs = this.searcher.search(luceneQuery, 1000);
                    collector.addHits(LocalSearchManager.asList(topDocs, this.searcher), highlightTerms);
                }
            }
            catch (IndexSearcher.TooManyClauses tooManyClauses) {
                collector.addQTCException(new QueryTooComplexException());
            }
            catch (QueryTooComplexException qe) {
                collector.addQTCException(qe);
            }
            catch (Exception e) {
                Platform.getLog(this.getClass()).error("Exception occurred performing search for: " + searchQuery.getSearchWord() + ".", (Throwable)e);
            }
        }
        finally {
            this.unregisterSearch(Thread.currentThread());
        }
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    public PluginVersionInfo getDocPlugins() {
        if (this.docPlugins == null) {
            IExtension[] extensions;
            HashSet<String> totalIds = new HashSet<String>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.help.toc");
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                try {
                    totalIds.add(extension.getContributor().getName());
                }
                catch (InvalidRegistryObjectException invalidRegistryObjectException) {}
                ++n2;
            }
            Set<String> additionalPluginIds = BaseHelpSystem.getLocalSearchManager().getPluginsWithSearchParticipants();
            totalIds.addAll(additionalPluginIds);
            this.docPlugins = new PluginVersionInfo(INDEXED_CONTRIBUTION_INFO_FILE, totalIds, this.indexDir, !this.exists());
        }
        return this.docPlugins;
    }

    public void setDocPlugins(PluginVersionInfo docPlugins) {
        this.docPlugins = docPlugins;
    }

    public HelpProperties getIndexedDocs() {
        HelpProperties indexedDocs = new HelpProperties(INDEXED_DOCS_FILE, this.indexDir);
        if (this.exists()) {
            indexedDocs.restore();
        }
        return indexedDocs;
    }

    private HelpProperties getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new HelpProperties(DEPENDENCIES_VERSION_FILENAME, this.indexDir);
            this.dependencies.restore();
        }
        return this.dependencies;
    }

    private boolean isLuceneCompatible() {
        String usedLuceneVersion = this.getDependencies().getProperty(DEPENDENCIES_KEY_LUCENE);
        return this.isLuceneCompatible(usedLuceneVersion);
    }

    public boolean isLuceneCompatible(String indexVersionString) {
        if (indexVersionString == null) {
            return false;
        }
        Version nativeLuceneVersion = Version.LATEST;
        org.osgi.framework.Version luceneVersion = new org.osgi.framework.Version(nativeLuceneVersion.toString());
        org.osgi.framework.Version indexVersion = new org.osgi.framework.Version(indexVersionString);
        org.osgi.framework.Version luceneMajMin = new org.osgi.framework.Version(nativeLuceneVersion.major, nativeLuceneVersion.minor, 0);
        if (indexVersion.compareTo(luceneMajMin) < 0) {
            return false;
        }
        if (luceneVersion.compareTo(indexVersion) >= 0) {
            return true;
        }
        return luceneVersion.getMajor() == indexVersion.getMajor() && luceneVersion.getMinor() == indexVersion.getMinor() && luceneVersion.getMicro() == indexVersion.getMicro();
    }

    private boolean isAnalyzerCompatible() {
        String usedAnalyzer = this.getDependencies().getProperty(DEPENDENCIES_KEY_ANALYZER);
        return this.isAnalyzerCompatible(usedAnalyzer);
    }

    public boolean isAnalyzerCompatible(String analyzerId) {
        if (analyzerId == null) {
            analyzerId = "";
        }
        return this.analyzerDescriptor.isCompatible(analyzerId);
    }

    private void saveDependencies() {
        this.getDependencies().put(DEPENDENCIES_KEY_ANALYZER, this.analyzerDescriptor.getId());
        Bundle luceneBundle = Platform.getBundle((String)LUCENE_BUNDLE_ID);
        if (luceneBundle != null) {
            String luceneBundleVersion = (String)luceneBundle.getHeaders().get("Bundle-Version");
            this.getDependencies().put(DEPENDENCIES_KEY_LUCENE, luceneBundleVersion);
        } else {
            this.getDependencies().put(DEPENDENCIES_KEY_LUCENE, "");
        }
        this.getDependencies().save();
    }

    public boolean isInconsistent() {
        if (this.inconsistencyFile.exists()) {
            return true;
        }
        return !this.isLuceneCompatible() || !this.isAnalyzerCompatible();
    }

    public void setInconsistent(boolean inconsistent) {
        if (inconsistent) {
            try {
                Throwable throwable = null;
                Object var3_3 = null;
                try {
                    FileOutputStream fos = new FileOutputStream(this.inconsistencyFile);
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        } else {
            this.inconsistencyFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openSearcher() throws IOException {
        Object object = this.searcherCreateLock;
        synchronized (object) {
            if (this.searcher == null) {
                this.searcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)this.luceneDirectory));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closed = true;
        while (true) {
            Collection<Thread> collection = this.searches;
            synchronized (collection) {
                if (this.searches.isEmpty()) {
                    if (this.searcher != null) {
                        try {
                            this.searcher.getIndexReader().close();
                        }
                        catch (IOException iOException) {}
                    }
                    break;
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * Exception decompiling
     */
    private void unzipProductIndex() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[DOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cleanOldIndex() {
        try {
            Throwable throwable = null;
            Object var2_2 = null;
            try {
                LimitTokenCountAnalyzer analyzer = new LimitTokenCountAnalyzer(this.analyzerDescriptor.getAnalyzer(), 10000);
                try {
                    IndexWriter cleaner = new IndexWriter(this.luceneDirectory, new IndexWriterConfig((Analyzer)analyzer).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
                    if (cleaner != null) {
                        cleaner.close();
                    }
                    if (analyzer == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (analyzer == null) throw throwable;
                    analyzer.close();
                    throw throwable;
                }
                analyzer.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    public synchronized boolean needsUpdating() {
        if (!this.exists()) {
            return true;
        }
        return this.getDocPlugins().detectChange();
    }

    public TocManager getTocManager() {
        return this.tocManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSearch(Thread t) {
        Collection<Thread> collection = this.searches;
        synchronized (collection) {
            this.searches.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterSearch(Thread t) {
        Collection<Thread> collection = this.searches;
        synchronized (collection) {
            this.searches.remove(t);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public synchronized boolean tryLock() throws OverlappingFileLockException {
        block8: {
            if ("none".equals(System.getProperty("osgi.locking"))) {
                return true;
            }
            if (this.lock != null) {
                throw new OverlappingFileLockException();
            }
            File lockFile = this.getLockFile();
            lockFile.getParentFile().mkdirs();
            this.raf = new RandomAccessFile(lockFile, "rw");
            FileLock l = this.raf.getChannel().tryLock();
            if (l == null) break block8;
            this.lock = l;
            return true;
        }
        try {
            this.logLockFailure(null);
        }
        catch (IOException ioe) {
            this.lock = null;
            this.logLockFailure(ioe);
        }
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {}
            this.raf = null;
        }
        return false;
    }

    private void logLockFailure(IOException ioe) {
        if (!errorReported) {
            Platform.getLog(this.getClass()).error("Unable to Lock Help Search Index", (Throwable)ioe);
            errorReported = true;
        }
    }

    private File getLockFile() {
        return new File(this.indexDir.getParentFile(), String.valueOf(this.locale) + ".lock");
    }

    public synchronized boolean deleteLockFile() {
        if (this.lock != null) {
            return false;
        }
        File lockFile = this.getLockFile();
        if (lockFile.exists()) {
            return lockFile.delete();
        }
        return true;
    }

    public synchronized void releaseLock() {
        if (this.lock != null) {
            try {
                this.lock.channel().close();
            }
            catch (IOException iOException) {}
            this.lock = null;
        }
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {}
            this.raf = null;
        }
    }

    public static String getIndexableHref(String url) {
        String fileName = url.toLowerCase(Locale.ENGLISH);
        if (!(fileName.endsWith(".htm") || fileName.endsWith(".html") || fileName.endsWith(".xhtml") || fileName.endsWith(".xml") || fileName.endsWith(".txt"))) {
            if (fileName.contains(".htm#") || fileName.contains(".html#") || fileName.contains(".xhtml#") || fileName.contains(".xml#")) {
                url = url.substring(0, url.lastIndexOf(35));
            } else {
                return BaseHelpSystem.getLocalSearchManager().isIndexable(url) ? url : null;
            }
        }
        return url;
    }

    public static URL getIndexableURL(String locale, String url) {
        return SearchIndex.getIndexableURL(locale, url, null, null);
    }

    public static URL getIndexableURL(String locale, String url, String id, String participantId) {
        if (participantId == null) {
            url = SearchIndex.getIndexableHref(url);
        }
        if (url == null) {
            return null;
        }
        try {
            StringBuilder query = new StringBuilder();
            query.append("?");
            query.append("lang=" + locale);
            if (id != null) {
                query.append("&id=" + id);
            }
            if (participantId != null) {
                query.append("&participantId=" + participantId);
            }
            return new URL("localhelp", null, -1, String.valueOf(url) + query.toString(), HelpURLStreamHandler.getDefault());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public IStatus addDocument(String pluginId, String name, URL url, String id, Document doc) {
        SearchParticipant participant = BaseHelpSystem.getLocalSearchManager().getParticipant(pluginId, name);
        if (participant != null) {
            try {
                return participant.addDocument(this, pluginId, name, url, id, new LuceneSearchDocument(doc));
            }
            catch (Throwable t) {
                return new Status(4, "org.eclipse.help.base", 4, "Error while adding document to search participant (addDocument()): " + name + ", " + url + "for participant " + participant.getClass().getName(), t);
            }
        }
        return this.htmlSearchParticipant.addDocument(this, pluginId, name, url, id, new LuceneSearchDocument(doc));
    }

    @Override
    public IStatus addSearchableDocument(String pluginId, String name, URL url, String id, ISearchDocument doc) {
        LuceneSearchDocument luceneDoc = (LuceneSearchDocument)doc;
        return this.addDocument(pluginId, name, url, id, luceneDoc.getDocument());
    }
}

