/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.theme.css;

import org.eclipse.tm4e.core.internal.theme.css.CSSValueImpl;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

final class Measure
extends CSSValueImpl {
    private final LexicalUnit value;

    Measure(LexicalUnit value) {
        this.value = value;
    }

    @Override
    public float getFloatValue(short valueType) throws DOMException {
        if (this.value.getLexicalUnitType() == 13) {
            return this.value.getIntegerValue();
        }
        return this.value.getFloatValue();
    }

    @Override
    public String getStringValue() throws DOMException {
        short lexicalUnit = this.value.getLexicalUnitType();
        if (lexicalUnit == 35 || lexicalUnit == 36 || lexicalUnit == 24) {
            return this.value.getStringValue();
        }
        throw new UnsupportedOperationException("NOT YET IMPLEMENTED");
    }

    @Override
    public short getPrimitiveType() {
        return switch (this.value.getLexicalUnitType()) {
            case 35 -> 21;
            case 13, 14 -> 1;
            case 24 -> 20;
            case 23 -> 2;
            case 17 -> 5;
            case 19 -> 6;
            case 15 -> 3;
            case 16 -> 4;
            case 18 -> 8;
            case 36 -> 19;
            case 42 -> 18;
            case 0 -> 3;
            case 12 -> 0;
            default -> throw new UnsupportedOperationException("NOT YET IMPLEMENTED - LexicalUnit type: " + this.value.getLexicalUnitType());
        };
    }

    @Override
    public String getCssText() {
        return switch (this.value.getLexicalUnitType()) {
            case 13 -> String.valueOf(this.value.getIntegerValue());
            case 14 -> String.valueOf(this.value.getFloatValue());
            case 15, 16, 17, 18, 19, 21, 22, 23, 28 -> String.valueOf(String.valueOf(this.value.getFloatValue())) + this.value.getDimensionUnitText();
            case 24 -> "url(" + this.value.getStringValue() + ")";
            case 0 -> ",";
            case 12 -> "inherit";
            default -> this.value.getStringValue();
        };
    }
}

