/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.merge;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.commit.RepositoryCommitOpener;
import org.eclipse.egit.ui.internal.dialogs.CleanupUncomittedChangesDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class MergeResultDialog
extends Dialog {
    private static final String SPACE = " ";
    private final MergeResult mergeResult;
    private final Repository repository;
    private ObjectReader objectReader;

    public static Dialog getDialog(Shell parentShell, Repository repository, MergeResult mergeResult) {
        if (mergeResult.getMergeStatus() == MergeResult.MergeStatus.CHECKOUT_CONFLICT) {
            return new CleanupUncomittedChangesDialog(parentShell, UIText.BranchResultDialog_CheckoutConflictsTitle, UIText.AbstractRebaseCommandHandler_cleanupDialog_text, repository, mergeResult.getCheckoutConflicts(), false);
        }
        return new MergeResultDialog(parentShell, repository, mergeResult);
    }

    public MergeResultDialog(Shell parentShell, Repository repository, MergeResult mergeResult) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.repository = repository;
        this.mergeResult = mergeResult;
        this.objectReader = repository.newObjectReader();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true).setFocus();
    }

    public Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label resultLabel = new Label(composite, 0);
        resultLabel.setText(UIText.MergeResultDialog_result);
        resultLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Text resultText = new Text(composite, 8);
        MergeResult.MergeStatus status = this.mergeResult.getMergeStatus();
        resultText.setText(status.toString());
        resultText.setSelection(resultText.getCaretPosition());
        resultText.setLayoutData((Object)new GridData(4, 4, true, false));
        if (status == MergeResult.MergeStatus.FAILED) {
            resultText.setForeground(parent.getDisplay().getSystemColor(3));
            StringBuilder paths = new StringBuilder();
            Label pathsLabel = new Label(composite, 0);
            pathsLabel.setText(UIText.MergeResultDialog_failed);
            pathsLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
            Text pathsText = new Text(composite, 10);
            pathsText.setLayoutData((Object)new GridData(4, 4, false, false));
            Set failedPaths = this.mergeResult.getFailingPaths().entrySet();
            int n = 0;
            for (Map.Entry e : failedPaths) {
                if (n > 0) {
                    paths.append(Text.DELIMITER);
                }
                paths.append(e.getValue());
                paths.append("\t");
                paths.append((String)e.getKey());
                if (++n > 10 && failedPaths.size() > 15) break;
            }
            if (n < failedPaths.size()) {
                paths.append(Text.DELIMITER);
                paths.append(MessageFormat.format(UIText.MergeResultDialog_nMore, n - failedPaths.size()));
            }
            pathsText.setText(paths.toString());
        }
        if (status == MergeResult.MergeStatus.FAST_FORWARD || status == MergeResult.MergeStatus.FAST_FORWARD_SQUASHED || status == MergeResult.MergeStatus.MERGED) {
            Label newHeadLabel = new Label(composite, 0);
            newHeadLabel.setText(UIText.MergeResultDialog_newHead);
            newHeadLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            Text newHeadText = new Text(composite, 8);
            ObjectId newHead = this.mergeResult.getNewHead();
            if (newHead != null) {
                newHeadText.setText(String.valueOf(this.getCommitMessage(newHead)) + SPACE + this.abbreviate(this.mergeResult.getNewHead(), true));
            }
            newHeadText.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        Label mergeInputLabel = new Label(composite, 0);
        mergeInputLabel.setText(UIText.MergeResultDialog_mergeInput);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).span(2, 1).applyTo((Control)mergeInputLabel);
        TableViewer viewer = new TableViewer(composite);
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer theViewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return MergeResultDialog.this.getCommits(MergeResultDialog.this.mergeResult.getMergedCommits());
            }
        });
        DelegatingStyledCellLabelProvider.IStyledLabelProvider styleProvider = new DelegatingStyledCellLabelProvider.IStyledLabelProvider(){
            private final WorkbenchLabelProvider wrapped = new WorkbenchLabelProvider();

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
                this.wrapped.dispose();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public StyledString getStyledText(Object element) {
                if (element instanceof RepositoryCommit) {
                    return ((RepositoryCommit)((Object)element)).getStyledText(element);
                }
                return new StyledString(this.wrapped.getText(element));
            }

            public Image getImage(Object element) {
                return this.wrapped.getImage(element);
            }
        };
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider(styleProvider));
        MergeResultDialog.applyDialogFont((Control)composite);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).span(2, 1).applyTo(viewer.getControl());
        viewer.setInput((Object)this.mergeResult);
        RepositoryCommitOpener.setup((StructuredViewer)viewer);
        return composite;
    }

    public static String getStatusText(MergeResult.MergeStatus mergeStatus) {
        switch (mergeStatus) {
            case FAST_FORWARD: {
                return UIText.MergeResultDialog_StatusFastForward;
            }
            case FAST_FORWARD_SQUASHED: {
                return UIText.MergeResultDialog_StatusFastForwardSquashed;
            }
            case ALREADY_UP_TO_DATE: {
                return UIText.MergeResultDialog_StatusAlreadyUpToDate;
            }
            case FAILED: {
                return UIText.MergeResultDialog_StatusFailed;
            }
            case MERGED: {
                return UIText.MergeResultDialog_StatusMerged;
            }
            case MERGED_SQUASHED: {
                return UIText.MergeResultDialog_StatusMergedSquashed;
            }
            case MERGED_SQUASHED_NOT_COMMITTED: {
                return UIText.MergeResultDialog_StatusMergedSquashedNotCommitted;
            }
            case CONFLICTING: {
                return UIText.MergeResultDialog_StatusConflicting;
            }
            case ABORTED: {
                return UIText.MergeResultDialog_StatusAborted;
            }
            case MERGED_NOT_COMMITTED: {
                return UIText.MergeResultDialog_StatusMergedNotCommitted;
            }
            case NOT_SUPPORTED: {
                return UIText.MergeResultDialog_StatusNotSupported;
            }
            case CHECKOUT_CONFLICT: {
                return UIText.MergeResultDialog_StatusCheckoutConflict;
            }
        }
        return mergeStatus.toString();
    }

    private RepositoryCommit[] getCommits(ObjectId[] merges) {
        ArrayList<RepositoryCommit> commits = new ArrayList<RepositoryCommit>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (RevWalk walk = new RevWalk(this.objectReader);){
            walk.setRetainBody(true);
            ObjectId[] objectIdArray = merges;
            int n = merges.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectId merge = objectIdArray[n2];
                try {
                    if (merge != null) {
                        commits.add(new RepositoryCommit(this.repository, walk.parseCommit((AnyObjectId)merge)));
                    }
                }
                catch (IOException e) {
                    Activator.logError(MessageFormat.format(UIText.MergeResultDialog_couldNotFindCommit, merge.name()), e);
                }
                ++n2;
            }
            return commits.toArray(new RepositoryCommit[0]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getCommitMessage(ObjectId id) {
        RevCommit commit;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (RevWalk rw = new RevWalk(this.objectReader);){
                commit = rw.parseCommit((AnyObjectId)id);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.logError(UIText.MergeResultDialog_couldNotFindCommit, e);
            return UIText.MergeResultDialog_couldNotFindCommit;
        }
        return commit.getShortMessage();
    }

    private String abbreviate(ObjectId id, boolean addBrackets) {
        StringBuilder result = new StringBuilder();
        if (addBrackets) {
            result.append("[");
        }
        try {
            result.append(this.objectReader.abbreviate((AnyObjectId)id).name());
        }
        catch (IOException e) {
            result.append(id.name());
        }
        if (addBrackets) {
            result.append("]");
        }
        return result.toString();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.MergeAction_MergeResultTitle);
        newShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (MergeResultDialog.this.objectReader != null) {
                    MergeResultDialog.this.objectReader.close();
                }
            }
        });
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogBoundSettings(((Object)((Object)this)).getClass());
    }
}

