/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.databinding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.list.SimpleListProperty;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.internal.databinding.SelectionServiceListener;

public class MultiSelectionProperty<S extends ISelectionService, E>
extends SimpleListProperty<S, E> {
    private final String partId;
    private final boolean post;
    private final Object elementType;

    public MultiSelectionProperty(String partId, boolean post, Object elementType) {
        this.partId = partId;
        this.post = post;
        this.elementType = elementType;
    }

    public INativePropertyListener<S> adaptListener(ISimplePropertyListener<S, ListDiff<E>> listener) {
        return new SelectionServiceListener<S, ListDiff<E>>((IProperty)this, listener, this.partId, this.post);
    }

    public Object getElementType() {
        return this.elementType;
    }

    protected List<E> doGetList(S source) {
        ISelection selection = this.partId != null ? source.getSelection(this.partId) : source.getSelection();
        if (selection instanceof IStructuredSelection) {
            List list = ((IStructuredSelection)selection).toList();
            return new ArrayList(list);
        }
        return Collections.emptyList();
    }

    protected void doSetList(S source, List<E> list, ListDiff<E> diff) {
        throw new UnsupportedOperationException();
    }
}

