import API from '../utils/api.js';
import { Logger } from '../utils/logger.js';
import type { TspClientOptions } from '../tsp-client.js';
import type { ILogDirectoryProvider } from './logDirectoryProvider.js';
import { ITypeScriptServer } from './server.js';
import type Tracer from './tracer.js';
import type { TypeScriptVersion } from './versionProvider.js';
export declare class TypeScriptServerSpawner {
    private readonly _apiVersion;
    private readonly _logDirectoryProvider;
    private readonly _logger;
    private readonly _tracer;
    constructor(_apiVersion: API, _logDirectoryProvider: ILogDirectoryProvider, _logger: Logger, _tracer: Tracer);
    spawn(version: TypeScriptVersion, configuration: TspClientOptions): ITypeScriptServer;
    private kindToServerType;
    private getTsServerArgs;
    private isLoggingEnabled;
}
//# sourceMappingURL=spawner.d.ts.map