/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.fetch.FetchSourcePage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FetchDestinationPage
extends WizardPage {
    private final Repository repository;
    private final RemoteConfig config;
    private Text sourceText;
    private Text destinationText;
    private Button force;
    private List<Ref> trackingBranches;

    public FetchDestinationPage(Repository repository, RemoteConfig config) {
        super(FetchDestinationPage.class.getName());
        this.repository = repository;
        this.config = config;
        this.setTitle(UIText.FetchDestinationPage_PageTitle);
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        Label repositoryLabel = new Label(main, 0);
        repositoryLabel.setText(UIText.FetchDestinationPage_RepositoryLabel);
        Text repositoryText = new Text(main, 2056);
        repositoryText.setText(RepositoryUtil.INSTANCE.getRepositoryName(this.repository));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)repositoryText);
        Label sourceLabel = new Label(main, 0);
        sourceLabel.setText(UIText.FetchDestinationPage_SourceLabel);
        this.sourceText = new Text(main, 2056);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.sourceText);
        Label destinationLabel = new Label(main, 0);
        destinationLabel.setText(UIText.FetchDestinationPage_DestinationLabel);
        this.destinationText = new Text(main, 2048);
        this.destinationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FetchDestinationPage.this.checkPage();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.destinationText);
        UIUtils.addRefContentProposalToText(this.sourceText, this.repository, this::getRemoteRefs, true);
        this.force = new Button(main, 32);
        this.force.setText(UIText.FetchDestinationPage_ForceCheckbox);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.force);
        this.checkPage();
        this.destinationText.setFocus();
        this.setControl((Control)main);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            FetchSourcePage fsp = (FetchSourcePage)this.getWizard().getPreviousPage((IWizardPage)this);
            String sourceString = fsp.getSource();
            this.sourceText.setText(sourceString);
            if (sourceString.length() > 0) {
                this.destinationText.setText("refs/remotes/" + this.config.getName() + '/' + Repository.shortenRefName((String)sourceString));
            }
            this.destinationText.setFocus();
        }
    }

    public String getDestination() {
        return this.destinationText.getText();
    }

    public boolean isForce() {
        return this.force.getSelection();
    }

    private List<Ref> getRemoteRefs() {
        if (this.trackingBranches == null) {
            ArrayList<Ref> proposals = new ArrayList<Ref>();
            try {
                for (Ref ref : this.repository.getRefDatabase().getRefsByPrefix("refs/remotes/")) {
                    proposals.add(ref);
                }
                this.trackingBranches = proposals;
            }
            catch (IOException e) {
                this.setErrorMessage(UIText.FetchDestinationPage_CouldNotGetBranchesMessage);
            }
        }
        return this.trackingBranches;
    }

    private void checkPage() {
        this.setMessage(null, 2);
        this.setErrorMessage(null);
        this.setMessage(UIText.FetchDestinationPage_PageMessage);
        if (this.destinationText.getText().length() == 0) {
            this.setPageComplete(false);
            return;
        }
        boolean found = false;
        for (Ref ref : this.getRemoteRefs()) {
            if (!ref.getName().equals(this.destinationText.getText())) continue;
            found = true;
        }
        if (!found) {
            this.setMessage(NLS.bind((String)UIText.FetchDestinationPage_TrackingBranchNotFoundMessage, (Object)this.destinationText.getText()), 2);
        }
        this.setPageComplete(true);
    }
}

