/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.xml.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wildwebdeveloper.xml.InitializationOptionsProvider;
import org.eclipse.wildwebdeveloper.xml.LemminxClasspathExtensionProvider;
import org.eclipse.wildwebdeveloper.xml.internal.Activator;
import org.osgi.framework.Bundle;

public class XMLExtensionRegistry {
    private static final String EXTENSION_POINT_ID = "org.eclipse.wildwebdeveloper.xml.lemminxExtension";
    private Map<IConfigurationElement, String> extensions = new HashMap<IConfigurationElement, String>();
    private boolean outOfSync = true;

    public XMLExtensionRegistry() {
        Platform.getExtensionRegistry().addRegistryChangeListener(event -> {
            boolean bl = this.outOfSync = true;
        }, EXTENSION_POINT_ID);
    }

    public List<String> getXMLExtensionJars() {
        if (this.outOfSync) {
            this.sync();
        }
        return this.extensions.entrySet().stream().filter(extension -> ((String)extension.getValue()).endsWith(".jar")).map(extension -> {
            try {
                return new File(FileLocator.toFileURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)((IConfigurationElement)extension.getKey()).getContributor().getName()), (IPath)new Path((String)extension.getValue()))).getPath()).getAbsolutePath();
            }
            catch (IOException | InvalidRegistryObjectException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper.xml", e.getMessage(), e));
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<String> getXMLLSClassPathExtensions() {
        Map<IConfigurationElement, LemminxClasspathExtensionProvider> extensionProviders = this.getRegisteredClassPathProviders();
        ArrayList<String> classpathExtensions = new ArrayList<String>();
        extensionProviders.entrySet().stream().map(Map.Entry::getValue).map(Supplier::get).forEach(list2 -> list2.forEach(jar -> {
            boolean bl = classpathExtensions.add(jar.getAbsolutePath());
        }));
        return classpathExtensions;
    }

    /*
     * WARNING - void declaration
     */
    private Map<IConfigurationElement, LemminxClasspathExtensionProvider> getRegisteredClassPathProviders() {
        HashMap<IConfigurationElement, LemminxClasspathExtensionProvider> extensionProviders = new HashMap<IConfigurationElement, LemminxClasspathExtensionProvider>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            try {
                LemminxClasspathExtensionProvider lemminxClasspathExtensionProvider;
                Object executableExtension;
                Object object;
                if (extension.getName().equals("classpathExtensionProvider") && extension.getAttribute("provider") != null && (object = (executableExtension = extension.createExecutableExtension("provider"))) instanceof LemminxClasspathExtensionProvider && (lemminxClasspathExtensionProvider = (LemminxClasspathExtensionProvider)object) == (LemminxClasspathExtensionProvider)object) {
                    void extensionProvider;
                    extensionProviders.put(extension, (LemminxClasspathExtensionProvider)extensionProvider);
                }
            }
            catch (Exception ex) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper.xml", ex.getMessage(), (Throwable)ex));
            }
            ++n2;
        }
        return extensionProviders;
    }

    private void sync() {
        HashSet<IConfigurationElement> toRemoveExtensions = new HashSet<IConfigurationElement>(this.extensions.keySet());
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            toRemoveExtensions.remove(extension);
            if (!this.extensions.containsKey(extension)) {
                try {
                    if (extension.getAttribute("path") != null) {
                        this.extensions.put(extension, extension.getAttribute("path"));
                    }
                }
                catch (Exception ex) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper.xml", ex.getMessage(), (Throwable)ex));
                }
            }
            ++n2;
        }
        for (IConfigurationElement toRemove : toRemoveExtensions) {
            this.extensions.remove(toRemove);
        }
        this.outOfSync = false;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> getInitiatizationOptions() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            try {
                void opt;
                Map options;
                InitializationOptionsProvider initializationOptionsProvider;
                Object executableExtension;
                Object object;
                if (extension.getName().equals("initializationOptionsProvider") && extension.getAttribute("provider") != null && (object = (executableExtension = extension.createExecutableExtension("provider"))) instanceof InitializationOptionsProvider && (initializationOptionsProvider = (InitializationOptionsProvider)object) == (InitializationOptionsProvider)object && (options = (Map)opt.get()) != null) {
                    res.putAll(options);
                }
            }
            catch (Exception ex) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper.xml", ex.getMessage(), (Throwable)ex));
            }
            ++n2;
        }
        return res;
    }
}

