/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.yaml;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.SchemaAssociationRegistry;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;

public class YAMLLanguageServer
extends ProcessStreamConnectionProvider {
    private static final String YAML_KEY = "yaml";
    private static final String VALIDATE_KEY = "validate";
    private static final String COMPLETION_KEY = "completion";
    private static final String HOVER_KEY = "hover";
    private static final String SCHEMAS_KEY = "schemas";
    private static final IPreferenceStore PREFERENCE_STORE = Activator.getDefault().getPreferenceStore();
    private static final LanguageServersRegistry.LanguageServerDefinition YAML_LS_DEFINITION = LanguageServersRegistry.getInstance().getDefinition("org.eclipse.wildwebdeveloper.yaml");
    private static final IPropertyChangeListener PROPERTY_CHANGE_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("wildwebdeveloper.yaml.schema".equals(event.getProperty())) {
                HashMap<String, Map<String, Object>> settings = new HashMap<String, Map<String, Object>>();
                settings.put(YAMLLanguageServer.YAML_KEY, YAMLLanguageServer.getYamlConfigurationOptions());
                DidChangeConfigurationParams params = new DidChangeConfigurationParams(settings);
                LanguageServiceAccessor.getActiveLanguageServers(null).stream().filter(server -> YAML_LS_DEFINITION.equals(LanguageServiceAccessor.resolveServerDefinition((LanguageServer)server).get())).forEach(ls -> ls.getWorkspaceService().didChangeConfiguration(params));
            }
        }
    };

    public YAMLLanguageServer() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(NodeJSManager.getNodeJsLocation().getAbsolutePath());
        try {
            URL url = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("/node_modules/yaml-language-server/out/server/src/server.js"));
            commands.add(new File(url.getPath()).getAbsolutePath());
            commands.add("--stdio");
            this.setCommands(commands);
            this.setWorkingDirectory(System.getProperty("user.dir"));
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
    }

    public void handleMessage(Message message, LanguageServer languageServer, URI rootUri) {
        if (message instanceof ResponseMessage var4_5 && responseMessage.getResult() instanceof InitializeResult) {
            HashMap<String, Map<String, Object>> settings = new HashMap<String, Map<String, Object>>();
            settings.put(YAML_KEY, YAMLLanguageServer.getYamlConfigurationOptions());
            DidChangeConfigurationParams params = new DidChangeConfigurationParams(settings);
            languageServer.getWorkspaceService().didChangeConfiguration(params);
        }
    }

    static Map<String, Object> getYamlConfigurationOptions() {
        HashMap<String, Object> yaml = new HashMap<String, Object>();
        yaml.put(SCHEMAS_KEY, YAMLLanguageServer.getSchemaAssociations());
        yaml.put(VALIDATE_KEY, true);
        yaml.put(COMPLETION_KEY, true);
        yaml.put(HOVER_KEY, true);
        yaml.put("schemaStore.enable", true);
        return yaml;
    }

    private static Map<String, Object> getSchemaAssociations() {
        IConfigurationElement[] conf;
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        String schemaString = preferenceStore.getString("wildwebdeveloper.yaml.schema");
        Map contentTypeAssociations = (Map)new Gson().fromJson(schemaString, new TypeToken<HashMap<String, String>>(){}.getType());
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType yamlBaseContentType = contentTypeManager.getContentType("org.eclipse.wildwebdeveloper.yaml");
        HashMap<String, Object> associations = new HashMap<String, Object>();
        contentTypeAssociations.forEach((key, value) -> {
            IContentType contentType = contentTypeManager.getContentType(key);
            if (contentType != null && contentType.getBaseType().equals(yamlBaseContentType)) {
                String[] fileExtensions;
                String[] filePatterns;
                String[] fileNames;
                String[] stringArray = fileNames = contentType.getFileSpecs(4);
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    associations.put(value.toString(), fileName);
                    ++n2;
                }
                String[] stringArray2 = filePatterns = contentType.getFileSpecs(16);
                int n3 = filePatterns.length;
                n = 0;
                while (n < n3) {
                    String pattern = stringArray2[n];
                    associations.put(value.toString(), pattern);
                    ++n;
                }
                String[] stringArray3 = fileExtensions = contentType.getFileSpecs(8);
                int n4 = fileExtensions.length;
                n3 = 0;
                while (n3 < n4) {
                    String extension = stringArray3[n3];
                    associations.put(value.toString(), "*." + extension);
                    ++n3;
                }
            }
        });
        IConfigurationElement[] iConfigurationElementArray = conf = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wildwebdeveloper.json.schema");
        int n = conf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            String url = el.getAttribute("url");
            String pattern = el.getAttribute("pattern");
            if (!url.isBlank() && !pattern.isBlank()) {
                associations.put(SchemaAssociationRegistry.translate(url), pattern);
            }
            ++n2;
        }
        return associations;
    }

    public String toString() {
        return "YAML Language Server: " + super.toString();
    }

    public void start() throws IOException {
        super.start();
        PREFERENCE_STORE.addPropertyChangeListener(PROPERTY_CHANGE_LISTENER);
    }

    public void stop() {
        PREFERENCE_STORE.removePropertyChangeListener(PROPERTY_CHANGE_LISTENER);
        super.stop();
    }
}

