/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.xml.internal.ui.preferences;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wildwebdeveloper.xml.internal.ui.preferences.XMLCatalogs;

public class XMLPreferenceConstants {
    public static final LemminxPreference XML_PREFERENCES_CATAGLOGS = new LemminxPreference("org.eclipse.wildwebdeveloper.xml.catalogs", "catalogs");
    public static final LemminxPreference XML_PREFERENCES_CODELENS_ENABLED = new LemminxPreference("org.eclipse.wildwebdeveloper.xml.codeLens.enabled", "codeLens/enabled");
    public static final LemminxPreference XML_PREFERENCES_VALIDATION_ENABLED = new LemminxPreference("org.eclipse.wildwebdeveloper.xml.validation.enabled", "validation/enabled");
    public static final LemminxPreference XML_PREFERENCES_VALIDATION_NAMESPACES_ENABLED = new LemminxPreference("org.eclipse.wildwebdeveloper.xml.validation.namespaces.enabled", "validation/namespaces/enabled");
    public static final LemminxPreference XML_PREFERENCES_VALIDATION_SCHEMA_ENABLED = new LemminxPreference("org.eclipse.wildwebdeveloper.xml.validation.schema.enabled", "validation/schema/enabled");
    public static final LemminxPreference XML_PREFERENCES_VALIDATION_DISALLOW_DOCTYPE_DECL = new LemminxPreference("org.eclipse.wildwebdeveloper.xml.validation.disallowDocTypeDecl", "validation/disallowDocTypeDecl");
    public static final LemminxPreference XML_PREFERENCES_VALIDATION_RESOLVE_EXTERNAL_ENTITIES = new LemminxPreference("org.eclipse.wildwebdeveloper.xml.validation.resolveExternalEntities", "validation/resolveExternalEntities");
    public static final LemminxPreference XML_PREFERENCES_VALIDATION_NO_GRAMMAR = new LemminxPreference("org.eclipse.wildwebdeveloper.xml.validation.noGrammar", "validation/noGrammar");
    private static final LemminxPreference[] ALL_LEMMINX_PREFERENCES = new LemminxPreference[]{XML_PREFERENCES_CATAGLOGS, XML_PREFERENCES_CODELENS_ENABLED, XML_PREFERENCES_VALIDATION_ENABLED, XML_PREFERENCES_VALIDATION_NAMESPACES_ENABLED, XML_PREFERENCES_VALIDATION_SCHEMA_ENABLED, XML_PREFERENCES_VALIDATION_DISALLOW_DOCTYPE_DECL, XML_PREFERENCES_VALIDATION_RESOLVE_EXTERNAL_ENTITIES, XML_PREFERENCES_VALIDATION_NO_GRAMMAR};

    public static Optional<LemminxPreference> getLemminxPreference(PropertyChangeEvent event) {
        return Arrays.stream(ALL_LEMMINX_PREFERENCES).filter(pref -> Objects.equals(pref.preferenceId, event.getProperty())).findAny();
    }

    private XMLPreferenceConstants() {
    }

    public static void storePreferencesToLemminxOptions(IPreferenceStore store, Map<String, Object> xmlOpts) {
        XML_PREFERENCES_CATAGLOGS.storeToLemminxOptions(XMLCatalogs.getAllCatalogs(store).stream().map(File::getAbsolutePath).toArray(String[]::new), xmlOpts);
        XML_PREFERENCES_CODELENS_ENABLED.storeToLemminxOptions(store.getBoolean(XMLPreferenceConstants.XML_PREFERENCES_CODELENS_ENABLED.preferenceId), xmlOpts);
        XML_PREFERENCES_VALIDATION_ENABLED.storeToLemminxOptions(store.getBoolean(XMLPreferenceConstants.XML_PREFERENCES_VALIDATION_ENABLED.preferenceId), xmlOpts);
        XML_PREFERENCES_VALIDATION_NAMESPACES_ENABLED.storeToLemminxOptions(store.getString(XMLPreferenceConstants.XML_PREFERENCES_VALIDATION_NAMESPACES_ENABLED.preferenceId), xmlOpts);
        XML_PREFERENCES_VALIDATION_SCHEMA_ENABLED.storeToLemminxOptions(store.getString(XMLPreferenceConstants.XML_PREFERENCES_VALIDATION_SCHEMA_ENABLED.preferenceId), xmlOpts);
        XML_PREFERENCES_VALIDATION_DISALLOW_DOCTYPE_DECL.storeToLemminxOptions(store.getBoolean(XMLPreferenceConstants.XML_PREFERENCES_VALIDATION_DISALLOW_DOCTYPE_DECL.preferenceId), xmlOpts);
        XML_PREFERENCES_VALIDATION_RESOLVE_EXTERNAL_ENTITIES.storeToLemminxOptions(store.getBoolean(XMLPreferenceConstants.XML_PREFERENCES_VALIDATION_RESOLVE_EXTERNAL_ENTITIES.preferenceId), xmlOpts);
        XML_PREFERENCES_VALIDATION_NO_GRAMMAR.storeToLemminxOptions(store.getString(XMLPreferenceConstants.XML_PREFERENCES_VALIDATION_NO_GRAMMAR.preferenceId), xmlOpts);
    }

    public static class LemminxPreference {
        public final String preferenceId;
        public final String lemminxOptionPath;

        public LemminxPreference(String preferenceId, String lemminxOptionPath) {
            this.preferenceId = preferenceId;
            this.lemminxOptionPath = lemminxOptionPath;
        }

        public void storeToLemminxOptions(Object value, Map<String, Object> options) {
            HashMap<String, Object> result = options;
            String[] paths = this.lemminxOptionPath.split("/");
            String path = null;
            int i = 0;
            while (i < paths.length - 1) {
                path = paths[i];
                if (result.containsKey(path)) {
                    result = (HashMap<String, Object>)result.get(path);
                } else {
                    HashMap<String, Object> item = new HashMap<String, Object>();
                    result.put(path, item);
                    result = item;
                }
                ++i;
            }
            path = paths[paths.length - 1];
            result.put(path, value);
        }
    }
}

