/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.actions.IVariableValueEditor;

public class VariableValueEditorManager {
    private static final int MAX_PRIORITY = 10;
    private static final int DEFAULT_PRIORITY = 0;
    private static final String MODEL_ID = "modelId";
    private static final String PRIORITY = "priority";
    private Map<String, Object> fEditorMap = new HashMap<String, Object>();
    private static VariableValueEditorManager fgManager;

    private VariableValueEditorManager() {
        this.loadVariableEditors();
    }

    public static VariableValueEditorManager getDefault() {
        if (fgManager == null) {
            fgManager = new VariableValueEditorManager();
        }
        return fgManager;
    }

    public IVariableValueEditor getVariableValueEditor(String modelIdentifier) {
        Object object = this.fEditorMap.get(modelIdentifier);
        IVariableValueEditor editor = null;
        if (object instanceof IVariableValueEditor) {
            editor = (IVariableValueEditor)object;
        } else if (object instanceof IConfigurationElement) {
            try {
                editor = (IVariableValueEditor)((IConfigurationElement)object).createExecutableExtension("class");
                this.fEditorMap.put(modelIdentifier, editor);
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return editor;
    }

    private void loadVariableEditors() {
        IConfigurationElement[] elements;
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "variableValueEditors");
        IConfigurationElement[] iConfigurationElementArray = elements = ep.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object original;
            IConfigurationElement element = iConfigurationElementArray[n2];
            String modelId = element.getAttribute(MODEL_ID);
            if (modelId != null && (original = this.fEditorMap.put(modelId, element)) instanceof IConfigurationElement) {
                int newPrio = VariableValueEditorManager.getPriority(element);
                int oldPrio = VariableValueEditorManager.getPriority((IConfigurationElement)original);
                if (oldPrio > newPrio) {
                    this.fEditorMap.put(modelId, original);
                }
            }
            ++n2;
        }
    }

    private static int getPriority(IConfigurationElement element) {
        String attribute = element.getAttribute(PRIORITY);
        int priority = 0;
        if (attribute != null) {
            try {
                priority = Integer.parseInt(attribute);
            }
            catch (Exception e) {
                String error = "Unexpected value: '" + attribute + "' for '" + PRIORITY + "' attribute " + " in extension point '" + "variableValueEditors" + "' was specified by " + element.getNamespaceIdentifier();
                IllegalArgumentException ie = new IllegalArgumentException(error, e);
                DebugUIPlugin.log(ie);
            }
            priority = Math.max(0, priority);
            priority = Math.min(10, priority);
        }
        return priority;
    }
}

