"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.findPathToYarnSdk = exports.findPathToModule = void 0;
/*
 * Copyright (C) 2017, 2018 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
function findPathToModule(dir, moduleName) {
    try {
        return require.resolve(moduleName, { paths: [dir] });
    }
    catch (_a) {
        return undefined;
    }
}
exports.findPathToModule = findPathToModule;
function findPathToYarnSdk(dir, moduleName) {
    const stat = fs.statSync(dir);
    if (stat.isDirectory()) {
        const candidate = path.resolve(dir, '.yarn', 'sdks', moduleName);
        if (fs.existsSync(candidate)) {
            return candidate;
        }
    }
    const parent = path.resolve(dir, '..');
    if (parent !== dir) {
        return findPathToYarnSdk(parent, moduleName);
    }
}
exports.findPathToYarnSdk = findPathToYarnSdk;
//# sourceMappingURL=modules-resolver.js.map