/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
'use strict';
import { matchOffsetToDocument } from '../utils/arrUtils';
import { JSONHover } from 'vscode-json-languageservice/lib/umd/services/jsonHover';
import { setKubernetesParserOption } from '../parser/isKubernetes';
import { yamlDocumentsCache } from '../parser/yaml-documents';
export class YAMLHover {
    constructor(schemaService) {
        this.shouldHover = true;
        this.jsonHover = new JSONHover(schemaService, [], Promise);
    }
    configure(languageSettings) {
        if (languageSettings) {
            this.shouldHover = languageSettings.hover;
        }
    }
    doHover(document, position, isKubernetes = false) {
        if (!this.shouldHover || !document) {
            return Promise.resolve(undefined);
        }
        const doc = yamlDocumentsCache.getYamlDocument(document);
        const offset = document.offsetAt(position);
        const currentDoc = matchOffsetToDocument(offset, doc);
        if (currentDoc === null) {
            return Promise.resolve(undefined);
        }
        setKubernetesParserOption(doc.documents, isKubernetes);
        const currentDocIndex = doc.documents.indexOf(currentDoc);
        currentDoc.currentDocIndex = currentDocIndex;
        return this.jsonHover.doHover(document, position, currentDoc);
    }
}
//# sourceMappingURL=yamlHover.js.map