/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.persistence;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.MappingFile;
import org.eclipse.jpt.jpa.core.context.MappingFilePersistenceUnitMetadata;
import org.eclipse.jpt.jpa.core.context.MappingFileRoot;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMappingFileRef
extends AbstractPersistenceXmlContextNode
implements MappingFileRef {
    protected String fileName;
    protected MappingFile mappingFile;

    protected AbstractMappingFileRef(PersistenceUnit parent, String fileName) {
        super(parent);
        this.fileName = fileName;
        this.mappingFile = this.buildMappingFile();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncMappingFile();
    }

    @Override
    public void update() {
        super.update();
        this.updateMappingFile();
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public boolean isFor(IFile file) {
        return this.mappingFile != null && file.equals((Object)this.mappingFile.getXmlResource().getFile());
    }

    protected boolean isIn(IFolder folder) {
        return this.mappingFile != null && this.mappingFile.isIn(folder);
    }

    @Override
    public MappingFile getMappingFile() {
        return this.mappingFile;
    }

    protected void setMappingFile(MappingFile mappingFile) {
        MappingFile old = this.mappingFile;
        this.mappingFile = mappingFile;
        this.firePropertyChanged("mappingFile", old, mappingFile);
    }

    protected MappingFile buildMappingFile() {
        JpaXmlResource xmlResource = this.resolveMappingFileXmlResource();
        return xmlResource == null ? null : this.buildMappingFile(xmlResource);
    }

    protected void syncMappingFile() {
        this.syncMappingFile(true);
    }

    protected void syncMappingFile(boolean sync) {
        JpaXmlResource newXmlResource = this.resolveMappingFileXmlResource();
        if (newXmlResource == null) {
            if (this.mappingFile != null) {
                this.mappingFile.dispose();
                this.setMappingFile(null);
            }
        } else if (this.mappingFile == null) {
            this.setMappingFile(this.buildMappingFile(newXmlResource));
        } else if (this.mappingFile.getXmlResource() == newXmlResource) {
            if (sync) {
                this.mappingFile.synchronizeWithResourceModel();
            } else {
                this.mappingFile.update();
            }
        } else {
            this.mappingFile.dispose();
            this.setMappingFile(this.buildMappingFile(newXmlResource));
        }
    }

    protected JpaXmlResource resolveMappingFileXmlResource() {
        if (this.fileName == null) {
            return null;
        }
        JpaXmlResource xmlResource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path(this.fileName));
        if (xmlResource == null) {
            return null;
        }
        if (xmlResource.isReverting()) {
            return null;
        }
        JptResourceType resourceType = xmlResource.getResourceType();
        if (resourceType == null) {
            return null;
        }
        if (!this.getJpaPlatform().supportsResourceType(resourceType)) {
            return null;
        }
        return xmlResource;
    }

    protected MappingFile buildMappingFile(JpaXmlResource xmlResource) {
        return this.getJpaFactory().buildMappingFile(this, xmlResource);
    }

    protected void updateMappingFile() {
        this.syncMappingFile(false);
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.jpa.core.persistence.mappingFileRef";
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return this;
    }

    @Override
    public void dispose() {
        if (this.mappingFile != null) {
            this.mappingFile.dispose();
        }
    }

    @Override
    public boolean persistenceUnitMetadataExists() {
        MappingFilePersistenceUnitMetadata metadata = this.getPersistenceUnitMetadata();
        return metadata != null && metadata.resourceExists();
    }

    @Override
    public MappingFilePersistenceUnitMetadata getPersistenceUnitMetadata() {
        MappingFileRoot root = this.getChildMappingFileRoot();
        return root == null ? null : root.getPersistenceUnitMetadata();
    }

    protected MappingFileRoot getChildMappingFileRoot() {
        return this.mappingFile == null ? null : this.mappingFile.getRoot();
    }

    @Override
    public PersistentType getPersistentType(String typeName) {
        return this.mappingFile == null ? null : this.mappingFile.getPersistentType(typeName);
    }

    @Override
    public PersistenceUnit getParent() {
        return (PersistenceUnit)super.getParent();
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.fileName);
    }

    @Override
    public Iterable<? extends PersistentType> getPersistentTypes() {
        return this.mappingFile != null ? this.mappingFile.getPersistentTypes() : EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (StringTools.stringIsEmpty((String)this.fileName)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_UNSPECIFIED_MAPPING_FILE", this, this.getValidationTextRange()));
            return;
        }
        if (this.mappingFile == null) {
            messages.add(this.buildMappingFileValidationMessage());
            return;
        }
        this.mappingFile.validate(messages, reporter);
    }

    protected IMessage buildMappingFileValidationMessage() {
        int severity = 1;
        IFile file = this.getPlatformFile();
        if (!file.exists()) {
            return DefaultJpaValidationMessages.buildMessage(severity, "PERSISTENCE_UNIT_NONEXISTENT_MAPPING_FILE", new String[]{this.fileName}, this, this.getValidationTextRange());
        }
        String msgText = this.mappingFileContentIsUnsupported() ? "PERSISTENCE_UNIT_UNSUPPORTED_MAPPING_FILE_CONTENT" : "PERSISTENCE_UNIT_INVALID_MAPPING_FILE";
        return DefaultJpaValidationMessages.buildMessage(severity, msgText, new String[]{file.getName()}, file);
    }

    protected IFile getPlatformFile() {
        return this.getJpaProject().getPlatformFile((IPath)new Path(this.fileName));
    }

    protected boolean mappingFileContentIsUnsupported() {
        JpaXmlResource xmlResource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path(this.fileName));
        return xmlResource != null && !this.getJpaPlatform().supportsResourceType(xmlResource.getResourceType());
    }

    @Override
    public Iterable<DeleteEdit> createDeleteTypeEdits(IType type) {
        return this.mappingFile != null ? this.mappingFile.createDeleteTypeEdits(type) : EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return this.mappingFile != null ? this.mappingFile.createRenameTypeEdits(originalType, newName) : EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.mappingFile != null ? this.mappingFile.createMoveTypeEdits(originalType, newPackage) : EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.mappingFile != null ? this.mappingFile.createRenamePackageEdits(originalPackage, newName) : EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameMappingFileEdits(IFile originalFile, String newName) {
        return this.isFor(originalFile) ? new SingleElementIterable((Object)this.createRenameEdit(originalFile, newName)) : EmptyIterable.instance();
    }

    protected abstract ReplaceEdit createRenameEdit(IFile var1, String var2);

    @Override
    public Iterable<ReplaceEdit> createMoveMappingFileEdits(IFile originalFile, IPath runtineDestination) {
        return this.isFor(originalFile) ? new SingleElementIterable((Object)this.createMoveEdit(originalFile, runtineDestination)) : EmptyIterable.instance();
    }

    protected abstract ReplaceEdit createMoveEdit(IFile var1, IPath var2);
}

